/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.system;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.data.island.IslandType;
import com.nekiplay.hypixelcry.events.hypixel.IslandTypeChangeEvent;
import com.nekiplay.hypixelcry.utils.ApecUtils;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class IslandTypeChangeChecker {
    private static IslandType lastDetected = IslandType.Unknown;

    public static IslandType getLastDetected() {
        return lastDetected;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        String zone = ApecUtils.removeAllCodes(HypixelCry.dataExtractor.getScoreBoardData().Zone);
        String cleanedZone = zone.replaceAll("[^a-zA-Z\\s']", "").trim();
        IslandType current = IslandType.current();
        if (current != IslandType.Unknown && lastDetected != current) {
            if (HypixelCry.config.misc.debug.enabled && HypixelCry.mc.field_71439_g != null) {
                HypixelCry.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Location changed from: " + (Object)((Object)lastDetected) + " to: " + (Object)((Object)current) + ", zone: " + cleanedZone));
            }
            IslandTypeChangeEvent islandTypeChangeEvent = new IslandTypeChangeEvent(lastDetected, current);
            lastDetected = current;
            MinecraftForge.EVENT_BUS.post((Event)islandTypeChangeEvent);
        } else if (lastDetected != current) {
            if (HypixelCry.config.misc.debug.enabled && HypixelCry.mc.field_71439_g != null) {
                HypixelCry.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Location changed from: " + (Object)((Object)lastDetected) + " to: " + (Object)((Object)current) + ", zone: " + cleanedZone));
            }
            lastDetected = current;
        }
    }
}

