/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.pathfinder.calculate.path;

import com.nekiplay.hypixelcry.pathfinder.calculate.Path;
import com.nekiplay.hypixelcry.pathfinder.calculate.PathNode;
import com.nekiplay.hypixelcry.pathfinder.calculate.openset.BinaryHeapOpenSet;
import com.nekiplay.hypixelcry.pathfinder.goal.Goal;
import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import com.nekiplay.hypixelcry.pathfinder.movement.MovementResult;
import com.nekiplay.hypixelcry.pathfinder.movement.Moves;
import com.nekiplay.hypixelcry.pathfinder.util.RefKt;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ&\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0006\u0010%\u001a\u00020&R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/nekiplay/hypixelcry/pathfinder/calculate/path/AStarPathFinder;", "", "startX", "", "startY", "startZ", "goal", "Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "ctx", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "(IIILcom/nekiplay/hypixelcry/pathfinder/goal/Goal;Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;)V", "calculating", "", "closedSet", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "closestDistance", "", "closestNode", "getCtx", "()Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "getGoal", "()Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "iterations", "getStartX", "()I", "getStartY", "getStartZ", "calculatePath", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/Path;", "getNode", "x", "y", "z", "hash", "", "isChunkLoaded", "requestStop", "", "HypixelCry"})
public final class AStarPathFinder {
    private final int startX;
    private final int startY;
    private final int startZ;
    @NotNull
    private final Goal goal;
    @NotNull
    private final CalculationContext ctx;
    @NotNull
    private final Long2ObjectMap<PathNode> closedSet;
    private boolean calculating;
    @Nullable
    private PathNode closestNode;
    private double closestDistance;
    private int iterations;

    public AStarPathFinder(int startX, int startY, int startZ, @NotNull Goal goal, @NotNull CalculationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.goal = goal;
        this.ctx = ctx;
        this.closedSet = new Long2ObjectOpenHashMap();
        this.closestDistance = Double.MAX_VALUE;
    }

    public final int getStartX() {
        return this.startX;
    }

    public final int getStartY() {
        return this.startY;
    }

    public final int getStartZ() {
        return this.startZ;
    }

    @NotNull
    public final Goal getGoal() {
        return this.goal;
    }

    @NotNull
    public final CalculationContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public final Path calculatePath() {
        this.calculating = true;
        this.iterations = 0;
        BinaryHeapOpenSet openSet = new BinaryHeapOpenSet(0, 1, null);
        PathNode startNode = new PathNode(this.startX, this.startY, this.startZ, this.goal);
        MovementResult res = new MovementResult();
        Moves[] moves = Moves.values();
        startNode.setCostSoFar(0.0);
        startNode.setTotalCost(startNode.getCostToEnd());
        openSet.add(startNode);
        this.closestNode = startNode;
        this.closestDistance = startNode.getCostToEnd();
        while (!openSet.isEmpty() && this.calculating && this.iterations < this.ctx.getMaxIterations()) {
            int n = this.iterations;
            this.iterations = n + 1;
            if (this.iterations % this.ctx.getStepSize() != 0) continue;
            PathNode currentNode = openSet.poll();
            if (currentNode.getCostToEnd() < this.closestDistance) {
                this.closestNode = currentNode;
                this.closestDistance = currentNode.getCostToEnd();
            }
            if (this.goal.isAtGoal(currentNode.getX(), currentNode.getY(), currentNode.getZ())) {
                return new Path(startNode, currentNode, this.goal, this.ctx);
            }
            if (!this.isChunkLoaded(currentNode.getX(), currentNode.getY(), currentNode.getZ())) {
                return new Path(startNode, currentNode, this.goal, this.ctx);
            }
            for (Moves move : moves) {
                double cost;
                res.reset();
                move.calculate(this.ctx, currentNode.getX(), currentNode.getY(), currentNode.getZ(), res);
                if (!this.isChunkLoaded(res.getX(), res.getY(), res.getZ())) {
                    res.setCost(this.ctx.getCost().getINF_COST());
                }
                if ((cost = res.getCost()) >= this.ctx.getCost().getINF_COST()) continue;
                PathNode neighbourNode = this.getNode(res.getX(), res.getY(), res.getZ(), PathNode.Companion.longHash(res.getX(), res.getY(), res.getZ()));
                double neighbourCostSoFar = currentNode.getCostSoFar() + cost;
                if (!(neighbourNode.getCostSoFar() > neighbourCostSoFar)) continue;
                neighbourNode.setParentNode(currentNode);
                neighbourNode.setCostSoFar(neighbourCostSoFar);
                neighbourNode.setTotalCost(neighbourCostSoFar + neighbourNode.getCostToEnd());
                if (neighbourNode.getHeapPosition() == -1) {
                    openSet.add(neighbourNode);
                    continue;
                }
                openSet.relocate(neighbourNode);
            }
        }
        this.calculating = false;
        PathNode pathNode = this.closestNode;
        if (pathNode != null) {
            PathNode it = pathNode;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)startNode)) {
                return new Path(startNode, it, this.goal, this.ctx);
            }
        }
        return null;
    }

    private final boolean isChunkLoaded(int x, int y, int z) {
        WorldClient worldClient = RefKt.getMc().field_71441_e;
        return worldClient != null ? worldClient.func_175667_e(new BlockPos(x, y, z)) : false;
    }

    @NotNull
    public final PathNode getNode(int x, int y, int z, long hash) {
        PathNode n = (PathNode)this.closedSet.get(hash);
        if (n == null) {
            n = new PathNode(x, y, z, this.goal);
            this.closedSet.put(hash, n);
        }
        return n;
    }

    public final void requestStop() {
        if (!this.calculating) {
            return;
        }
        this.calculating = false;
    }
}

