/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.mixins.client.MinecraftAccessor;
import com.nekiplay.hypixelcry.utils.helper.Angle;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class AngleUtils {
    private static final double randomAddition = Math.random() * 0.3 - 0.15;

    public static float get360RotationYaw(float yaw) {
        return (yaw % 360.0f + 360.0f) % 360.0f;
    }

    public static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle <= -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static float normalizeYaw(float yaw) {
        float newYaw = yaw % 360.0f;
        if (newYaw < -180.0f) {
            newYaw += 360.0f;
        }
        if (newYaw > 180.0f) {
            newYaw -= 360.0f;
        }
        return newYaw;
    }

    public static float get360RotationYaw() {
        if (HypixelCry.mc.field_71439_g == null) {
            return 0.0f;
        }
        return AngleUtils.get360RotationYaw(HypixelCry.mc.field_71439_g.field_70177_z);
    }

    public static float clockwiseDifference(float initialYaw360, float targetYaw360) {
        return AngleUtils.get360RotationYaw(targetYaw360 - initialYaw360);
    }

    public static Vec3 getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static float antiClockwiseDifference(float initialYaw360, float targetYaw360) {
        return AngleUtils.get360RotationYaw(initialYaw360 - targetYaw360);
    }

    public static float smallestAngleDifference(float initialYaw360, float targetYaw360) {
        return Math.min(AngleUtils.clockwiseDifference(initialYaw360, targetYaw360), AngleUtils.antiClockwiseDifference(initialYaw360, targetYaw360));
    }

    public static float getActualYawFrom360(float yaw360) {
        float currentYaw = yaw360;
        if (HypixelCry.mc.field_71439_g.field_70177_z > yaw360) {
            while ((HypixelCry.mc.field_71439_g.field_70177_z - currentYaw < 180.0f || HypixelCry.mc.field_71439_g.field_70177_z - currentYaw > 0.0f) && Math.abs(currentYaw + 360.0f - HypixelCry.mc.field_71439_g.field_70177_z) < Math.abs(currentYaw - HypixelCry.mc.field_71439_g.field_70177_z)) {
                currentYaw += 360.0f;
            }
        }
        if (HypixelCry.mc.field_71439_g.field_70177_z < yaw360) {
            while ((currentYaw - HypixelCry.mc.field_71439_g.field_70177_z > 180.0f || HypixelCry.mc.field_71439_g.field_70177_z - currentYaw < 0.0f) && Math.abs(currentYaw - 360.0f - HypixelCry.mc.field_71439_g.field_70177_z) < Math.abs(currentYaw - HypixelCry.mc.field_71439_g.field_70177_z)) {
                currentYaw -= 360.0f;
            }
        }
        return currentYaw;
    }

    public static float getClosestDiagonal() {
        return AngleUtils.getClosestDiagonal(AngleUtils.get360RotationYaw());
    }

    public static float getClosestDiagonal(float yaw) {
        if (AngleUtils.get360RotationYaw(yaw) < 90.0f && AngleUtils.get360RotationYaw(yaw) > 0.0f) {
            return 45.0f;
        }
        if (AngleUtils.get360RotationYaw(yaw) < 180.0f) {
            return 135.0f;
        }
        if (AngleUtils.get360RotationYaw(yaw) < 270.0f) {
            return 225.0f;
        }
        return 315.0f;
    }

    public static float getClosest30() {
        if (AngleUtils.get360RotationYaw() < 45.0f) {
            return 30.0f;
        }
        if (AngleUtils.get360RotationYaw() < 90.0f) {
            return 60.0f;
        }
        if (AngleUtils.get360RotationYaw() < 135.0f) {
            return 120.0f;
        }
        if (AngleUtils.get360RotationYaw() < 180.0f) {
            return 150.0f;
        }
        if (AngleUtils.get360RotationYaw() < 225.0f) {
            return 210.0f;
        }
        if (AngleUtils.get360RotationYaw() < 270.0f) {
            return 240.0f;
        }
        if (AngleUtils.get360RotationYaw() < 315.0f) {
            return 300.0f;
        }
        return 330.0f;
    }

    public static float getClosest45(float inputAngle) {
        float normalizedAngle = (inputAngle % 360.0f + 360.0f) % 360.0f;
        float remainder = normalizedAngle % 45.0f;
        if ((double)remainder <= 22.5) {
            return (float)(Math.floor(normalizedAngle / 45.0f) * 45.0);
        }
        return (float)(Math.ceil(normalizedAngle / 45.0f) * 45.0);
    }

    public static float getClosest() {
        if (AngleUtils.get360RotationYaw() < 45.0f || AngleUtils.get360RotationYaw() > 315.0f) {
            return 0.0f;
        }
        if (AngleUtils.get360RotationYaw() < 135.0f) {
            return 90.0f;
        }
        if (AngleUtils.get360RotationYaw() < 225.0f) {
            return 180.0f;
        }
        return 270.0f;
    }

    public static float getClosest(float yaw) {
        if (AngleUtils.get360RotationYaw(yaw) < 45.0f || AngleUtils.get360RotationYaw(yaw) > 315.0f) {
            return 0.0f;
        }
        if (AngleUtils.get360RotationYaw(yaw) < 135.0f) {
            return 90.0f;
        }
        if (AngleUtils.get360RotationYaw(yaw) < 225.0f) {
            return 180.0f;
        }
        return 270.0f;
    }

    public static Angle getRotation(Vec3 to) {
        return AngleUtils.getRotation(HypixelCry.mc.field_71439_g.func_174824_e(((MinecraftAccessor)HypixelCry.mc).getTimer().field_74281_c), to);
    }

    public static Angle getRotation(Entity to) {
        return AngleUtils.getRotation(HypixelCry.mc.field_71439_g.func_174824_e(((MinecraftAccessor)HypixelCry.mc).getTimer().field_74281_c), to.func_174791_d().func_72441_c(0.0, Math.min((double)to.field_70131_O * 0.85 + randomAddition, 1.7), 0.0));
    }

    public static Angle getRotation(BlockPos pos) {
        return AngleUtils.getRotation(HypixelCry.mc.field_71439_g.func_174824_e(((MinecraftAccessor)HypixelCry.mc).getTimer().field_74281_c), new Vec3((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
    }

    public static Angle getRotation(Vec3 from, BlockPos pos) {
        return AngleUtils.getRotation(from, new Vec3((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
    }

    public static Angle getRotation(Vec3 from, Vec3 to) {
        double xDiff = to.field_72450_a - from.field_72450_a;
        double yDiff = to.field_72448_b - from.field_72448_b;
        double zDiff = to.field_72449_c - from.field_72449_c;
        double dist = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        float yaw = (float)Math.toDegrees(Math.atan2(zDiff, xDiff)) - 90.0f;
        float pitch = (float)(-Math.toDegrees(Math.atan2(yDiff, dist)));
        return new Angle(yaw, pitch);
    }

    public static Angle getNeededChange(Angle startAngle, Angle endAngle) {
        float yawChange = AngleUtils.normalizeAngle(AngleUtils.normalizeAngle(endAngle.getYaw()) - AngleUtils.normalizeAngle(startAngle.getYaw()));
        return new Angle(yawChange, endAngle.getPitch() - startAngle.getPitch());
    }

    public static Angle getPlayerAngle() {
        return new Angle(AngleUtils.get360RotationYaw(), HypixelCry.mc.field_71439_g.field_70125_A);
    }
}

