/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ApecUtils {
    public static boolean inFMLFramework = false;
    private static final String[] colorCodes = new String[]{"\u00a70", "\u00a71", "\u00a72", "\u00a73", "\u00a74", "\u00a75", "\u00a76", "\u00a77", "\u00a78", "\u00a79", "\u00a7a", "\u00a7b", "\u00a7c", "\u00a7d", "\u00a7e", "\u00a7f"};
    private static final HashMap<String, Integer> multipleNotations = new HashMap<String, Integer>(){
        {
            this.put("k", 1000);
            this.put("m", 1000000);
        }
    };
    public static HashMap<String, String> unObfedFieldNames = new HashMap<String, String>(){
        {
            if (!inFMLFramework) {
                this.put("footer", "field_175255_h");
                this.put("header", "field_175256_i");
                this.put("upperChestInventory", "field_147016_v");
                this.put("lowerChestInventory", "field_147015_w");
                this.put("persistantChatGUI", "field_73840_e");
                this.put("sentMessages", "field_146248_g");
                this.put("streamIndicator", "field_152127_m");
                this.put("updateCounter", "field_73837_f");
                this.put("overlayPlayerList", "field_175196_v");
                this.put("guiIngame", "field_175251_g");
                this.put("chatMessages", "field_146253_i");
                this.put("theSlot", "field_147006_u");
                this.put("stackTagCompound", "field_77990_d");
            }
        }
    };
    public static HashMap<String, String> getUnObfedMethodNames = new HashMap<String, String>(){
        {
            if (!inFMLFramework) {
                this.put("handleMouseClick", "func_146984_a");
                this.put("drawItemStack", "func_146982_a");
                this.put("drawGradientRect", "func_73733_a");
            }
        }
    };

    public static String removeAllCodes(String s) {
        while (s.contains("\u00a7")) {
            s = s.replace("\u00a7" + s.charAt(s.indexOf("\u00a7") + 1), "");
        }
        return s;
    }

    public static String removeColorCodes(String s) {
        for (String code : colorCodes) {
            s = s.replace(code, "\u00a7r");
            s = s.replace(code.toUpperCase(), "\u00a7r");
        }
        return s;
    }

    public static void showMessage(String string) {
    }

    public static String removeNonNumericalChars(String s) {
        StringBuilder _s = new StringBuilder();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (!Character.isDigit(c) && c != '.') continue;
            _s.append(c);
        }
        return _s.toString();
    }

    public static boolean containedByCharSequence(String s1, String s2) {
        char[] c = s2.toCharArray();
        char[] s = s1.toCharArray();
        int cIdx = 0;
        for (int i2 = 0; i2 < s.length && cIdx < c.length; ++i2) {
            if (s[i2] != c[cIdx]) continue;
            ++cIdx;
        }
        return cIdx == c.length;
    }

    public static String removeFirstSpaces(String s) {
        if (s.equals("")) {
            return s;
        }
        int nonSpaceIdx = 0;
        int i2 = 0;
        while (s.charAt(i2) == ' ') {
            nonSpaceIdx = i2 + 1;
            ++i2;
        }
        return s.substring(nonSpaceIdx);
    }

    public static List<String> orderByWidth(List<String> l) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        for (String s : l) {
            arr.add(Minecraft.func_71410_x().field_71466_p.func_78256_a(s));
        }
        ApecUtils.bubbleSort(arr, l);
        return l;
    }

    public static <T> void bubbleSort(List<Integer> arr, List<T> s) {
        int n = arr.size();
        for (int i2 = 0; i2 < n - 1; ++i2) {
            for (int j = 0; j < n - i2 - 1; ++j) {
                if (arr.get(j) >= arr.get(j + 1)) continue;
                int temp = arr.get(j);
                arr.set(j, arr.get(j + 1));
                arr.set(j + 1, temp);
                T _temp = s.get(j);
                s.set(j, s.get(j + 1));
                s.set(j + 1, _temp);
            }
        }
    }

    public static String segmentString(String string, String symbol, char leftChar, char rightChar, int allowedInstancesL, int allowedInstancesR, SegmentationOptions ... options) {
        boolean totallyExclusive = false;
        boolean totallyInclusive = false;
        boolean allInstancesR = false;
        boolean allInstancesL = false;
        for (SegmentationOptions option : options) {
            if (option == SegmentationOptions.TOTALLY_EXCLUSIVE) {
                totallyExclusive = true;
            }
            if (option == SegmentationOptions.TOTALLY_INCLUSIVE) {
                totallyInclusive = true;
            }
            if (option == SegmentationOptions.ALL_INSTANCES_RIGHT) {
                allInstancesR = true;
            }
            if (option != SegmentationOptions.ALL_INSTANCES_LEFT) continue;
            allInstancesL = true;
        }
        return ApecUtils.segmentString(string, symbol, leftChar, rightChar, allowedInstancesL, allowedInstancesR, totallyExclusive, totallyInclusive, allInstancesR, allInstancesL);
    }

    public static String segmentString(String string, String symbol, char leftChar, char rightChar, int allowedInstancesL, int allowedInstancesR, boolean totallyExclusive, boolean totallyInclusive, boolean allInstancesR, boolean allInstancesL) {
        int leftIdx = 0;
        int rightIdx = 0;
        if (string.contains(symbol)) {
            int symbolIdx = string.indexOf(symbol);
            int i2 = 0;
            while (symbolIdx - i2 > -1) {
                leftIdx = symbolIdx - i2;
                if (string.charAt(symbolIdx - i2) == leftChar) {
                    --allowedInstancesL;
                }
                if (allowedInstancesL == 0) break;
                ++i2;
            }
            symbolIdx += symbol.length() - 1;
            i2 = 0;
            while (symbolIdx + i2 < string.length()) {
                rightIdx = symbolIdx + i2;
                if (string.charAt(symbolIdx + i2) == rightChar) {
                    --allowedInstancesR;
                }
                if (allowedInstancesR == 0) break;
                ++i2;
            }
            if (allowedInstancesL != 0 && allInstancesL) {
                return null;
            }
            if (allowedInstancesR != 0 && allInstancesR) {
                return null;
            }
            return string.substring(leftIdx + (totallyExclusive ? 1 : 0), rightIdx + (totallyInclusive ? 1 : 0));
        }
        return null;
    }

    public static int RomanSymbolToValue(char s) {
        switch (s) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
        }
        return 0;
    }

    public static int RomanStringToValue(String str) {
        int res = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int s1 = ApecUtils.RomanSymbolToValue(str.charAt(i2));
            if (i2 + 1 < str.length()) {
                int s2 = ApecUtils.RomanSymbolToValue(str.charAt(i2 + 1));
                if (s1 >= s2) {
                    res += s1;
                    continue;
                }
                res = res + s2 - s1;
                ++i2;
                continue;
            }
            res += s1;
        }
        return res;
    }

    public static float hypixelShortValueFormattingToFloat(String s) {
        s = s.replace(",", "");
        for (String notation : multipleNotations.keySet()) {
            if (!s.contains(notation)) continue;
            s = s.replace(notation, "");
            return Float.parseFloat(s) * (float)multipleNotations.get(notation).intValue();
        }
        return Float.parseFloat(s);
    }

    public static enum SegmentationOptions {
        TOTALLY_EXCLUSIVE,
        TOTALLY_INCLUSIVE,
        ALL_INSTANCES_RIGHT,
        ALL_INSTANCES_LEFT;

    }
}

