/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.utils.AngleUtils;
import com.nekiplay.hypixelcry.utils.RaycastUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;

public class BlockUtils {
    public static final Map<EnumFacing, float[]> BLOCK_SIDES = new HashMap<EnumFacing, float[]>(){
        {
            this.put(EnumFacing.DOWN, new float[]{0.5f, 0.01f, 0.5f});
            this.put(EnumFacing.UP, new float[]{0.5f, 0.99f, 0.5f});
            this.put(EnumFacing.WEST, new float[]{0.01f, 0.5f, 0.5f});
            this.put(EnumFacing.EAST, new float[]{0.99f, 0.5f, 0.5f});
            this.put(EnumFacing.NORTH, new float[]{0.5f, 0.5f, 0.01f});
            this.put(EnumFacing.SOUTH, new float[]{0.5f, 0.5f, 0.99f});
            this.put(null, new float[]{0.5f, 0.5f, 0.5f});
        }
    };

    public static Vec3 getSidePos(BlockPos block, EnumFacing face) {
        float[] offset = BLOCK_SIDES.get(face);
        return new Vec3((double)((float)block.func_177958_n() + offset[0]), (double)((float)block.func_177956_o() + offset[1]), (double)((float)block.func_177952_p() + offset[2]));
    }

    public static boolean canSeeSide(BlockPos block, EnumFacing side, List<Block> blocks) {
        return RaycastUtils.canSeePoint(BlockUtils.getSidePos(block, side), blocks);
    }

    public static List<Vec3> bestPointsOnBestSide(BlockPos block, List<Block> blocks) {
        return BlockUtils.pointsOnBlockSide(block, BlockUtils.getClosestVisibleSide(block, blocks)).stream().filter(point -> RaycastUtils.canSeePoint(point, blocks)).sorted(Comparator.comparingDouble(i2 -> AngleUtils.getNeededChange(AngleUtils.getPlayerAngle(), AngleUtils.getRotation(i2)).getValue())).collect(Collectors.toList());
    }

    public static EnumFacing getClosestVisibleSide(BlockPos block, List<Block> blocks) {
        if (!HypixelCry.mc.field_71441_e.func_175665_u(block)) {
            return null;
        }
        Vec3 eyePos = HypixelCry.mc.field_71439_g.func_174824_e(1.0f);
        double dist = Double.MAX_VALUE;
        EnumFacing face = null;
        for (EnumFacing side : BLOCK_SIDES.keySet()) {
            if (side != null && !HypixelCry.mc.field_71441_e.func_180495_p(block).func_177230_c().func_176225_a((IBlockAccess)HypixelCry.mc.field_71441_e, block.func_177972_a(side), side)) continue;
            double distanceToThisSide = eyePos.func_72438_d(BlockUtils.getSidePos(block, side));
            if (!BlockUtils.canSeeSide(block, side, blocks) || !(distanceToThisSide < dist) || side == null && face != null) continue;
            dist = distanceToThisSide;
            face = side;
        }
        return face;
    }

    private static List<Vec3> pointsOnBlockSide(BlockPos block, EnumFacing side) {
        HashSet<Vec3> points = new HashSet<Vec3>();
        if (side != null) {
            float[] it = BLOCK_SIDES.get(side);
            for (int i2 = 0; i2 < 20; ++i2) {
                float x = it[0];
                float y = it[1];
                float z = it[2];
                if (x == 0.5f) {
                    x = BlockUtils.randomVal();
                }
                if (y == 0.5f) {
                    y = BlockUtils.randomVal();
                }
                if (z == 0.5f) {
                    z = BlockUtils.randomVal();
                }
                Vec3 point = new Vec3((Vec3i)block).func_72441_c((double)x, (double)y, (double)z);
                points.add(point);
            }
        } else {
            for (float[] bside : BLOCK_SIDES.values()) {
                for (int i3 = 0; i3 < 20; ++i3) {
                    float x = bside[0];
                    float y = bside[1];
                    float z = bside[2];
                    if (x == 0.5f) {
                        x = BlockUtils.randomVal();
                    }
                    if (y == 0.5f) {
                        y = BlockUtils.randomVal();
                    }
                    if (z == 0.5f) {
                        z = BlockUtils.randomVal();
                    }
                    Vec3 point = new Vec3((Vec3i)block).func_72441_c((double)x, (double)y, (double)z);
                    points.add(point);
                }
            }
        }
        return new ArrayList<Vec3>(points);
    }

    private static float randomVal() {
        return (float)(new Random().nextInt(6) + 2) / 10.0f;
    }

    public static long longHash(int x, int y, int z) {
        long hash = 3241L;
        hash = 3457689L * hash + (long)x;
        hash = 8734625L * hash + (long)y;
        hash = 2873465L * hash + (long)z;
        return hash;
    }
}

