/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.google.common.collect.ImmutableMap;
import com.nekiplay.hypixelcry.utils.AngleUtils;
import com.nekiplay.hypixelcry.utils.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class KeyBindUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static final KeyBinding[] allKeys = new KeyBinding[]{KeyBindUtils.mc.field_71474_y.field_74312_F, KeyBindUtils.mc.field_71474_y.field_74313_G, KeyBindUtils.mc.field_71474_y.field_74368_y, KeyBindUtils.mc.field_71474_y.field_74351_w, KeyBindUtils.mc.field_71474_y.field_74370_x, KeyBindUtils.mc.field_71474_y.field_74366_z, KeyBindUtils.mc.field_71474_y.field_74314_A, KeyBindUtils.mc.field_71474_y.field_74311_E, KeyBindUtils.mc.field_71474_y.field_151444_V};
    public static final KeyBinding[] allKeys2 = new KeyBinding[]{KeyBindUtils.mc.field_71474_y.field_74368_y, KeyBindUtils.mc.field_71474_y.field_74351_w, KeyBindUtils.mc.field_71474_y.field_74370_x, KeyBindUtils.mc.field_71474_y.field_74366_z, KeyBindUtils.mc.field_71474_y.field_74314_A};
    private static final Map<Integer, KeyBinding> keyBindMap = ImmutableMap.of((Object)0, (Object)KeyBindUtils.mc.field_71474_y.field_74351_w, (Object)90, (Object)KeyBindUtils.mc.field_71474_y.field_74370_x, (Object)180, (Object)KeyBindUtils.mc.field_71474_y.field_74368_y, (Object)-90, (Object)KeyBindUtils.mc.field_71474_y.field_74366_z);

    public static void rightClick() {
        if (!ReflectionUtils.invoke(mc, "func_147121_ag")) {
            ReflectionUtils.invoke(mc, "rightClickMouse");
        }
    }

    public static void leftClick() {
        if (!ReflectionUtils.invoke(mc, "func_147116_af")) {
            ReflectionUtils.invoke(mc, "clickMouse");
        }
    }

    public static void middleClick() {
        if (!ReflectionUtils.invoke(mc, "func_147112_ai")) {
            ReflectionUtils.invoke(mc, "middleClickMouse");
        }
    }

    public static void onTick(KeyBinding key) {
        if (KeyBindUtils.mc.field_71462_r == null) {
            KeyBinding.func_74507_a((int)key.func_151463_i());
        }
    }

    public static void setKeyBindState(KeyBinding key, boolean pressed) {
        if (pressed && KeyBindUtils.mc.field_71462_r != null && key != null) {
            KeyBindUtils.realSetKeyBindState(key, false);
            return;
        }
        KeyBindUtils.realSetKeyBindState(key, pressed);
    }

    private static void realSetKeyBindState(KeyBinding key, boolean pressed) {
        if (key == null) {
            return;
        }
        if (pressed) {
            if (!key.func_151470_d()) {
                KeyBinding.func_74507_a((int)key.func_151463_i());
                KeyBinding.func_74510_a((int)key.func_151463_i(), (boolean)true);
            }
        } else if (key.func_151470_d()) {
            KeyBinding.func_74510_a((int)key.func_151463_i(), (boolean)false);
        }
    }

    public static void stopMovement() {
        KeyBindUtils.stopMovement(false);
    }

    public static void stopMovement(boolean ignoreAttack) {
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74351_w, false);
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74368_y, false);
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74366_z, false);
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74370_x, false);
        if (!ignoreAttack) {
            KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74312_F, false);
            KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74313_G, false);
        }
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74311_E, false);
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74314_A, false);
        KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_151444_V, false);
    }

    public static void holdThese(boolean withAttack, KeyBinding ... keyBinding) {
        KeyBindUtils.releaseAllExcept(keyBinding);
        for (KeyBinding key : keyBinding) {
            if (key == null) continue;
            KeyBindUtils.realSetKeyBindState(key, true);
        }
        if (withAttack) {
            KeyBindUtils.realSetKeyBindState(KeyBindUtils.mc.field_71474_y.field_74312_F, true);
        }
    }

    public static void holdThese(KeyBinding ... keyBinding) {
        KeyBindUtils.releaseAllExcept(keyBinding);
        for (KeyBinding key : keyBinding) {
            if (key == null) continue;
            KeyBindUtils.realSetKeyBindState(key, true);
        }
    }

    public static void releaseAllExcept(KeyBinding ... keyBinding) {
        for (KeyBinding key : allKeys) {
            if (key == null || KeyBindUtils.contains(keyBinding, key) || !key.func_151470_d()) continue;
            KeyBindUtils.realSetKeyBindState(key, false);
        }
    }

    public static boolean contains(KeyBinding[] keyBinding, KeyBinding key) {
        for (KeyBinding keyBind : keyBinding) {
            if (keyBind == null || keyBind.func_151463_i() != key.func_151463_i()) continue;
            return true;
        }
        return false;
    }

    public static boolean areAllKeybindsReleased() {
        for (KeyBinding key : allKeys2) {
            if (key == null || !key.func_151470_d()) continue;
            return false;
        }
        return true;
    }

    public static KeyBinding[] getHoldingKeybinds() {
        KeyBinding[] keybinds = new KeyBinding[allKeys.length];
        int i2 = 0;
        for (KeyBinding key : allKeys) {
            if (key == null || !key.func_151470_d()) continue;
            keybinds[i2] = key;
            ++i2;
        }
        return keybinds;
    }

    public static List<KeyBinding> getNeededKeyPresses(Vec3 orig, Vec3 dest) {
        ArrayList<KeyBinding> keys = new ArrayList<KeyBinding>();
        double[] delta = new double[]{orig.field_72450_a - dest.field_72450_a, orig.field_72449_c - dest.field_72449_c};
        float requiredAngle = (float)(MathHelper.func_181159_b((double)delta[0], (double)(-delta[1])) * 57.29577951308232);
        float angleDifference = AngleUtils.normalizeYaw(requiredAngle - KeyBindUtils.mc.field_71439_g.field_70177_z) * -1.0f;
        keyBindMap.forEach((yaw, key) -> {
            if ((double)Math.abs((float)yaw.intValue() - angleDifference) < 67.5 || Math.abs((double)yaw.intValue() - ((double)angleDifference + 360.0)) < 67.5) {
                keys.add((KeyBinding)key);
            }
        });
        return keys;
    }

    public static List<KeyBinding> getNeededKeyPresses(float neededYaw) {
        ArrayList<KeyBinding> keys = new ArrayList<KeyBinding>();
        float finalNeededYaw = neededYaw = AngleUtils.normalizeYaw(neededYaw - KeyBindUtils.mc.field_71439_g.field_70177_z) * -1.0f;
        keyBindMap.forEach((yaw, key) -> {
            if ((double)Math.abs((float)yaw.intValue() - finalNeededYaw) < 67.5 || Math.abs((double)yaw.intValue() - ((double)finalNeededYaw + 360.0)) < 67.5) {
                keys.add((KeyBinding)key);
            }
        });
        return keys;
    }

    public static List<KeyBinding> getOppositeKeys(List<KeyBinding> kbs) {
        ArrayList<KeyBinding> keys = new ArrayList<KeyBinding>();
        kbs.forEach(key -> {
            switch (key.func_151463_i()) {
                case 17: {
                    keys.add(KeyBindUtils.mc.field_71474_y.field_74368_y);
                    break;
                }
                case 30: {
                    keys.add(KeyBindUtils.mc.field_71474_y.field_74366_z);
                    break;
                }
                case 31: {
                    keys.add(KeyBindUtils.mc.field_71474_y.field_74370_x);
                    break;
                }
                case 32: {
                    keys.add(KeyBindUtils.mc.field_71474_y.field_74351_w);
                }
            }
        });
        return keys;
    }

    public static List<KeyBinding> getKeyPressesToDecelerate(Vec3 orig, Vec3 dest) {
        return KeyBindUtils.getOppositeKeys(KeyBindUtils.getNeededKeyPresses(orig, dest));
    }
}

