/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.utils.PlayerUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class RaycastUtils {
    private boolean isPointVisible(Vec3 point, Vec3 eyePosition, float distance, List<Block> ghostBlocks) {
        MovingObjectPosition result = RaycastUtils.rayTraceToBlocks(eyePosition, PlayerUtils.getLookEndPos(point, distance), ghostBlocks);
        return result != null && result.field_72313_a != MovingObjectPosition.MovingObjectType.MISS;
    }

    public static MovingObjectPosition rayTraceToBlocks(Vec3 startVec, Vec3 endVec, List<Block> blocks) {
        return RaycastUtils.fastRayTrace(startVec, endVec, blocks);
    }

    private static MovingObjectPosition fastRayTrace(Vec3 startVec, Vec3 endVec, List<Block> targetBlocks) {
        MovingObjectPosition startHit;
        int startX = (int)Math.floor(startVec.field_72450_a);
        int startY = (int)Math.floor(startVec.field_72448_b);
        int startZ = (int)Math.floor(startVec.field_72449_c);
        int endX = (int)Math.floor(endVec.field_72450_a);
        int endY = (int)Math.floor(endVec.field_72448_b);
        int endZ = (int)Math.floor(endVec.field_72449_c);
        BlockPos startPos = new BlockPos(startX, startY, startZ);
        IBlockState startState = HypixelCry.mc.field_71441_e.func_180495_p(startPos);
        Block startBlock = startState.func_177230_c();
        if (startBlock.func_176209_a(startState, false) && (startHit = startBlock.func_180636_a((World)HypixelCry.mc.field_71441_e, startPos, startVec, endVec)) != null) {
            return startHit;
        }
        MovingObjectPosition closestHit = null;
        int maxSteps = 200;
        while (maxSteps-- >= 0) {
            MovingObjectPosition hit;
            boolean shouldCheckBlock;
            EnumFacing exitFace;
            double zDist;
            double yExit;
            double xExit;
            boolean zDifferent;
            if (startX == endX && startY == endY && startZ == endZ) {
                return closestHit;
            }
            boolean xDifferent = startX != endX;
            boolean yDifferent = startY != endY;
            boolean bl = zDifferent = startZ != endZ;
            double d = xDifferent ? (endX > startX ? (double)startX + 1.0 : (double)startX) : (xExit = 999.0);
            double d2 = yDifferent ? (endY > startY ? (double)startY + 1.0 : (double)startY) : (yExit = 999.0);
            double zExit = zDifferent ? (endZ > startZ ? (double)startZ + 1.0 : (double)startZ) : 999.0;
            double dx = endVec.field_72450_a - startVec.field_72450_a;
            double dy = endVec.field_72448_b - startVec.field_72448_b;
            double dz = endVec.field_72449_c - startVec.field_72449_c;
            double xDist = xDifferent ? (xExit - startVec.field_72450_a) / dx : 999.0;
            double yDist = yDifferent ? (yExit - startVec.field_72448_b) / dy : 999.0;
            double d3 = zDist = zDifferent ? (zExit - startVec.field_72449_c) / dz : 999.0;
            if (xDist == -0.0) {
                xDist = -1.0E-4;
            }
            if (yDist == -0.0) {
                yDist = -1.0E-4;
            }
            if (zDist == -0.0) {
                zDist = -1.0E-4;
            }
            if (xDist < yDist && xDist < zDist) {
                exitFace = endX > startX ? EnumFacing.WEST : EnumFacing.EAST;
                startVec = new Vec3(xExit, startVec.field_72448_b + dy * xDist, startVec.field_72449_c + dz * xDist);
            } else if (yDist < zDist) {
                exitFace = endY > startY ? EnumFacing.DOWN : EnumFacing.UP;
                startVec = new Vec3(startVec.field_72450_a + dx * yDist, yExit, startVec.field_72449_c + dz * yDist);
            } else {
                exitFace = endZ > startZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                startVec = new Vec3(startVec.field_72450_a + dx * zDist, startVec.field_72448_b + dy * zDist, zExit);
            }
            startX = MathHelper.func_76128_c((double)startVec.field_72450_a) - (exitFace == EnumFacing.EAST ? 1 : 0);
            startY = MathHelper.func_76128_c((double)startVec.field_72448_b) - (exitFace == EnumFacing.UP ? 1 : 0);
            startZ = MathHelper.func_76128_c((double)startVec.field_72449_c) - (exitFace == EnumFacing.SOUTH ? 1 : 0);
            BlockPos newPos = new BlockPos(startX, startY, startZ);
            IBlockState newState = HypixelCry.mc.field_71441_e.func_180495_p(newPos);
            Block newBlock = newState.func_177230_c();
            boolean bl2 = shouldCheckBlock = targetBlocks.isEmpty() ? newBlock.func_176209_a(newState, false) : targetBlocks.contains(newBlock);
            if (shouldCheckBlock && (hit = newBlock.func_180636_a((World)HypixelCry.mc.field_71441_e, newPos, startVec, endVec)) != null) {
                return hit;
            }
            closestHit = new MovingObjectPosition(MovingObjectPosition.MovingObjectType.MISS, startVec, exitFace, newPos);
        }
        return closestHit;
    }

    public static boolean canSeePoint(Vec3 point, List<Block> blocks) {
        return RaycastUtils.canSeePoint(HypixelCry.mc.field_71439_g.func_174824_e(1.0f), point, blocks);
    }

    public static boolean canSeePoint(Vec3 from, Vec3 point, List<Block> blocks) {
        MovingObjectPosition result = RaycastUtils.fastRayTrace(from, point, blocks);
        if (result == null) {
            return true;
        }
        Vec3 r = result.field_72307_f;
        if (r == null) {
            return false;
        }
        return Math.abs(r.field_72450_a - point.field_72450_a) < (double)0.1f && Math.abs(r.field_72448_b - point.field_72448_b) < (double)0.1f && Math.abs(r.field_72449_c - point.field_72449_c) < (double)0.1f;
    }

    public static MovingObjectPosition raytraceTowards(Vec3 v1, Vec3 v2, double distance) {
        Vec3 normalized = v2.func_178788_d(v1).func_72432_b();
        return RaycastUtils.raytrace(v1, v1.func_178787_e(new Vec3(normalized.field_72450_a * distance, normalized.field_72448_b * distance, normalized.field_72449_c * distance)));
    }

    public static MovingObjectPosition raytrace(Vec3 v1, Vec3 v2) {
        Vec3 v3 = v2.func_178788_d(v1);
        List entities = HypixelCry.mc.field_71441_e.func_175674_a((Entity)HypixelCry.mc.field_71439_g, HypixelCry.mc.field_71439_g.func_174813_aQ().func_72321_a(v3.field_72450_a, v3.field_72448_b, v3.field_72449_c).func_72314_b(1.0, 1.0, 1.0), it -> it.func_70089_S() && it.func_70067_L());
        for (Entity entity : entities) {
            MovingObjectPosition intercept = entity.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5).func_72327_a(v1, v2);
            if (intercept == null) continue;
            return new MovingObjectPosition(entity, intercept.field_72307_f);
        }
        return HypixelCry.mc.field_71441_e.func_147447_a(v1, v2, false, true, false);
    }
}

