/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class RenderUtils {
    private static final Map<Integer, Boolean> glCapMap = new HashMap<Integer, Boolean>();
    private static final ResourceLocation beaconBeam = new ResourceLocation("textures/entity/beacon_beam.png");
    private static final int[] DISPLAY_LISTS_2D = new int[4];

    public static int getIntFromColor(int Alpha, int Red, int Green, int Blue) {
        Alpha = Alpha << 24 & 0xFF0000;
        Red = Red << 16 & 0xFF0000;
        Green = Green << 8 & 0xFF00;
        return 0xFF000000 | Alpha | Red | Green | (Blue &= 0xFF);
    }

    private static void renderBeaconBeam(double x, double y, double z, int rgb, float alphaMult, float partialTicks, Boolean disableDepth) {
        int height = 300;
        int bottomOffset = 0;
        int topOffset = bottomOffset + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        if (disableDepth.booleanValue()) {
            GlStateManager.func_179097_i();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(beaconBeam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        double time = (double)HypixelCry.mc.field_71441_e.func_82737_E() + (double)partialTicks;
        double d1 = MathHelper.func_181162_h((double)(-time * 0.2 - (double)MathHelper.func_76128_c((double)(-time * 0.1))));
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        double d2 = time * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d2 + 2.356194490192345) * 0.2;
        double d5 = 0.5 + Math.sin(d2 + 2.356194490192345) * 0.2;
        double d6 = 0.5 + Math.cos(d2 + 0.7853981633974483) * 0.2;
        double d7 = 0.5 + Math.sin(d2 + 0.7853981633974483) * 0.2;
        double d8 = 0.5 + Math.cos(d2 + 3.9269908169872414) * 0.2;
        double d9 = 0.5 + Math.sin(d2 + 3.9269908169872414) * 0.2;
        double d10 = 0.5 + Math.cos(d2 + 5.497787143782138) * 0.2;
        double d11 = 0.5 + Math.sin(d2 + 5.497787143782138) * 0.2;
        double d14 = -1.0 + d1;
        double d15 = (double)height * 2.5 + d14;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(1.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(0.0, d15).func_181666_a(r, g, b, 1.0f * alphaMult).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179129_p();
        double d12 = -1.0 + d1;
        double d13 = (double)height + d12;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMult).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        if (disableDepth.booleanValue()) {
            GlStateManager.func_179126_j();
        }
    }

    public static void renderWaypointText(String str, BlockPos location, float partialTicks, boolean background, Color color) {
        RenderUtils.renderWaypointText(str, new Vec3((double)location.func_177958_n() + 0.5, (double)location.func_177956_o() + 0.5, (double)location.func_177952_p() + 0.5), partialTicks, background, color);
    }

    public static void renderWaypointText(String str, Vec3 location, float partialTicks, boolean background, Color color) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        Entity viewer = HypixelCry.mc.func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double x = location.field_72450_a - viewerX;
        double y = location.field_72448_b - viewerY - (double)viewer.func_70047_e();
        double z = location.field_72449_c - viewerZ;
        double distSq = x * x + y * y + z * z;
        double dist = Math.sqrt(distSq);
        if (distSq > 144.0) {
            x *= 12.0 / dist;
            y *= 12.0 / dist;
            z *= 12.0 / dist;
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)0.0f, (float)viewer.func_70047_e(), (float)0.0f);
        RenderUtils.drawNametag(str, background, color);
        GlStateManager.func_179114_b((float)(-HypixelCry.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)HypixelCry.mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-HypixelCry.mc.func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)HypixelCry.mc.func_175598_ae().field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
    }

    public static void drawNametag(String text, boolean drawBackground, Color textColor) {
        FontRenderer fontRenderer = HypixelCry.mc.field_71466_p;
        float scale = 1.6f;
        float scaleFactor = 0.016666668f * scale;
        GlStateManager.func_179094_E();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-HypixelCry.mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)HypixelCry.mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scaleFactor), (float)(-scaleFactor), (float)scaleFactor);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int textYOffset = 0;
        int textWidth = fontRenderer.func_78256_a(text);
        int halfTextWidth = textWidth / 2;
        if (drawBackground) {
            RenderUtils.drawNametagBackground(halfTextWidth, textYOffset);
        }
        GlStateManager.func_179098_w();
        fontRenderer.func_78276_b(text, -halfTextWidth, textYOffset, 0x21000000);
        GlStateManager.func_179132_a((boolean)true);
        fontRenderer.func_78276_b(text, -halfTextWidth, textYOffset, textColor.getRGB());
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void drawNametagBackground(int halfTextWidth, int yOffset) {
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float left = -halfTextWidth - 1;
        float right = halfTextWidth + 1;
        float top = -1 + yOffset;
        float bottom = 8 + yOffset;
        worldRenderer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldRenderer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldRenderer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldRenderer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static int myColor(int r, int g, int b) {
        int argb = 0xFF000000 | r << 16 | g << 8 | b;
        return argb;
    }

    public static void drawBlockBox(BlockPos blockPos, Color color, int width, float partialTicks) {
        if (width == 0) {
            return;
        }
        RenderManager renderManager = HypixelCry.mc.func_175598_ae();
        double x = (double)blockPos.func_177958_n() - renderManager.field_78730_l;
        double y = (double)blockPos.func_177956_o() - renderManager.field_78731_m;
        double z = (double)blockPos.func_177952_p() - renderManager.field_78728_n;
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0);
        Block block = HypixelCry.mc.field_71441_e.func_180495_p(blockPos).func_177230_c();
        if (block != null) {
            EntityPlayerSP player = HypixelCry.mc.field_71439_g;
            double posX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double posY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double posZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            block.func_180654_a((IBlockAccess)HypixelCry.mc.field_71441_e, blockPos);
            axisAlignedBB = block.func_180646_a((World)HypixelCry.mc.field_71441_e, blockPos).func_72314_b((double)0.002f, (double)0.002f, (double)0.002f).func_72317_d(-posX, -posY, -posZ);
        }
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.enableGlCap(3042);
        RenderUtils.disableGlCap(3553, 2929);
        GL11.glDepthMask((boolean)false);
        RenderUtils.glColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() != 255 ? color.getAlpha() : 26);
        GL11.glLineWidth((float)width);
        RenderUtils.enableGlCap(2848);
        RenderUtils.glColor(color);
        RenderUtils.drawSelectionBoundingBox(axisAlignedBB);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        RenderUtils.resetCaps();
    }

    public static void drawPixelBox(Vec3 vec, Color color, double size, float partialTicks) {
        RenderManager renderManager = HypixelCry.mc.func_175598_ae();
        double x = vec.field_72450_a - renderManager.field_78730_l;
        double y = vec.field_72448_b - renderManager.field_78731_m;
        double z = vec.field_72449_c - renderManager.field_78728_n;
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(x, y, z, x + size, y + size, z + size);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.enableGlCap(3042);
        RenderUtils.disableGlCap(3553, 2929);
        GL11.glDepthMask((boolean)false);
        RenderUtils.glColor(color.getRed(), color.getGreen(), color.getBlue(), 35);
        GL11.glLineWidth((float)3.0f);
        RenderUtils.enableGlCap(2848);
        RenderUtils.glColor(color);
        RenderUtils.drawSelectionBoundingBox(axisAlignedBB);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        RenderUtils.resetCaps();
    }

    public static void drawSelectionBoundingBox(AxisAlignedBB boundingBox) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawEntityBox(Entity entity, Color color, int width, float partialTicks) {
        if (width == 0) {
            return;
        }
        RenderManager renderManager = HypixelCry.mc.func_175598_ae();
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.enableGlCap(3042);
        RenderUtils.disableGlCap(3553, 2929);
        GL11.glDepthMask((boolean)false);
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks - renderManager.field_78730_l;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks - renderManager.field_78731_m;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks - renderManager.field_78728_n;
        AxisAlignedBB entityBox = entity.func_174813_aQ();
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(entityBox.field_72340_a - entity.field_70165_t + x - 0.05, entityBox.field_72338_b - entity.field_70163_u + y, entityBox.field_72339_c - entity.field_70161_v + z - 0.05, entityBox.field_72336_d - entity.field_70165_t + x + 0.05, entityBox.field_72337_e - entity.field_70163_u + y + 0.15, entityBox.field_72334_f - entity.field_70161_v + z + 0.05);
        GL11.glLineWidth((float)width);
        RenderUtils.enableGlCap(2848);
        RenderUtils.glColor(color.getRed(), color.getGreen(), color.getBlue(), 95);
        RenderUtils.drawSelectionBoundingBox(axisAlignedBB);
        RenderUtils.glColor(color.getRed(), color.getGreen(), color.getBlue(), 26);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        RenderUtils.resetCaps();
    }

    public static void drawAxisAlignedBB(AxisAlignedBB axisAlignedBB, Color color) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        RenderUtils.glColor(color);
        RenderUtils.drawFilledBox(axisAlignedBB);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
    }

    public static void drawPlatform(double y, Color color, double size) {
        RenderManager renderManager = HypixelCry.mc.func_175598_ae();
        double renderY = y - renderManager.field_78731_m;
        RenderUtils.drawAxisAlignedBB(new AxisAlignedBB(size, renderY + 0.02, size, -size, renderY, -size), color);
    }

    public static void drawPlatform(Entity entity, Color color, float partialTicks) {
        RenderManager renderManager = HypixelCry.mc.func_175598_ae();
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks - renderManager.field_78730_l;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks - renderManager.field_78731_m;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks - renderManager.field_78728_n;
        AxisAlignedBB axisAlignedBB = entity.func_174813_aQ().func_72317_d(-entity.field_70165_t, -entity.field_70163_u, -entity.field_70161_v).func_72317_d(x, y, z);
        RenderUtils.drawAxisAlignedBB(new AxisAlignedBB(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e + 0.2, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e + 0.26, axisAlignedBB.field_72334_f), color);
    }

    public static void drawFilledBox(AxisAlignedBB axisAlignedBB) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void quickDrawRect(float x, float y, float x2, float y2) {
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
    }

    public static void drawRect(float x, float y, float x2, float y2, int color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        RenderUtils.glColor(color);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)x2, (float)y);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)y2);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void drawRect(int x, int y, int x2, int y2, int color) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        RenderUtils.glColor(color);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)x2, (int)y);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glVertex2i((int)x, (int)y2);
        GL11.glVertex2i((int)x2, (int)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void quickDrawRect(float x, float y, float x2, float y2, int color) {
        RenderUtils.glColor(color);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
    }

    public static void drawRect(float x, float y, float x2, float y2, Color color) {
        RenderUtils.drawRect(x, y, x2, y2, color.getRGB());
    }

    public static void drawBorderedRect(float x, float y, float x2, float y2, float width, int color1, int color2) {
        RenderUtils.drawRect(x, y, x2, y2, color2);
        RenderUtils.drawBorder(x, y, x2, y2, width, color1);
    }

    public static void drawBorder(float x, float y, float x2, float y2, float width, int color1) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        RenderUtils.glColor(color1);
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void quickDrawBorderedRect(float x, float y, float x2, float y2, float width, int color1, int color2) {
        RenderUtils.quickDrawRect(x, y, x2, y2, color2);
        RenderUtils.glColor(color1);
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)x2, (double)y);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x, (double)y2);
        GL11.glVertex2d((double)x2, (double)y2);
        GL11.glEnd();
    }

    public static void drawLoadingCircle(float x, float y) {
        for (int i2 = 0; i2 < 4; ++i2) {
            int rot = (int)(System.nanoTime() / 5000000L * (long)i2 % 360L);
            RenderUtils.drawCircle(x, y, i2 * 10, rot - 180, rot);
        }
    }

    public static void drawCircle(float x, float y, float radius, int start, int end) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderUtils.glColor(Color.WHITE);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)3);
        for (float i2 = (float)end; i2 >= (float)start; i2 -= 4.0f) {
            GL11.glVertex2f((float)((float)((double)x + Math.cos((double)i2 * Math.PI / 180.0) * (double)(radius * 1.001f))), (float)((float)((double)y + Math.sin((double)i2 * Math.PI / 180.0) * (double)(radius * 1.001f))));
        }
        GL11.glEnd();
        GL11.glDisable((int)2848);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawFilledCircle(int xx, int yy, float radius, Color color) {
        int sections = 50;
        double dAngle = Math.PI * 2 / (double)sections;
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glBegin((int)6);
        for (int i2 = 0; i2 < sections; ++i2) {
            float x = (float)((double)radius * Math.sin((double)i2 * dAngle));
            float y = (float)((double)radius * Math.cos((double)i2 * dAngle));
            GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            GL11.glVertex2f((float)((float)xx + x), (float)((float)yy + y));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glPopAttrib();
    }

    public static void drawImage(ResourceLocation image, int x, int y, int width, int height) {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        HypixelCry.mc.func_110434_K().func_110577_a(image);
        RenderUtils.drawModalRectWithCustomSizedTexture(x, y, 0.0f, 0.0f, width, height, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
    }

    public static void drawModalRectWithCustomSizedTexture(float x, float y, float u, float v, float width, float height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)(u * f), (double)((v + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)((u + width) * f), (double)((v + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)((u + width) * f), (double)(v * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void glColor(int red, int green, int blue, int alpha) {
        GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
    }

    public static void glColor(Color color) {
        RenderUtils.glColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static void glColor(int hex) {
        RenderUtils.glColor(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF, hex >> 24 & 0xFF);
    }

    public static void draw2D(EntityLivingBase entity, double posX, double posY, double posZ, int color, int backgroundColor) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)posZ);
        GL11.glRotated((double)(-HypixelCry.mc.func_175598_ae().field_78731_m), (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)-0.1, (double)-0.1, (double)0.1);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)true);
        RenderUtils.glColor(color);
        GL11.glCallList((int)DISPLAY_LISTS_2D[0]);
        RenderUtils.glColor(backgroundColor);
        GL11.glCallList((int)DISPLAY_LISTS_2D[1]);
        GL11.glTranslated((double)0.0, (double)(21.0 + -(entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b) * 12.0), (double)0.0);
        RenderUtils.glColor(color);
        GL11.glCallList((int)DISPLAY_LISTS_2D[2]);
        RenderUtils.glColor(backgroundColor);
        GL11.glCallList((int)DISPLAY_LISTS_2D[3]);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void draw2D(BlockPos blockPos, int color, int backgroundColor) {
        RenderManager renderManager = HypixelCry.mc.func_175598_ae();
        double posX = (double)blockPos.func_177958_n() + 0.5 - renderManager.field_78730_l;
        double posY = (double)blockPos.func_177956_o() - renderManager.field_78731_m;
        double posZ = (double)blockPos.func_177952_p() + 0.5 - renderManager.field_78728_n;
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)posZ);
        GL11.glRotated((double)(-HypixelCry.mc.func_175598_ae().field_78735_i), (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)-0.1, (double)-0.1, (double)0.1);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)true);
        RenderUtils.glColor(color);
        GL11.glCallList((int)DISPLAY_LISTS_2D[0]);
        RenderUtils.glColor(backgroundColor);
        GL11.glCallList((int)DISPLAY_LISTS_2D[1]);
        GL11.glTranslated((double)0.0, (double)9.0, (double)0.0);
        RenderUtils.glColor(color);
        GL11.glCallList((int)DISPLAY_LISTS_2D[2]);
        RenderUtils.glColor(backgroundColor);
        GL11.glCallList((int)DISPLAY_LISTS_2D[3]);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawLine(double x, double y, double x1, double y1, float width) {
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)x1, (double)y1);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawLine(BlockPos pos1, BlockPos pos2, float width, Color color) {
        EntityPlayerSP player = HypixelCry.mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (HypixelCry.mc.func_175598_ae() == null) {
            return;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)width);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBegin((int)1);
        double x1 = (double)pos1.func_177958_n() + 0.5 - HypixelCry.mc.func_175598_ae().field_78730_l;
        double y1 = (double)pos1.func_177956_o() - HypixelCry.mc.func_175598_ae().field_78731_m;
        double z1 = (double)pos1.func_177952_p() + 0.5 - HypixelCry.mc.func_175598_ae().field_78728_n;
        double x2 = (double)pos2.func_177958_n() + 0.5 - HypixelCry.mc.func_175598_ae().field_78730_l;
        double y2 = (double)pos2.func_177956_o() - HypixelCry.mc.func_175598_ae().field_78731_m;
        double z2 = (double)pos2.func_177952_p() + 0.5 - HypixelCry.mc.func_175598_ae().field_78728_n;
        Vec3 eyeVector = new Vec3(0.0, 0.0, 1.0).func_178789_a((float)((double)(-player.field_70125_A) * (Math.PI / 180))).func_178785_b((float)((double)(-player.field_70177_z) * (Math.PI / 180)));
        RenderUtils.glColor(color);
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2848);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void makeScissorBox(float x, float y, float x2, float y2) {
        ScaledResolution scaledResolution = new ScaledResolution(HypixelCry.mc);
        int factor = scaledResolution.func_78325_e();
        GL11.glScissor((int)((int)(x * (float)factor)), (int)((int)(((float)scaledResolution.func_78328_b() - y2) * (float)factor)), (int)((int)((x2 - x) * (float)factor)), (int)((int)((y2 - y) * (float)factor)));
    }

    public static void drawTracer(BlockPos pos, Color color, float thickness, float partialTicks) {
        EntityPlayerSP player = HypixelCry.mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (HypixelCry.mc.func_175598_ae() == null) {
            return;
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)thickness);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBegin((int)1);
        double x = (double)pos.func_177958_n() + 0.5 - HypixelCry.mc.func_175598_ae().field_78730_l;
        double y = (double)pos.func_177956_o() + 0.5 - HypixelCry.mc.func_175598_ae().field_78731_m;
        double z = (double)pos.func_177952_p() + 0.5 - HypixelCry.mc.func_175598_ae().field_78728_n;
        Vec3 eyeVector = new Vec3(0.0, 0.0, 1.0).func_178789_a((float)((double)(-player.field_70125_A) * (Math.PI / 180))).func_178785_b((float)((double)(-player.field_70177_z) * (Math.PI / 180)));
        RenderUtils.glColor(color);
        GL11.glVertex3d((double)eyeVector.field_72450_a, (double)((double)player.eyeHeight + eyeVector.field_72448_b), (double)eyeVector.field_72449_c);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2848);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTracer(Entity entity, Color color, float partialTicks) {
        EntityPlayerSP player = HypixelCry.mc.field_71439_g;
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks - HypixelCry.mc.func_175598_ae().field_78730_l;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks - HypixelCry.mc.func_175598_ae().field_78731_m;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks - HypixelCry.mc.func_175598_ae().field_78728_n;
        Vec3 eyeVector = new Vec3(0.0, 0.0, 1.0).func_178789_a(-player.field_70125_A).func_178785_b(-player.field_70177_z);
        RenderUtils.glColor(color);
        GL11.glVertex3d((double)eyeVector.field_72450_a, (double)((double)player.eyeHeight + eyeVector.field_72448_b), (double)eyeVector.field_72449_c);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void resetCaps() {
        glCapMap.forEach(RenderUtils::setGlState);
    }

    public static void enableGlCap(int cap) {
        RenderUtils.setGlCap(cap, true);
    }

    public static void enableGlCap(int ... caps) {
        for (int cap : caps) {
            RenderUtils.setGlCap(cap, true);
        }
    }

    public static void disableGlCap(int cap) {
        RenderUtils.setGlCap(cap, true);
    }

    public static void disableGlCap(int ... caps) {
        for (int cap : caps) {
            RenderUtils.setGlCap(cap, false);
        }
    }

    public static void setGlCap(int cap, boolean state) {
        glCapMap.put(cap, GL11.glGetBoolean((int)cap));
        RenderUtils.setGlState(cap, state);
    }

    public static void setGlState(int cap, boolean state) {
        if (state) {
            GL11.glEnable((int)cap);
        } else {
            GL11.glDisable((int)cap);
        }
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)(u * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)((u + (float)uWidth) * f), (double)((v + (float)vHeight) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)((u + (float)uWidth) * f), (double)(v * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void enableChams() {
        GL11.glEnable((int)32823);
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)1.0f, (float)-1000000.0f);
    }

    public static void disableChams() {
        GL11.glDisable((int)32823);
        GlStateManager.func_179136_a((float)1.0f, (float)1000000.0f);
        GlStateManager.func_179113_r();
    }

    static {
        for (int i2 = 0; i2 < DISPLAY_LISTS_2D.length; ++i2) {
            RenderUtils.DISPLAY_LISTS_2D[i2] = GL11.glGenLists((int)1);
        }
        GL11.glNewList((int)DISPLAY_LISTS_2D[0], (int)4864);
        RenderUtils.quickDrawRect(-7.0f, 2.0f, -4.0f, 3.0f);
        RenderUtils.quickDrawRect(4.0f, 2.0f, 7.0f, 3.0f);
        RenderUtils.quickDrawRect(-7.0f, 0.5f, -6.0f, 3.0f);
        RenderUtils.quickDrawRect(6.0f, 0.5f, 7.0f, 3.0f);
        GL11.glEndList();
        GL11.glNewList((int)DISPLAY_LISTS_2D[1], (int)4864);
        RenderUtils.quickDrawRect(-7.0f, 3.0f, -4.0f, 3.3f);
        RenderUtils.quickDrawRect(4.0f, 3.0f, 7.0f, 3.3f);
        RenderUtils.quickDrawRect(-7.3f, 0.5f, -7.0f, 3.3f);
        RenderUtils.quickDrawRect(7.0f, 0.5f, 7.3f, 3.3f);
        GL11.glEndList();
        GL11.glNewList((int)DISPLAY_LISTS_2D[2], (int)4864);
        RenderUtils.quickDrawRect(4.0f, -20.0f, 7.0f, -19.0f);
        RenderUtils.quickDrawRect(-7.0f, -20.0f, -4.0f, -19.0f);
        RenderUtils.quickDrawRect(6.0f, -20.0f, 7.0f, -17.5f);
        RenderUtils.quickDrawRect(-7.0f, -20.0f, -6.0f, -17.5f);
        GL11.glEndList();
        GL11.glNewList((int)DISPLAY_LISTS_2D[3], (int)4864);
        RenderUtils.quickDrawRect(7.0f, -20.0f, 7.3f, -17.5f);
        RenderUtils.quickDrawRect(-7.3f, -20.0f, -7.0f, -17.5f);
        RenderUtils.quickDrawRect(4.0f, -20.3f, 7.3f, -20.0f);
        RenderUtils.quickDrawRect(-7.3f, -20.3f, -4.0f, -20.0f);
        GL11.glEndList();
    }
}

