/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.gui.component;

import io.github.notenoughupdates.moulconfig.GuiTextures;
import io.github.notenoughupdates.moulconfig.common.MyResourceLocation;
import io.github.notenoughupdates.moulconfig.gui.GuiComponent;
import io.github.notenoughupdates.moulconfig.gui.GuiImmediateContext;
import io.github.notenoughupdates.moulconfig.gui.MouseEvent;
import io.github.notenoughupdates.moulconfig.internal.LerpUtils;
import io.github.notenoughupdates.moulconfig.internal.LerpingInteger;
import io.github.notenoughupdates.moulconfig.observer.GetSetter;

public class SwitchComponent
extends GuiComponent {
    final GetSetter<Boolean> value;
    final LerpingInteger animation;
    private boolean lastValue;

    public SwitchComponent(GetSetter<Boolean> value, int timeToReachTarget) {
        this.value = value;
        this.lastValue = value.get();
        this.animation = new LerpingInteger(value.get() != false ? 100 : 0, timeToReachTarget);
    }

    @Override
    public int getWidth() {
        return 48;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().drawTexturedRect(GuiTextures.TOGGLE_BAR, 0.0f, 0.0f, context.getWidth(), context.getHeight());
        boolean val = this.value.get();
        if (this.lastValue != val) {
            this.animation.setTarget(val ? 100 : 0);
            this.animation.resetTimer();
            this.lastValue = val;
        } else {
            this.animation.tick();
        }
        float animationPercentage = LerpUtils.sigmoidZeroOne((float)this.animation.getValue() / 100.0f);
        MyResourceLocation buttonLocation = animationPercentage < 0.2f ? GuiTextures.TOGGLE_OFF : (animationPercentage < 0.4f ? GuiTextures.TOGGLE_ON : (animationPercentage < 0.6f ? GuiTextures.TOGGLE_TWO : (animationPercentage < 0.8f ? GuiTextures.TOGGLE_THREE : GuiTextures.TOGGLE_ON)));
        context.getRenderContext().drawTexturedRect(buttonLocation, animationPercentage * (float)(context.getWidth() - 12), 0.0f, 12.0f, context.getHeight());
    }

    @Override
    public boolean mouseEvent(MouseEvent event, GuiImmediateContext context) {
        super.mouseEvent(event, context);
        if (!(event instanceof MouseEvent.Click)) {
            return false;
        }
        MouseEvent.Click click = (MouseEvent.Click)event;
        if (context.isHovered() && click.getMouseButton() == 0 && click.getMouseState()) {
            this.value.set(this.value.get() == false);
            return true;
        }
        return false;
    }

    public String toString() {
        return "SwitchComponent(value=" + this.value + ", animation=" + this.animation + ", lastValue=" + this.lastValue + ")";
    }
}

