/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.lua.objects.misc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u00120\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib;", "Lorg/luaj/vm2/lib/TwoArgFunction;", "", "scriptName", "<init>", "(Ljava/lang/String;)V", "Lorg/luaj/vm2/LuaValue;", "modname", "env", "call", "(Lorg/luaj/vm2/LuaValue;Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "", "stopThreads", "Ljava/lang/String;", "getScriptName", "()Ljava/lang/String;", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "Ljava/lang/Thread;", "threads", "Ljava/util/concurrent/ConcurrentHashMap;", "nextId", "I", "StartThread", "JoinThread", "IsAlive", "InterruptThread", "Sleep", "hypixel-cry"})
public final class ThreadLib
extends TwoArgFunction {
    @NotNull
    private final String scriptName;
    @NotNull
    private final ConcurrentHashMap<Integer, Pair<String, Thread>> threads;
    private int nextId;

    public ThreadLib(@NotNull String scriptName) {
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        this.scriptName = scriptName;
        this.threads = new ConcurrentHashMap();
        this.nextId = 1;
    }

    @NotNull
    public final String getScriptName() {
        return this.scriptName;
    }

    @Override
    @NotNull
    public LuaValue call(@NotNull LuaValue modname, @NotNull LuaValue env) {
        Intrinsics.checkNotNullParameter((Object)modname, (String)"modname");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        LuaTable library = new LuaTable();
        library.set("startThread", (LuaValue)new StartThread());
        library.set("joinThread", (LuaValue)new JoinThread());
        library.set("isAlive", (LuaValue)new IsAlive());
        library.set("interruptThread", (LuaValue)new InterruptThread());
        library.set("sleep", (LuaValue)new Sleep());
        env.set("threads", (LuaValue)library);
        return library;
    }

    public final void stopThreads(@NotNull String scriptName) {
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        this.threads.entrySet().removeIf(arg_0 -> ThreadLib.stopThreads$lambda$1(arg_0 -> ThreadLib.stopThreads$lambda$0(scriptName, arg_0), arg_0));
    }

    private static final boolean stopThreads$lambda$0(String $scriptName, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (Intrinsics.areEqual((Object)((Pair)entry.getValue()).getFirst(), (Object)$scriptName)) {
            ((Thread)((Pair)entry.getValue()).getSecond()).interrupt();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean stopThreads$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib$InterruptThread;", "Lorg/luaj/vm2/lib/OneArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib;)V", "Lorg/luaj/vm2/LuaValue;", "arg", "call", "(Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "hypixel-cry"})
    public final class InterruptThread
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            int threadId = arg.checkint();
            Object object = (Pair)ThreadLib.this.threads.get(threadId);
            if (object == null || (object = (Thread)object.getSecond()) == null) {
                LuaBoolean luaBoolean = LuaValue.FALSE;
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"FALSE");
                return luaBoolean;
            }
            Object thread = object;
            ((Thread)thread).interrupt();
            LuaBoolean luaBoolean = LuaValue.TRUE;
            Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"TRUE");
            return luaBoolean;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib$IsAlive;", "Lorg/luaj/vm2/lib/OneArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib;)V", "Lorg/luaj/vm2/LuaValue;", "arg", "call", "(Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "hypixel-cry"})
    public final class IsAlive
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            int threadId = arg.checkint();
            Object object = (Pair)ThreadLib.this.threads.get(threadId);
            if (object == null || (object = (Thread)object.getSecond()) == null) {
                LuaBoolean luaBoolean = LuaValue.FALSE;
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"FALSE");
                return luaBoolean;
            }
            Object thread = object;
            LuaBoolean luaBoolean = LuaValue.valueOf(((Thread)thread).isAlive());
            Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
            return luaBoolean;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib$JoinThread;", "Lorg/luaj/vm2/lib/OneArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib;)V", "Lorg/luaj/vm2/LuaValue;", "arg", "call", "(Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "hypixel-cry"})
    public final class JoinThread
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            int threadId = arg.checkint();
            Pair pair = (Pair)ThreadLib.this.threads.get(threadId);
            Object object = pair;
            if (object == null || (object = (Thread)object.getSecond()) == null) {
                LuaValue luaValue = LuaValue.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)luaValue, (String)"NIL");
                return luaValue;
            }
            Object thread = object;
            try {
                ((Thread)thread).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LuaValue luaValue = LuaValue.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)luaValue, (String)"NIL");
            return luaValue;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib$Sleep;", "Lorg/luaj/vm2/lib/OneArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib;)V", "Lorg/luaj/vm2/LuaValue;", "arg", "call", "(Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "hypixel-cry"})
    public final class Sleep
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            long ms = arg.checklong();
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LuaValue luaValue = LuaValue.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)luaValue, (String)"NIL");
            return luaValue;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib$StartThread;", "Lorg/luaj/vm2/lib/VarArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/ThreadLib;)V", "Lorg/luaj/vm2/Varargs;", "args", "invoke", "(Lorg/luaj/vm2/Varargs;)Lorg/luaj/vm2/Varargs;", "hypixel-cry"})
    public final class StartThread
    extends VarArgFunction {
        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            LuaValue luaFunc = args.arg(1);
            if (!luaFunc.isfunction()) {
                VarArgFunction.error("startThread expects a function as second argument");
            }
            LuaFunction func = luaFunc.checkfunction();
            int n = ThreadLib.this.nextId;
            ThreadLib.this.nextId = n + 1;
            int threadId = n;
            Thread thread = new Thread(() -> StartThread.invoke$lambda$0(func, ThreadLib.this, threadId));
            Integer n2 = threadId;
            ((Map)ThreadLib.this.threads).put(n2, new Pair((Object)ThreadLib.this.getScriptName(), (Object)thread));
            thread.start();
            LuaInteger luaInteger = LuaValue.valueOf(threadId);
            Intrinsics.checkNotNullExpressionValue((Object)luaInteger, (String)"valueOf(...)");
            return luaInteger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void invoke$lambda$0(LuaFunction $func, ThreadLib this$0, int $threadId) {
            try {
                $func.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this$0.threads.remove($threadId);
            }
        }
    }
}

