/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.internal;

public class LerpUtils {
    private static final float sigmoidStr = 8.0f;
    private static final float sigmoidA = -1.0f / (LerpUtils.sigmoid(-4.0f) - LerpUtils.sigmoid(4.0f));
    private static final float sigmoidB = sigmoidA * LerpUtils.sigmoid(-4.0f);

    public static float clampZeroOne(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    public static float sigmoid(float val) {
        return (float)(1.0 / (1.0 + Math.exp(-val)));
    }

    public static float sigmoidZeroOne(float f) {
        f = LerpUtils.clampZeroOne(f);
        return sigmoidA * LerpUtils.sigmoid(8.0f * (f - 0.5f)) - sigmoidB;
    }

    public static float lerp(float a, float b, float amount) {
        return b + (a - b) * LerpUtils.clampZeroOne(amount);
    }
}

