/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.gui.component;

import io.github.notenoughupdates.moulconfig.gui.GuiComponent;
import io.github.notenoughupdates.moulconfig.gui.GuiImmediateContext;
import io.github.notenoughupdates.moulconfig.gui.KeyboardEvent;
import io.github.notenoughupdates.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;

public class CenterComponent
extends GuiComponent {
    final GuiComponent child;

    public CenterComponent(GuiComponent child) {
        this.child = child;
    }

    @Override
    public int getWidth() {
        return this.child.getWidth();
    }

    @Override
    public int getHeight() {
        return this.child.getHeight();
    }

    GuiImmediateContext getChildContext(GuiImmediateContext context) {
        return context.translated(this.getChildOffsetX(context), this.getChildOffsetY(context), Math.min(this.child.getWidth(), context.getWidth()), Math.min(this.child.getHeight(), context.getHeight()));
    }

    public int getChildOffsetX(GuiImmediateContext context) {
        if (this.child.getWidth() > context.getWidth()) {
            return 0;
        }
        return context.getWidth() / 2 - this.child.getWidth() / 2;
    }

    public int getChildOffsetY(GuiImmediateContext context) {
        if (this.child.getHeight() > context.getHeight()) {
            return 0;
        }
        return context.getHeight() / 2 - this.child.getHeight() / 2;
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        return visitor.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(this.getChildOffsetX(context), this.getChildOffsetY(context));
        this.child.render(this.getChildContext(context));
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        return this.child.keyboardEvent(event, this.getChildContext(context));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        return this.child.mouseEvent(mouseEvent, this.getChildContext(context));
    }
}

