/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.pathfinder.calculate.path;

import com.nekiplay.hypixelcry.pathfinder.calculate.Path;
import com.nekiplay.hypixelcry.pathfinder.calculate.PathNode;
import com.nekiplay.hypixelcry.pathfinder.calculate.openset.BinaryHeapOpenSet;
import com.nekiplay.hypixelcry.pathfinder.goal.Goal;
import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import com.nekiplay.hypixelcry.pathfinder.movement.MovementResult;
import com.nekiplay.hypixelcry.pathfinder.movement.Moves;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b \u0010\u001fR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b!\u0010\u001fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010-\u001a\u0004\u0018\u00010\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010\u001d\u00a8\u00063"}, d2={"Lcom/nekiplay/hypixelcry/pathfinder/calculate/path/AStarPathFinder;", "", "", "startX", "startY", "startZ", "Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "goal", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "ctx", "<init>", "(IIILcom/nekiplay/hypixelcry/pathfinder/goal/Goal;Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;)V", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/Path;", "calculatePath", "()Lcom/nekiplay/hypixelcry/pathfinder/calculate/Path;", "x", "y", "z", "", "isChunkLoaded", "(III)Z", "", "hash", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "getNode", "(IIIJ)Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "", "requestStop", "()V", "I", "getStartX", "()I", "getStartY", "getStartZ", "Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "getGoal", "()Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "getCtx", "()Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "closedSet", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "calculating", "Z", "closestNode", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "", "closestDistance", "D", "iterations", "hypixel-cry"})
@SourceDebugExtension(value={"SMAP\nAStarPathFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AStarPathFinder.kt\ncom/nekiplay/hypixelcry/pathfinder/calculate/path/AStarPathFinder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,114:1\n37#2:115\n36#2,3:116\n*S KotlinDebug\n*F\n+ 1 AStarPathFinder.kt\ncom/nekiplay/hypixelcry/pathfinder/calculate/path/AStarPathFinder\n*L\n28#1:115\n28#1:116,3\n*E\n"})
public final class AStarPathFinder {
    private final int startX;
    private final int startY;
    private final int startZ;
    @NotNull
    private final Goal goal;
    @NotNull
    private final CalculationContext ctx;
    @NotNull
    private final Long2ObjectMap<PathNode> closedSet;
    private boolean calculating;
    @Nullable
    private PathNode closestNode;
    private double closestDistance;
    private int iterations;

    public AStarPathFinder(int startX, int startY, int startZ, @NotNull Goal goal, @NotNull CalculationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.goal = goal;
        this.ctx = ctx;
        this.closedSet = (Long2ObjectMap)new Long2ObjectOpenHashMap();
        this.closestDistance = Double.MAX_VALUE;
    }

    public final int getStartX() {
        return this.startX;
    }

    public final int getStartY() {
        return this.startY;
    }

    public final int getStartZ() {
        return this.startZ;
    }

    @NotNull
    public final Goal getGoal() {
        return this.goal;
    }

    @NotNull
    public final CalculationContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public final Path calculatePath() {
        this.calculating = true;
        this.iterations = 0;
        BinaryHeapOpenSet openSet = new BinaryHeapOpenSet(0, 1, null);
        PathNode startNode = new PathNode(this.startX, this.startY, this.startZ, this.goal);
        MovementResult res = new MovementResult();
        Collection $this$toTypedArray$iv2 = (Collection)Moves.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv2;
        Moves[] moves = thisCollection$iv.toArray(new Moves[0]);
        startNode.setCostSoFar(0.0);
        startNode.setTotalCost(startNode.getCostToEnd());
        openSet.add(startNode);
        this.closestNode = startNode;
        this.closestDistance = startNode.getCostToEnd();
        while (!openSet.isEmpty() && this.calculating && this.iterations < this.ctx.getMaxIterations()) {
            int $this$toTypedArray$iv2 = this.iterations;
            this.iterations = $this$toTypedArray$iv2 + 1;
            if (this.iterations % this.ctx.getStepSize() != 0) continue;
            PathNode currentNode = openSet.poll();
            if (currentNode.getCostToEnd() < this.closestDistance) {
                this.closestNode = currentNode;
                this.closestDistance = currentNode.getCostToEnd();
            }
            if (this.goal.isAtGoal(currentNode.getX(), currentNode.getY(), currentNode.getZ())) {
                return new Path(startNode, currentNode, this.goal, this.ctx);
            }
            for (Moves move : moves) {
                res.reset();
                move.calculate(this.ctx, currentNode.getX(), currentNode.getY(), currentNode.getZ(), res);
                double cost = res.getCost();
                boolean isLoaded = this.isChunkLoaded(res.getX(), res.getY(), res.getZ());
                if (!isLoaded) {
                    cost = this.ctx.getCost().getINF_COST() / (double)2;
                }
                if (cost >= this.ctx.getCost().getINF_COST()) continue;
                PathNode neighbourNode = this.getNode(res.getX(), res.getY(), res.getZ(), PathNode.Companion.longHash(res.getX(), res.getY(), res.getZ()));
                double neighbourCostSoFar = currentNode.getCostSoFar() + cost;
                if (!(neighbourNode.getCostSoFar() > neighbourCostSoFar)) continue;
                neighbourNode.setParentNode(currentNode);
                neighbourNode.setCostSoFar(neighbourCostSoFar);
                neighbourNode.setTotalCost(neighbourCostSoFar + neighbourNode.getCostToEnd());
                if (neighbourNode.getHeapPosition() == -1) {
                    openSet.add(neighbourNode);
                    continue;
                }
                openSet.relocate(neighbourNode);
            }
        }
        this.calculating = false;
        PathNode pathNode = this.closestNode;
        if (pathNode != null) {
            PathNode it = pathNode;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)startNode)) {
                return new Path(startNode, it, this.goal, this.ctx);
            }
        }
        return null;
    }

    private final boolean isChunkLoaded(int x, int y, int z) {
        boolean bl;
        class_638 class_6382 = this.ctx.getWorld();
        if (class_6382 != null) {
            class_638 world = class_6382;
            boolean bl2 = false;
            class_2338 pos = new class_2338(x, y, z);
            bl = world.method_8477(pos) || world.method_8477(pos.method_10069(1, 0, 0)) || world.method_8477(pos.method_10069(-1, 0, 0)) || world.method_8477(pos.method_10069(0, 0, 1)) || world.method_8477(pos.method_10069(0, 0, -1));
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final PathNode getNode(int x, int y, int z, long hash) {
        PathNode n = (PathNode)this.closedSet.get(hash);
        if (n == null) {
            n = new PathNode(x, y, z, this.goal);
            this.closedSet.put(hash, (Object)n);
        }
        return n;
    }

    public final void requestStop() {
        if (!this.calculating) {
            return;
        }
        this.calculating = false;
    }
}

