/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.mixins.BeaconBlockEntityRendererInvoker;
import com.nekiplay.hypixelcry.utils.render.FrustumUtils;
import com.nekiplay.hypixelcry.utils.render.SkyblockerRenderLayers;
import com.nekiplay.hypixelcry.utils.render.culling.OcclusionCulling;
import java.awt.Color;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_10209;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_9799;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderHelper {
    private static final class_2960 TRANSLUCENT_DRAW = class_2960.method_60655((String)"hypixelcry", (String)"translucent_draw");
    private static final int MAX_OVERWORLD_BUILD_HEIGHT = 319;
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_9799 ALLOCATOR = new class_9799(1536);

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.addPhaseOrdering(Event.DEFAULT_PHASE, TRANSLUCENT_DRAW);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(TRANSLUCENT_DRAW, RenderHelper::drawTranslucents);
    }

    public static void renderFilledWithBeaconBeam(WorldRenderContext context, class_2338 pos, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, pos, colorComponents, alpha, throughWalls);
        RenderHelper.renderBeaconBeam(context, pos, colorComponents);
    }

    public static void renderFilled(WorldRenderContext context, class_2338 pos, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colorComponents, alpha, throughWalls);
    }

    public static void renderFilled(WorldRenderContext context, class_243 pos, class_243 dimensions, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colorComponents, alpha, throughWalls);
    }

    public static void renderFilled(WorldRenderContext context, class_238 box, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colorComponents, alpha, throughWalls);
    }

    public static void renderFilled(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha, boolean throughWalls) {
        if (throughWalls) {
            if (FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
                RenderHelper.renderFilledInternal(context, minX, minY, minZ, maxX, maxY, maxZ, colorComponents, alpha, true);
            }
        } else if (OcclusionCulling.getRegularCuller().isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            RenderHelper.renderFilledInternal(context, minX, minY, minZ, maxX, maxY, maxZ, colorComponents, alpha, false);
        }
    }

    private static void renderFilledInternal(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha, boolean throughWalls) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4597 consumers = context.consumers();
        class_4588 buffer = consumers.getBuffer((class_1921)(throughWalls ? SkyblockerRenderLayers.FILLED_THROUGH_WALLS : SkyblockerRenderLayers.FILLED));
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
        matrices.method_22909();
    }

    public static void renderBeaconBeam(WorldRenderContext context, class_2338 pos, float[] colorComponents) {
        if (FrustumUtils.isVisible(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, 319.0, pos.method_10260() + 1)) {
            class_4587 matrices = context.matrixStack();
            class_243 camera = context.camera().method_19326();
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - camera.method_10216(), (double)pos.method_10264() - camera.method_10214(), (double)pos.method_10260() - camera.method_10215());
            float length = (float)camera.method_1020(pos.method_46558()).method_37267();
            float scale = RenderHelper.CLIENT.field_1724 != null && RenderHelper.CLIENT.field_1724.method_31550() ? 1.0f : Math.max(1.0f, length / 96.0f);
            BeaconBlockEntityRendererInvoker.renderBeam(matrices, context.consumers(), context.tickCounter().method_60637(true), scale, context.world().method_8510(), 0, 319, class_9848.method_61318((float)1.0f, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2]));
            matrices.method_22909();
        }
    }

    public static void renderOutline(WorldRenderContext context, class_2338 pos, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colorComponents, 1.0f, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, class_243 pos, class_243 dimensions, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colorComponents, 1.0f, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, class_238 box, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, box, colorComponents, 1.0f, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, class_238 box, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colorComponents, alpha, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        if (FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            class_4587 matrices = context.matrixStack();
            class_243 camera = context.camera().method_19326();
            matrices.method_22903();
            matrices.method_22904(-camera.method_10216(), -camera.method_10214(), -camera.method_10215());
            class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
            class_1921.class_4687 layer = throughWalls ? SkyblockerRenderLayers.getLinesThroughWalls(lineWidth) : SkyblockerRenderLayers.getLines(lineWidth);
            class_4588 buffer = consumers.getBuffer((class_1921)layer);
            class_9974.method_62292((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
            consumers.method_22994((class_1921)layer);
            matrices.method_22909();
        }
    }

    public static void renderLinesFromPoints(WorldRenderContext context, class_243[] points, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        class_243 camera = context.camera().method_19326();
        class_4587 matrices = context.matrixStack();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4587.class_4665 entry = matrices.method_23760();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = throughWalls ? SkyblockerRenderLayers.getLinesThroughWalls(lineWidth) : SkyblockerRenderLayers.getLines(lineWidth);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        for (int i2 = 0; i2 < points.length; ++i2) {
            class_243 nextPoint = points[i2 + 1 == points.length ? i2 - 1 : i2 + 1];
            Vector3f normalVec = nextPoint.method_46409().sub((float)points[i2].method_10216(), (float)points[i2].method_10214(), (float)points[i2].method_10215()).normalize();
            if (i2 + 1 == points.length) {
                normalVec.negate();
            }
            buffer.method_56824(entry, (float)points[i2].method_10216(), (float)points[i2].method_10214(), (float)points[i2].method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha).method_61959(entry, normalVec);
        }
        consumers.method_22994((class_1921)layer);
        matrices.method_22909();
    }

    public static void renderLineFromCursor(WorldRenderContext context, class_243 point, float[] colorComponents, float alpha, float lineWidth) {
        class_243 camera = context.camera().method_19326();
        class_4587 matrices = context.matrixStack();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4587.class_4665 entry = matrices.method_23760();
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = SkyblockerRenderLayers.getLinesThroughWalls(lineWidth);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        class_243 cameraPoint = camera.method_1019(class_243.method_1030((float)context.camera().method_19329(), (float)context.camera().method_19330()));
        Vector3f normal = point.method_46409().sub((float)cameraPoint.field_1352, (float)cameraPoint.field_1351, (float)cameraPoint.field_1350).normalize();
        buffer.method_56824(entry, (float)cameraPoint.field_1352, (float)cameraPoint.field_1351, (float)cameraPoint.field_1350).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha).method_61959(entry, normal);
        buffer.method_56824(entry, (float)point.method_10216(), (float)point.method_10214(), (float)point.method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha).method_61959(entry, normal);
        consumers.method_22994((class_1921)layer);
        matrices.method_22909();
    }

    public static void renderQuad(WorldRenderContext context, class_243[] points, float[] colorComponents, float alpha, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_243 camera = context.camera().method_19326();
        positionMatrix.translate((float)(-camera.field_1352), (float)(-camera.field_1351), (float)(-camera.field_1350));
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = throughWalls ? SkyblockerRenderLayers.QUADS_THROUGH_WALLS : SkyblockerRenderLayers.QUADS;
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        for (int i2 = 0; i2 < 4; ++i2) {
            buffer.method_22918(positionMatrix, (float)points[i2].method_10216(), (float)points[i2].method_10214(), (float)points[i2].method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        }
        consumers.method_22994((class_1921)layer);
    }

    public static void renderTextureInWorld(WorldRenderContext context, class_243 pos, float width, float height, float textureWidth, float textureHeight, class_243 renderOffset, class_2960 texture, float[] shaderColor, float alpha, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767());
        class_4597.class_4598 consumers = (class_4597.class_4598)context.consumers();
        class_1921.class_4687 layer = throughWalls ? SkyblockerRenderLayers.getTextureThroughWalls(texture) : SkyblockerRenderLayers.getTexture(texture);
        class_4588 buffer = consumers.getBuffer((class_1921)layer);
        int color = class_9848.method_61318((float)alpha, (float)shaderColor[0], (float)shaderColor[1], (float)shaderColor[2]);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216(), (float)renderOffset.method_10214(), (float)renderOffset.method_10215()).method_22913(1.0f, 1.0f - textureHeight).method_39415(color);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216(), (float)renderOffset.method_10214() + height, (float)renderOffset.method_10215()).method_22913(1.0f, 1.0f).method_39415(color);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216() + width, (float)renderOffset.method_10214() + height, (float)renderOffset.method_10215()).method_22913(1.0f - textureWidth, 1.0f).method_39415(color);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216() + width, (float)renderOffset.method_10214(), (float)renderOffset.method_10215()).method_22913(1.0f - textureWidth, 1.0f - textureHeight).method_39415(color);
        consumers.method_22994((class_1921)layer);
    }

    public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, boolean throughWalls) {
        RenderHelper.renderText(context, text, pos, 1.0f, throughWalls);
    }

    public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, float scale, boolean throughWalls) {
        RenderHelper.renderText(context, text, pos, scale, 0.0f, throughWalls);
    }

    public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        RenderHelper.renderText(context, text.method_30937(), pos, scale, yOffset, throughWalls);
    }

    public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = RenderHelper.CLIENT.field_1772;
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        class_4597.class_4598 consumers = class_4597.method_22991((class_9799)ALLOCATOR);
        textRenderer.method_22942(text, xOffset, yOffset, -1, false, positionMatrix, (class_4597)consumers, throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        consumers.method_22993();
    }

    public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, float alpha, float[] shaderColor, float scale, float yOffset, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = RenderHelper.CLIENT.field_1772;
        int color = class_9848.method_61318((float)alpha, (float)shaderColor[0], (float)shaderColor[1], (float)shaderColor[2]);
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        class_4597.class_4598 consumers = class_4597.method_22991((class_9799)ALLOCATOR);
        textRenderer.method_22942(text, xOffset, yOffset, color, false, positionMatrix, (class_4597)consumers, throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        consumers.method_22993();
    }

    public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, int color, float scale, float yOffset, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = RenderHelper.CLIENT.field_1772;
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        class_4597.class_4598 consumers = class_4597.method_22991((class_9799)ALLOCATOR);
        textRenderer.method_22942(text, xOffset, yOffset, color, false, positionMatrix, (class_4597)consumers, throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        consumers.method_22993();
    }

    public static void renderCylinder(WorldRenderContext context, class_243 centre, float radius, float height, int segments, int color) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4588 buffer = context.consumers().getBuffer((class_1921)SkyblockerRenderLayers.CYLINDER);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        float halfHeight = height / 2.0f;
        for (int i2 = 0; i2 <= segments; ++i2) {
            double angle = Math.PI * 2 * (double)i2 / (double)segments;
            float dx = (float)Math.cos(angle) * radius;
            float dz = (float)Math.sin(angle) * radius;
            buffer.method_22918(positionMatrix, (float)centre.method_10216() + dx, (float)centre.method_10214() + halfHeight, (float)centre.method_10215() + dz).method_39415(color);
            buffer.method_22918(positionMatrix, (float)centre.method_10216() + dx, (float)centre.method_10214() - halfHeight, (float)centre.method_10215() + dz).method_39415(color);
        }
        matrices.method_22909();
    }

    private static void drawTranslucents(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerTranslucentDraw");
        class_4597.class_4598 immediate = (class_4597.class_4598)context.consumers();
        immediate.method_22993();
        profiler.method_15407();
    }

    public static void runOnRenderThread(Runnable runnable) {
        if (RenderSystem.isOnRenderThread()) {
            runnable.run();
        } else {
            CLIENT.execute(runnable);
        }
    }

    public static class_238 getBlockBoundingBox(class_638 world, class_2338 pos) {
        return RenderHelper.getBlockBoundingBox(world, world.method_8320(pos), pos);
    }

    public static class_238 getBlockBoundingBox(class_638 world, class_2680 state, class_2338 pos) {
        return state.method_26218((class_1922)world, pos).method_52620().method_1107().method_996(pos);
    }

    private static void playNotificationSound() {
        if (RenderHelper.CLIENT.field_1724 != null) {
            RenderHelper.CLIENT.field_1724.method_5783(class_3417.field_14627, 100.0f, 0.1f);
        }
    }

    public static boolean pointIsInArea(double x, double y, double x1, double y1, double x2, double y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static void renderNineSliceColored(class_332 context, class_2960 texture, int x, int y, int width, int height, int argb) {
        context.method_52707(class_1921::method_62277, texture, x, y, width, height, argb);
    }

    public static void renderNineSliceColored(class_332 context, class_2960 texture, int x, int y, int width, int height, Color color) {
        RenderHelper.renderNineSliceColored(context, texture, x, y, width, height, class_9848.method_61324((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
    }

    public static void drawHorizontalGradient(class_332 context, float startX, float startY, float endX, float endY, int colorStart, int colorEnd) {
        context.method_64039(provider -> {
            class_4588 vertexConsumer = provider.getBuffer(class_1921.method_51784());
            Matrix4f positionMatrix = context.method_51448().method_23760().method_23761();
            vertexConsumer.method_22918(positionMatrix, startX, startY, 0.0f).method_39415(colorStart);
            vertexConsumer.method_22918(positionMatrix, startX, endY, 0.0f).method_39415(colorStart);
            vertexConsumer.method_22918(positionMatrix, endX, endY, 0.0f).method_39415(colorEnd);
            vertexConsumer.method_22918(positionMatrix, endX, startY, 0.0f).method_39415(colorEnd);
        });
    }
}

