/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Print;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.luajc.LuaJC;

public class lua {
    private static final String version = "Luaj-jse 3.0.1 Copyright (c) 2012 Luaj.org.org";
    private static final String usage = "usage: java -cp luaj-jse.jar lua [options] [script [args]].\nAvailable options are:\n  -e stat  execute string 'stat'\n  -l name  require library 'name'\n  -i       enter interactive mode after executing 'script'\n  -v       show version information\n  -b      \tuse luajc bytecode-to-bytecode compiler (requires bcel on class path)\n  -n      \tnodebug - do not load debug library by default\n  -p      \tprint the prototype\n  -c enc  \tuse the supplied encoding 'enc' for input files\n  --       stop handling options\n  -        execute stdin and stop handling options";
    private static Globals globals;
    private static boolean print;
    private static String encoding;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = stringArray.length == 0;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        Vector vector = null;
        try {
            int n;
            int n2;
            block18: for (n2 = 0; n2 < stringArray.length && bl3 && stringArray[n2].startsWith("-") && stringArray[n2].length() > 1; ++n2) {
                switch (stringArray[n2].charAt(1)) {
                    case 'e': {
                        if (++n2 < stringArray.length) continue block18;
                        lua.usageExit();
                        continue block18;
                    }
                    case 'b': {
                        bl5 = true;
                        continue block18;
                    }
                    case 'l': {
                        if (++n2 >= stringArray.length) {
                            lua.usageExit();
                        }
                        vector = vector != null ? vector : new Vector();
                        vector.addElement(stringArray[n2]);
                        continue block18;
                    }
                    case 'i': {
                        bl = true;
                        continue block18;
                    }
                    case 'v': {
                        bl2 = true;
                        continue block18;
                    }
                    case 'n': {
                        bl4 = true;
                        continue block18;
                    }
                    case 'p': {
                        print = true;
                        continue block18;
                    }
                    case 'c': {
                        if (++n2 >= stringArray.length) {
                            lua.usageExit();
                        }
                        encoding = stringArray[n2];
                        continue block18;
                    }
                    case '-': {
                        if (stringArray[n2].length() > 2) {
                            lua.usageExit();
                        }
                        bl3 = false;
                        continue block18;
                    }
                    default: {
                        lua.usageExit();
                    }
                }
            }
            if (bl2) {
                System.out.println(version);
            }
            Globals globals = lua.globals = bl4 ? JsePlatform.standardGlobals() : JsePlatform.debugGlobals();
            if (bl5) {
                LuaJC.install(lua.globals);
            }
            int n3 = n = vector != null ? vector.size() : 0;
            for (n2 = 0; n2 < n; ++n2) {
                lua.loadLibrary((String)vector.elementAt(n2));
            }
            bl3 = true;
            block20: for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!bl3 || !stringArray[n2].startsWith("-")) {
                    lua.processScript(new FileInputStream(stringArray[n2]), stringArray[n2], stringArray, n2);
                    break;
                }
                if ("-".equals(stringArray[n2])) {
                    lua.processScript(System.in, "=stdin", stringArray, n2);
                    break;
                }
                switch (stringArray[n2].charAt(1)) {
                    case 'c': 
                    case 'l': {
                        ++n2;
                        continue block20;
                    }
                    case 'e': {
                        lua.processScript(new ByteArrayInputStream(stringArray[++n2].getBytes()), "string", stringArray, n2);
                        continue block20;
                    }
                    case '-': {
                        bl3 = false;
                    }
                }
            }
            if (bl) {
                lua.interactiveMode();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            System.exit(-2);
        }
    }

    private static void loadLibrary(String string) throws IOException {
        LuaString luaString = LuaValue.valueOf(string);
        try {
            globals.get("require").call(luaString);
        }
        catch (Exception exception) {
            try {
                LuaValue luaValue = (LuaValue)Class.forName(string).newInstance();
                luaValue.call(luaString, globals);
            }
            catch (Exception exception2) {
                throw new IOException("loadLibrary(" + string + ") failed: " + exception + "," + exception2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processScript(InputStream inputStream, String string, String[] stringArray, int n) throws IOException {
        try {
            LuaValue luaValue;
            try {
                inputStream = new BufferedInputStream(inputStream);
                luaValue = encoding != null ? globals.load(new InputStreamReader(inputStream, encoding), string) : globals.load(inputStream, string, "bt", globals);
            }
            finally {
                inputStream.close();
            }
            if (print && luaValue.isclosure()) {
                Print.print(luaValue.checkclosure().p);
            }
            Varargs varargs = lua.setGlobalArg(string, stringArray, n, globals);
            luaValue.invoke(varargs);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static Varargs setGlobalArg(String string, String[] stringArray, int n, LuaValue luaValue) {
        if (stringArray == null) {
            return LuaValue.NONE;
        }
        LuaTable luaTable = LuaValue.tableOf();
        for (int j = 0; j < stringArray.length; ++j) {
            luaTable.set(j - n, (LuaValue)LuaValue.valueOf(stringArray[j]));
        }
        luaTable.set(0, (LuaValue)LuaValue.valueOf(string));
        luaTable.set(-1, (LuaValue)LuaValue.valueOf("luaj"));
        luaValue.set("arg", (LuaValue)luaTable);
        return luaTable.unpack();
    }

    private static void interactiveMode() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("> ");
            System.out.flush();
            String string = bufferedReader.readLine();
            if (string == null) {
                return;
            }
            lua.processScript(new ByteArrayInputStream(string.getBytes()), "=stdin", null, 0);
        }
    }

    static {
        print = false;
        encoding = null;
    }
}

