/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.nekiplay.hypixelcry.commands.EntityInfoCommand;
import com.nekiplay.hypixelcry.commands.PathFinderCommand;
import com.nekiplay.hypixelcry.config.NEUConfig;
import com.nekiplay.hypixelcry.features.Test;
import com.nekiplay.hypixelcry.features.commands.impl.LuaCommand;
import com.nekiplay.hypixelcry.features.esp.ChestESP;
import com.nekiplay.hypixelcry.features.esp.mining.dwarvenmines.DarkMonolithESP;
import com.nekiplay.hypixelcry.features.esp.mining.glacitemineshafts.FrozenCourpes;
import com.nekiplay.hypixelcry.features.esp.pathfinder.PathFinderWorker;
import com.nekiplay.hypixelcry.features.lua.LuaManager;
import com.nekiplay.hypixelcry.features.macros.AutoChestClose;
import com.nekiplay.hypixelcry.features.macros.AutoRightClick;
import com.nekiplay.hypixelcry.features.macros.GhostBlocks;
import com.nekiplay.hypixelcry.features.modules.ModuleManager;
import com.nekiplay.hypixelcry.utils.ConfigUtil;
import com.nekiplay.hypixelcry.utils.Utils;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.render.SkyblockerRenderPipelines;
import com.nekiplay.hypixelcry.utils.render.culling.OcclusionCulling;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import com.nekiplay.hypixelcry.utils.trackers.ColdTracker;
import com.nekiplay.hypixelcry.utils.trackers.StatusBarTracker;
import io.github.notenoughupdates.moulconfig.common.IMinecraft;
import io.github.notenoughupdates.moulconfig.gui.MoulConfigEditor;
import io.github.notenoughupdates.moulconfig.observer.PropertyTypeAdapterFactory;
import io.github.notenoughupdates.moulconfig.processor.BuiltinMoulConfigGuis;
import io.github.notenoughupdates.moulconfig.processor.ConfigProcessorDriver;
import io.github.notenoughupdates.moulconfig.processor.MoulConfigProcessor;
import java.io.File;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypixelCry
implements ClientModInitializer {
    public static final String MOD_ID = "hypixelcry";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hypixelcry");
    public static LuaManager LUA_MANAGER;
    public static final String PREFIX;
    public static NEUConfig config;
    private static File configFile;
    private static File neuDir;
    private static final Gson gson;
    public static MoulConfigProcessor<NEUConfig> processor;
    public static class_310 mc;
    private static HypixelCry INSTANCE;
    private ArrayList<String> startUpScriptNames = new ArrayList<String>(){
        {
            this.add("autoload.lua");
            this.add("startup.lua");
            this.add("init.lua");
        }
    };

    @Deprecated
    public HypixelCry() {
        INSTANCE = this;
    }

    public static HypixelCry getInstance() {
        return INSTANCE;
    }

    public static void saveConfig() {
        ConfigUtil.saveConfig(config, configFile, gson);
    }

    public void onInitializeClient() {
        File libsDir;
        File scriptsDir;
        neuDir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID).toFile();
        neuDir.mkdirs();
        configFile = new File(neuDir, "config.json");
        if (configFile.exists()) {
            config = ConfigUtil.loadConfig(NEUConfig.class, configFile, gson);
        }
        if (config == null) {
            config = new NEUConfig();
            HypixelCry.saveConfig();
        }
        if (!(scriptsDir = new File(neuDir, "scripts")).exists()) {
            scriptsDir.mkdir();
        }
        if (!(libsDir = new File(scriptsDir, "libs")).exists()) {
            libsDir.mkdir();
        }
        processor = new MoulConfigProcessor<NEUConfig>(config);
        BuiltinMoulConfigGuis.addProcessors(processor);
        ConfigProcessorDriver driver = new ConfigProcessorDriver(processor);
        driver.checkExpose = false;
        driver.warnForPrivateFields = false;
        driver.processConfig(config);
        LUA_MANAGER = new LuaManager();
        Runtime.getRuntime().addShutdownHook(new Thread(HypixelCry::saveConfig));
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cry").executes(context -> {
            class_310.method_1551().method_63588(() -> {
                MoulConfigEditor<NEUConfig> editor = new MoulConfigEditor<NEUConfig>(processor);
                IMinecraft.getInstance().openWrappedScreen(editor);
            });
            return 0;
        })));
        ClientCommandRegistrationCallback.EVENT.register(LuaCommand.INSTANCE::register);
        HypixelCry.init();
        ModuleManager.INSTANCE.registerInbuilt();
        Scheduler.INSTANCE.scheduleCyclic(Utils::update, 20);
        this.loadStartupScripts(scriptsDir);
    }

    private void loadStartupScripts(File dir) {
        for (String name : this.startUpScriptNames) {
            File autoLoadScript = new File(dir, name);
            if (!autoLoadScript.exists()) continue;
            try {
                LUA_MANAGER.executeScript(autoLoadScript);
                System.out.println("Autoload script executed successfully");
            }
            catch (Exception e) {
                System.out.println("Error executing autoload script: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void tick(class_310 client) {
        Scheduler.INSTANCE.tick();
    }

    private static void init() {
        EntityInfoCommand.init();
        PathFinderCommand.init();
        Test.init();
        ChestESP.init();
        DarkMonolithESP.init();
        FrozenCourpes.init();
        PathFinderWorker.init();
        AutoChestClose.init();
        AutoRightClick.init();
        GhostBlocks.init();
        com.nekiplay.hypixelcry.utils.StatusBarTracker.init();
        Utils.init();
        RenderHelper.init();
        SkyblockerRenderPipelines.init();
        OcclusionCulling.init();
        ColdTracker.init();
        StatusBarTracker.init();
    }

    static {
        PREFIX = String.valueOf(class_124.field_1080) + "[" + String.valueOf(class_124.field_1065) + "Hypixel Cry" + String.valueOf(class_124.field_1080) + "] " + String.valueOf(class_124.field_1070);
        gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().registerTypeAdapterFactory((TypeAdapterFactory)new PropertyTypeAdapterFactory()).create();
        processor = null;
        mc = class_310.method_1551();
    }
}

