/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.events.SkyblockEvents;
import com.nekiplay.hypixelcry.utils.Area;
import com.nekiplay.hypixelcry.utils.Location;
import com.nekiplay.hypixelcry.utils.purse.PurseChangeCause;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azureaaron.hmapi.data.rank.MonthlyPackageRank;
import net.azureaaron.hmapi.data.rank.PackageRank;
import net.azureaaron.hmapi.data.rank.PlayerRank;
import net.azureaaron.hmapi.data.rank.RankType;
import net.azureaaron.hmapi.data.server.Environment;
import net.azureaaron.hmapi.events.HypixelPacketEvents;
import net.azureaaron.hmapi.network.HypixelNetworking;
import net.azureaaron.hmapi.network.packet.s2c.ErrorS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HelloS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HypixelS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.LocationUpdateS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.PlayerInfoS2CPacket;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7887;
import net.minecraft.class_8646;
import net.minecraft.class_9015;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static final ObjectArrayList<String> STRING_SCOREBOARD = new ObjectArrayList();
    public static final ObjectArrayList<class_2561> TEXT_SCOREBOARD = new ObjectArrayList();
    private static final class_7225.class_7874 LOOKUP = class_7887.method_46817();
    private static final String ALTERNATE_HYPIXEL_ADDRESS = System.getProperty("skyblocker.alternateHypixelAddress", "");
    private static final String PROFILE_PREFIX = "Profile: ";
    private static final Pattern PURSE = Pattern.compile("(Purse|Piggy): (?<purse>[0-9,.]+)( \\((?<change>[+\\-][0-9,.]+)\\))?");
    private static boolean isOnHypixel = false;
    private static boolean isOnSkyblock = false;
    @NotNull
    private static Environment environment = Environment.PRODUCTION;
    @NotNull
    private static Location location = Location.UNKNOWN;
    @NotNull
    private static Area area = Area.UNKNOWN;
    @NotNull
    private static String profile = "";
    @NotNull
    private static RankType rank = PackageRank.NONE;
    @NotNull
    private static String server = "";
    @NotNull
    private static String gameType = "";
    @NotNull
    private static String locationRaw = "";
    @NotNull
    private static String map = "";
    @NotNull
    private static double purse = 0.0;
    @NotNull
    private static int profileIdRequest = 0;
    private static boolean firstProfileUpdate = true;

    public static boolean copyToClipboard(String text2) {
        try {
            StringSelection selection = new StringSelection(text2);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
            return true;
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430: " + e.getMessage());
            return false;
        }
    }

    @Init
    public static void init() {
        HypixelNetworking.registerToEvents((Object2IntMap)((Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> map.put((Object)LocationUpdateS2CPacket.ID, 1))));
        HypixelPacketEvents.HELLO.register(Utils::onPacket);
        HypixelPacketEvents.LOCATION_UPDATE.register(Utils::onPacket);
        HypixelPacketEvents.PLAYER_INFO.register(Utils::onPacket);
    }

    private static void updatePlayerPresence(class_310 client) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if ((client.field_1687 == null || client.method_1542()) && fabricLoader.isDevelopmentEnvironment()) {
            isOnSkyblock = true;
        }
        if (fabricLoader.isDevelopmentEnvironment() || Utils.isConnectedToHypixel(client)) {
            if (!isOnHypixel) {
                isOnHypixel = true;
            }
        } else if (isOnHypixel) {
            isOnHypixel = false;
        }
    }

    private static boolean isConnectedToHypixel(class_310 client) {
        String serverAddress = client.method_1558() != null ? client.method_1558().field_3761.toLowerCase() : "";
        String serverBrand = client.field_1724 != null && client.field_1724.field_3944 != null && client.field_1724.field_3944.method_52790() != null ? client.field_1724.field_3944.method_52790() : "";
        return !serverAddress.isEmpty() && serverAddress.equalsIgnoreCase(ALTERNATE_HYPIXEL_ADDRESS) || serverAddress.contains("hypixel.net") || serverAddress.contains("hypixel.io") || serverBrand.contains("Hypixel BungeeCord");
    }

    public static void openUrl(String url) {
        try {
            Desktop desk = Desktop.getDesktop();
            desk.browse(new URI(url));
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException ignored) {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec("xdg-open " + url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static Location getLocation() {
        return location;
    }

    public static boolean isOnHypixel() {
        return isOnHypixel;
    }

    public static boolean isOnSkyblock() {
        return isOnSkyblock;
    }

    public static boolean isInDungeons() {
        return location == Location.DUNGEON;
    }

    public static boolean isInCrystalHollows() {
        return location == Location.CRYSTAL_HOLLOWS;
    }

    public static boolean isInDwarvenMines() {
        return location == Location.DWARVEN_MINES || location == Location.GLACITE_MINESHAFT;
    }

    public static boolean isInTheRift() {
        return location == Location.THE_RIFT;
    }

    public static boolean isInGarden() {
        return location == Location.GARDEN;
    }

    public static boolean isInTheEnd() {
        return location == Location.THE_END;
    }

    public static boolean isInKuudra() {
        return location == Location.KUUDRAS_HOLLOW;
    }

    public static boolean isInCrimson() {
        return location == Location.CRIMSON_ISLE;
    }

    public static boolean isInGalatea() {
        return location == Location.GALATEA;
    }

    public static boolean isOnBingo() {
        return profile.endsWith("\u24b7");
    }

    public static double getPurse() {
        return purse;
    }

    @NotNull
    public static Area getArea() {
        return area;
    }

    public static String getIslandArea() {
        try {
            for (String sidebarLine : STRING_SCOREBOARD) {
                if (!sidebarLine.contains("\u23e3") && !sidebarLine.contains("\u0444")) continue;
                return sidebarLine.strip();
            }
        }
        catch (IndexOutOfBoundsException e) {
            HypixelCry.LOGGER.error("[HypixelCry] Failed to get location from sidebar", (Throwable)e);
        }
        return "Unknown";
    }

    public static void update() {
        class_310 client = class_310.method_1551();
        Utils.updateScoreboard(client);
        Utils.updatePlayerPresence(client);
        Utils.updateFromPlayerList(client);
    }

    private static void updateScoreboard(class_310 client) {
        try {
            TEXT_SCOREBOARD.clear();
            STRING_SCOREBOARD.clear();
            class_746 player = client.field_1724;
            if (player == null) {
                return;
            }
            class_269 scoreboard = player.method_7327();
            class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
            ObjectArrayList textLines = new ObjectArrayList();
            ObjectArrayList stringLines = new ObjectArrayList();
            for (class_9015 scoreHolder : scoreboard.method_1178()) {
                class_268 team;
                if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null) continue;
                class_5250 textLine = class_2561.method_43473().method_10852((class_2561)team.method_1144().method_27661()).method_10852((class_2561)team.method_1136().method_27661());
                String strLine = team.method_1144().getString() + team.method_1136().getString();
                if (strLine.trim().isEmpty()) continue;
                String formatted = class_124.method_539((String)strLine);
                textLines.add((Object)textLine);
                stringLines.add((Object)formatted);
            }
            if (objective != null) {
                stringLines.add((Object)objective.method_1114().getString());
                textLines.add((Object)class_2561.method_43473().method_10852((class_2561)objective.method_1114().method_27661()));
                Collections.reverse(stringLines);
                Collections.reverse(textLines);
            }
            TEXT_SCOREBOARD.addAll((ObjectList)textLines);
            STRING_SCOREBOARD.addAll((ObjectList)stringLines);
            if (isOnSkyblock) {
                Utils.updatePurse();
                Utils.updateArea();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void updatePurse() {
        STRING_SCOREBOARD.stream().filter(s -> s.contains("Piggy:") || s.contains("Purse:")).findFirst().ifPresent(purseString -> {
            Matcher matcher = PURSE.matcher((CharSequence)purseString);
            if (matcher.find()) {
                try {
                    double newPurse = Double.parseDouble(matcher.group("purse").replaceAll(",", ""));
                    double changeSinceLast = newPurse - purse;
                    if (changeSinceLast == 0.0) {
                        return;
                    }
                    ((SkyblockEvents.PurseChange)SkyblockEvents.PURSE_CHANGE.invoker()).onPurseChange(changeSinceLast, PurseChangeCause.getCause(changeSinceLast));
                    purse = newPurse;
                }
                catch (NumberFormatException e) {
                    HypixelCry.LOGGER.error("[Skyblocker] Failed to parse purse string. Input: '{}'", purseString, (Object)e);
                }
            }
        });
    }

    private static void updateFromPlayerList(class_310 client) {
        if (client.method_1562() == null) {
            return;
        }
        for (class_640 playerListEntry : client.method_1562().method_2880()) {
            String name;
            if (playerListEntry.method_2971() == null || !(name = playerListEntry.method_2971().getString()).startsWith(PROFILE_PREFIX)) continue;
            profile = name.substring(PROFILE_PREFIX.length());
        }
    }

    private static void updateArea() {
        Area oldArea = area;
        String areaName = Utils.getIslandArea().replaceAll("[\u23e3\u0444]", "").strip();
        if (!oldArea.equals((Object)(area = Area.from(areaName)))) {
            ((SkyblockEvents.SkyblockAreaChange)SkyblockEvents.AREA_CHANGE.invoker()).onSkyblockAreaChange(area);
        }
    }

    private static void tickProfileId() {
        ++profileIdRequest;
        Scheduler.INSTANCE.schedule(new Runnable(){
            private final int requestId = profileIdRequest;

            @Override
            public void run() {
            }
        }, 160);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void onPacket(HypixelS2CPacket packet) {
        HypixelS2CPacket hypixelS2CPacket = packet;
        Objects.requireNonNull(hypixelS2CPacket);
        HypixelS2CPacket hypixelS2CPacket2 = hypixelS2CPacket;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HelloS2CPacket.class, LocationUpdateS2CPacket.class, ErrorS2CPacket.class, PlayerInfoS2CPacket.class}, (Object)hypixelS2CPacket2, n)) {
                case 0: {
                    HelloS2CPacket helloS2CPacket = (HelloS2CPacket)hypixelS2CPacket2;
                    try {
                        Environment environment;
                        Environment environment2;
                        Utils.environment = environment2 = (environment = helloS2CPacket.environment());
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    HypixelNetworking.sendPlayerInfoC2SPacket((int)1);
                    return;
                }
                case 1: {
                    String previousServerType;
                    Object map;
                    Object object;
                    LocationUpdateS2CPacket locationUpdateS2CPacket = (LocationUpdateS2CPacket)hypixelS2CPacket2;
                    {
                        object = locationUpdateS2CPacket.serverName();
                        Object serverName = object;
                        Object serverType = object = locationUpdateS2CPacket.serverType();
                        object = locationUpdateS2CPacket.lobbyName();
                        Object _lobbyName = object;
                        Object mode = object = locationUpdateS2CPacket.mode();
                        map = object = locationUpdateS2CPacket.map();
                        server = serverName;
                        previousServerType = gameType;
                        gameType = ((Optional)serverType).orElse("");
                        locationRaw = ((Optional)mode).orElse("");
                    }
                    location = Location.from(locationRaw);
                    Utils.map = ((Optional)map).orElse("");
                    ((SkyblockEvents.SkyblockLocationChange)SkyblockEvents.LOCATION_CHANGE.invoker()).onSkyblockLocationChange(location);
                    if (gameType.equals("SKYBLOCK")) {
                        isOnSkyblock = true;
                        Utils.tickProfileId();
                        if (previousServerType.equals("SKYBLOCK")) return;
                        ((SkyblockEvents.SkyblockJoin)SkyblockEvents.JOIN.invoker()).onSkyblockJoin();
                        return;
                    }
                    if (!previousServerType.equals("SKYBLOCK")) return;
                    isOnSkyblock = false;
                    ((SkyblockEvents.SkyblockLeave)SkyblockEvents.LEAVE.invoker()).onSkyblockLeave();
                    return;
                }
                case 2: {
                    PlayerInfoS2CPacket error2;
                    PlayerInfoS2CPacket id;
                    PlayerInfoS2CPacket playerInfoS2CPacket;
                    Object object = (ErrorS2CPacket)hypixelS2CPacket2;
                    {
                        id = playerInfoS2CPacket = object.id();
                        error2 = playerInfoS2CPacket = object.reason();
                    }
                    if (id.equals((Object)LocationUpdateS2CPacket.ID)) {
                        server = "";
                        gameType = "";
                        locationRaw = "";
                        location = Location.UNKNOWN;
                        map = "";
                        class_746 player = class_310.method_1551().field_1724;
                        HypixelCry.LOGGER.error("[Skyblocker] Failed to update your current location! Some features of the mod may not work correctly :( - Error: {}", (Object)error2);
                        return;
                    }
                    n = 3;
                    continue block11;
                }
                case 3: {
                    PlayerRank monthlyPackageRank;
                    PlayerRank packageRank;
                    PlayerRank playerRank;
                    PlayerInfoS2CPacket playerInfoS2CPacket = (PlayerInfoS2CPacket)hypixelS2CPacket2;
                    {
                        Object object;
                        playerRank = object = playerInfoS2CPacket.playerRank();
                        packageRank = object = playerInfoS2CPacket.packageRank();
                        monthlyPackageRank = object = playerInfoS2CPacket.monthlyPackageRank();
                        Object _prefix = object = playerInfoS2CPacket.prefix();
                    }
                    rank = RankType.getEffectiveRank((PlayerRank)playerRank, (PackageRank)packageRank, (MonthlyPackageRank)monthlyPackageRank);
                    return;
                }
            }
            break;
        }
    }

    public static class_7225.class_7874 getRegistryWrapperLookup() {
        class_310 client = class_310.method_1551();
        return client != null && client.method_1562() != null && client.method_1562().method_29091() != null ? client.method_1562().method_29091() : LOOKUP;
    }
}

