/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.notenoughupdates.moulconfig.ChromaColour;
import java.io.IOException;

public class LegacyStringChromaColourTypeAdapter
extends TypeAdapter<ChromaColour> {
    private final boolean serializeAsLegacyString;
    private static final Gson defaultGson = new Gson();

    public void write(JsonWriter jsonWriter, ChromaColour chromaColour) throws IOException {
        if (this.serializeAsLegacyString) {
            jsonWriter.value(chromaColour.toLegacyString());
        } else {
            defaultGson.toJson((Object)chromaColour, ChromaColour.class, jsonWriter);
        }
    }

    public ChromaColour read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.STRING) {
            return ChromaColour.forLegacyString(jsonReader.nextString());
        }
        return (ChromaColour)defaultGson.fromJson(jsonReader, ChromaColour.class);
    }

    public LegacyStringChromaColourTypeAdapter(boolean serializeAsLegacyString) {
        this.serializeAsLegacyString = serializeAsLegacyString;
    }

    public String toString() {
        return "LegacyStringChromaColourTypeAdapter(serializeAsLegacyString=" + this.isSerializeAsLegacyString() + ")";
    }

    public boolean isSerializeAsLegacyString() {
        return this.serializeAsLegacyString;
    }
}

