/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.CoerceLuaToJava;
import org.luaj.vm2.lib.jse.JavaMember;

class JavaConstructor
extends JavaMember {
    static final Map constructors = Collections.synchronizedMap(new HashMap());
    final Constructor constructor;

    static JavaConstructor forConstructor(Constructor constructor) {
        JavaConstructor javaConstructor = (JavaConstructor)constructors.get(constructor);
        if (javaConstructor == null) {
            javaConstructor = new JavaConstructor(constructor);
            constructors.put(constructor, javaConstructor);
        }
        return javaConstructor;
    }

    public static LuaValue forConstructors(JavaConstructor[] javaConstructorArray) {
        return new Overload(javaConstructorArray);
    }

    private JavaConstructor(Constructor constructor) {
        super(constructor.getParameterTypes(), constructor.getModifiers());
        this.constructor = constructor;
    }

    public Varargs invoke(Varargs varargs) {
        Object[] objectArray = this.convertArgs(varargs);
        try {
            return CoerceJavaToLua.coerce(this.constructor.newInstance(objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new LuaError(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            return LuaValue.error("coercion error " + exception);
        }
    }

    static class Overload
    extends VarArgFunction {
        final JavaConstructor[] constructors;

        public Overload(JavaConstructor[] javaConstructorArray) {
            this.constructors = javaConstructorArray;
        }

        public Varargs invoke(Varargs varargs) {
            JavaConstructor javaConstructor = null;
            int n = CoerceLuaToJava.SCORE_UNCOERCIBLE;
            for (int j = 0; j < this.constructors.length; ++j) {
                int n2 = this.constructors[j].score(varargs);
                if (n2 >= n) continue;
                n = n2;
                javaConstructor = this.constructors[j];
                if (n == 0) break;
            }
            if (javaConstructor == null) {
                LuaValue.error("no coercible public method");
            }
            return javaConstructor.invoke(varargs);
        }
    }
}

