/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.utils.EntityUtils;
import com.nekiplay.hypixelcry.utils.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class EntityInfoCommand {
    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"entityinfo").executes(context -> {
            EntityInfoCommand.execute((FabricClientCommandSource)context.getSource());
            return 1;
        })));
    }

    private static void execute(FabricClientCommandSource source) {
        class_310 client = class_310.method_1551();
        StringBuilder copy = new StringBuilder();
        try {
            class_3966 entityHit;
            List armorStands;
            GameProfile profile;
            class_1657 playerEntity;
            class_1799 helmet;
            class_1531 headEntity;
            class_9296 profile2;
            class_1799 helmet2;
            class_1531 skullEntity;
            class_1297 nametagEntity = EntityInfoCommand.getNearestEntityWithName(client);
            class_1297 nameEntity = EntityInfoCommand.getNearestEntity(client);
            if (nametagEntity != null && nameEntity != null) {
                class_2561 nametag = nametagEntity.method_5797();
                if (nametag != null) {
                    String formattedNametag = TextUtils.textToFormattingString(nametag);
                    source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[Custom name] " + formattedNametag)));
                    copy.append("[Custom name] ").append(formattedNametag).append("\n");
                }
                String formattedName = TextUtils.textToFormattingString(nameEntity.method_5477());
                source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[Name] " + formattedName)));
                copy.append("[Name] ").append(formattedName).append("\n");
            }
            if ((skullEntity = EntityInfoCommand.getNearestSkullEntity(client)) != null && (helmet2 = skullEntity.method_6118(class_1304.field_6169)) != null && helmet2.method_31574(class_1802.field_8575) && (profile2 = (class_9296)helmet2.method_58694(class_9334.field_49617)) != null && profile2.method_73313() != null && profile2.method_73313().id() != null) {
                String id = profile2.method_73313().id().toString();
                source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[ArmorStand SkullOwner] " + id)));
                copy.append("[ArmorStand SkullOwner] ").append(id).append("\n");
            }
            if ((headEntity = EntityInfoCommand.getNearestHeadNameEntity(client)) != null && (helmet = headEntity.method_6118(class_1304.field_6169)) != null && !helmet.method_7960()) {
                String helmetName = TextUtils.textToFormattingString(helmet.method_7964());
                source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[ArmorStand Head Name] " + helmetName)));
                copy.append("[ArmorStand Head name] ").append(helmetName).append("\n");
            }
            if ((playerEntity = EntityInfoCommand.getNearestPlayer(client)) != null && (profile = playerEntity.method_7334()) != null) {
                Collection textures = profile.properties().get((Object)"textures");
                for (Property entry : textures) {
                    if (entry == null || entry.value() == null) continue;
                    String playerName = playerEntity.method_5477().getString();
                    source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[" + playerName + "] [Skin id] " + entry.value())));
                    copy.append("[").append(playerName).append("] [Skin id] ").append(entry.value()).append("\n");
                }
            }
            if (client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331 && !(armorStands = client.field_1687.method_8390(class_1531.class, (entityHit = (class_3966)client.field_1765).method_17782().method_5829().method_1009(0.0, 0.1, 0.0), e -> e != null && !TextUtils.textToFormattingString(e.method_5477()).equals("\u00a7e\u00a7lCLICK"))).isEmpty()) {
                armorStands.sort(Comparator.comparingDouble(e -> e.method_5858(entityHit.method_17782())));
                for (class_1531 armorStand : armorStands) {
                    if (armorStand == null) continue;
                    String armorStandName = TextUtils.textToFormattingString(armorStand.method_5477());
                    source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[Entity above cursor] [Name] " + armorStandName)));
                    copy.append("[Entity above cursor] [Name] ").append(armorStandName).append("\n");
                }
                class_1531 first = (class_1531)armorStands.getFirst();
                if (first != null) {
                    String firstArmorStandName = TextUtils.textToFormattingString(first.method_5477());
                    source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "[Entity cursor] [Name] " + firstArmorStandName)));
                    copy.append("[Entity cursor] [Name] ").append(firstArmorStandName).append("\n");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private static class_1297 getNearestEntity(class_310 client) {
        Iterator iterator = client.field_1687.method_18112().iterator();
        class_1297 closest = null;
        double closestDistance = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            double distance;
            class_1297 entity = (class_1297)iterator.next();
            if (entity == client.field_1724 || !((distance = entity.method_5858((class_1297)client.field_1724)) < closestDistance)) continue;
            closest = entity;
            closestDistance = distance;
        }
        return closest;
    }

    @Nullable
    private static class_1297 getNearestEntityWithName(class_310 client) {
        Iterator iterator = client.field_1687.method_18112().iterator();
        class_1297 closest = null;
        double closestDistance = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            double distance;
            class_1297 entity = (class_1297)iterator.next();
            if (!entity.method_16914() || !((distance = entity.method_5858((class_1297)client.field_1724)) < closestDistance)) continue;
            closest = entity;
            closestDistance = distance;
        }
        return closest;
    }

    @Nullable
    private static class_1531 getNearestHeadNameEntity(class_310 client) {
        ArrayList<class_1531> armorStands = new ArrayList<class_1531>();
        for (class_1297 entity : client.field_1687.method_18112()) {
            class_1531 armorStand;
            if (!(entity instanceof class_1531) || (armorStand = (class_1531)entity).method_6118(class_1304.field_6169).method_7960()) continue;
            armorStands.add(armorStand);
        }
        return armorStands.stream().min(Comparator.comparingDouble(e -> e.method_5858((class_1297)client.field_1724))).orElse(null);
    }

    @Nullable
    private static class_1531 getNearestSkullEntity(class_310 client) {
        ArrayList<class_1531> armorStands = new ArrayList<class_1531>();
        for (class_1297 entity : client.field_1687.method_18112()) {
            class_1531 armorStand;
            if (!(entity instanceof class_1531) || EntityUtils.getArmorStandSkullOwner(armorStand = (class_1531)entity) == null) continue;
            armorStands.add(armorStand);
        }
        return armorStands.stream().min(Comparator.comparingDouble(e -> e.method_5858((class_1297)client.field_1724))).orElse(null);
    }

    @Nullable
    private static class_1657 getNearestPlayer(class_310 client) {
        ArrayList<class_1657> players = new ArrayList<class_1657>();
        for (class_1297 entity : client.field_1687.method_18112()) {
            if (!(entity instanceof class_1657) || entity == client.field_1724) continue;
            players.add((class_1657)entity);
        }
        return players.stream().min(Comparator.comparingDouble(e -> e.method_5858((class_1297)client.field_1724))).orElse(null);
    }
}

