/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.features.esp.pathfinder.PathFinderWorker;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class PathFinderCommand {
    private static final String CUSTOM_PATH_ID = "Custom";
    private static final float[] DEFAULT_COLOR = new float[]{1.0f, 0.0f, 0.0f, 0.5f};

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(PathFinderCommand::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"path").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_2338 targetPos = PathFinderCommand.getBlockPosFromContext((CommandContext<FabricClientCommandSource>)context);
            PathFinderWorker.addOrUpdatePath(CUSTOM_PATH_ID, targetPos, DEFAULT_COLOR, CUSTOM_PATH_ID, true, true);
            PathFinderCommand.sendFeedback((CommandContext<FabricClientCommandSource>)context, HypixelCry.PREFIX + "\u00a7aSet path to position: " + targetPos.method_23854());
            return 1;
        })))))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
            if (PathFinderWorker.hasPath(CUSTOM_PATH_ID)) {
                PathFinderWorker.removePath(CUSTOM_PATH_ID);
                PathFinderCommand.sendFeedback((CommandContext<FabricClientCommandSource>)context, HypixelCry.PREFIX + "\u00a7aCleared custom path");
            } else {
                PathFinderCommand.sendFeedback((CommandContext<FabricClientCommandSource>)context, HypixelCry.PREFIX + "\u00a7cNo custom path to clear");
            }
            return 1;
        })));
    }

    private static class_2338 getBlockPosFromContext(CommandContext<FabricClientCommandSource> context) {
        int x = IntegerArgumentType.getInteger(context, (String)"x");
        int y = IntegerArgumentType.getInteger(context, (String)"y");
        int z = IntegerArgumentType.getInteger(context, (String)"z");
        return new class_2338(x, y, z);
    }

    private static void sendFeedback(CommandContext<FabricClientCommandSource> context, String message) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)message));
    }
}

