/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void recursiveDelete(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(dir, new LinkOption[0]) && !Files.isSymbolicLink(dir)) {
            try (Stream<Path> stream = Files.list(dir);){
                stream.forEach(child -> {
                    try {
                        FileUtils.recursiveDelete(child);
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker] Encountered an exception while deleting a file. Path: {}", (Object)child.toAbsolutePath(), (Object)e);
                    }
                });
            }
        }
        if (!Files.isWritable(dir) && !dir.toFile().setWritable(true)) {
            LOGGER.error("[Skyblocker] Failed to make file writable. Path: {}", (Object)dir.toAbsolutePath());
        }
        Files.delete(dir);
    }

    public static String normalizePath(Path path) {
        return path.toString().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9_.-]", "");
    }
}

