/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.nekiplay.hypixelcry.utils.itemlist.Attribute;
import com.nekiplay.hypixelcry.utils.itemlist.Attributes;
import com.nekiplay.hypixelcry.utils.itemlist.ItemRepository;
import com.nekiplay.hypixelcry.utils.itemlist.PetInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_10712;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9274;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ItemUtils {
    public static final String ID = "id";

    @NotNull
    public static String getItemUuid(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564("uuid", "");
    }

    @NotNull
    public static String getItemId(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564(ID, "");
    }

    @NotNull
    public static Boolean isRecombobulated(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68083("rarity_upgrades", 0) > 0;
    }

    @NotNull
    public static Boolean isMuseumDonated(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68566("donated_museum", false);
    }

    @NotNull
    public static String getReforgeModifier(@NotNull class_9322 stack) {
        return ItemUtils.getCustomData(stack).method_68564("modifier", "");
    }

    @NotNull
    public static String getHeadTexture(@NotNull class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8575) || !stack.method_57826(class_9334.field_49617)) {
            return "";
        }
        class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
        if (profile == null) {
            return "";
        }
        return profile.method_73313().properties().get((Object)"textures").stream().filter(Objects::nonNull).map(Property::value).findFirst().orElse("");
    }

    @NotNull
    public static List<class_2561> getLore(class_1799 stack) {
        return ((class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2401();
    }

    @NotNull
    public static class_2561 getDisplayName(class_1799 stack) {
        if (stack == null || stack.method_65130() == null) {
            return class_2561.method_43473();
        }
        return stack.method_65130();
    }

    public static void setDisplayName(class_1799 stack, class_2561 name) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        stack.method_57379(class_9334.field_49631, (Object)name);
    }

    @NotNull
    public static Map<String, Integer> getHypixelEnchantments(class_1799 itemStack) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        class_2487 extraAttributes = ItemUtils.getCustomData((class_9322)itemStack);
        Optional enchantmentsOpt = extraAttributes.method_10562("enchantments");
        if (enchantmentsOpt.isEmpty()) {
            return result;
        }
        class_2487 enchantments = (class_2487)enchantmentsOpt.get();
        for (String key : enchantments.method_10541()) {
            result.put(key, enchantments.method_68083(key, 0));
        }
        return result;
    }

    @NotNull
    public static PropertyMap propertyMapWithTexture(String textureValue) {
        return (PropertyMap)class_5699.field_40725.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)("[{\"name\":\"textures\",\"value\":\"" + textureValue + "\"}]"))).getOrThrow();
    }

    @NotNull
    public static class_1799 createSkull(String textureBase64) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "a", ItemUtils.propertyMapWithTexture(textureBase64));
        return ItemUtils.createSkull(profile);
    }

    @NotNull
    public static class_1799 createSkull(GameProfile profile) {
        try {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
            stack.method_57379(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)profile));
            return stack;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class_1799 createItemStack(class_1792 item, String displayName, String model) {
        return ItemUtils.createItemStack(item, displayName, List.of(""), 1, 0, "");
    }

    public static class_1799 createItemStack(class_1792 item, String displayName, String[] loreArray, int amount, int damage, String model) {
        return ItemUtils.createItemStack(item, displayName, List.of(loreArray), amount, damage, model);
    }

    public static class_1799 setLore(class_1799 stack, List<String> lore) {
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore.stream().map(class_2561::method_30163).collect(Collectors.toList())));
        return stack;
    }

    public static class_1799 setCustomItemName(class_1799 stack, String name) {
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)name));
        return stack;
    }

    public static class_1799 createItemStack(class_1792 item, String displayName, List<String> lore, int amount, int damage, String model) {
        class_1799 stack = new class_1799((class_1935)item, amount);
        stack = ItemUtils.setCustomItemName(stack, displayName);
        stack = ItemUtils.setLore(stack, lore);
        class_10712 tooltip = class_10712.field_56318.method_67215(class_9334.field_49629, true).method_67215(class_9334.field_49636, true).method_67215(class_9334.field_49630, true);
        if (!model.isEmpty()) {
            class_9280 customModel = new class_9280(List.of(), List.of(), List.of(model), List.of());
            stack.method_57379(class_9334.field_49637, (Object)customModel);
        }
        if (displayName.isBlank() && lore.isEmpty()) {
            tooltip = new class_10712(true, tooltip.comp_3601());
        }
        stack.method_57379(class_9334.field_56400, (Object)tooltip);
        return stack;
    }

    @NotNull
    public static class_2487 getCustomData(@NotNull class_9322 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
    }

    public static List<class_1799> getArmor(class_1309 entity) {
        return class_9274.field_49224.method_66665().stream().filter(es -> es.method_5925() == class_1304.class_1305.field_6178).map(arg_0 -> ((class_1309)entity).method_6118(arg_0)).toList();
    }

    @NotNull
    public static PetInfo getPetInfo(class_1799 stack) {
        if (!ItemUtils.getItemId((class_9322)stack).equals("PET")) {
            return PetInfo.EMPTY;
        }
        String petInfo = ItemUtils.getCustomData((class_9322)stack).method_68564("petInfo", "");
        if (!petInfo.isEmpty()) {
            try {
                JsonElement jsonElement = JsonParser.parseString((String)petInfo);
                jsonElement.getAsJsonObject().addProperty("name", stack.method_7964().getString());
                return (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).setPartial((Object)PetInfo.EMPTY).getPartialOrThrow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PetInfo.EMPTY;
    }

    @NotNull
    public static String getNeuId(class_1799 stack) {
        if (stack == null) {
            return "";
        }
        String id = ItemUtils.getItemId((class_9322)stack);
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        return switch (id) {
            case "ENCHANTED_BOOK" -> {
                class_2487 enchantments = customData.method_68568("enchantments");
                String enchant = enchantments.method_10541().stream().findFirst().orElse("");
                yield enchant.toUpperCase(Locale.ENGLISH) + ";" + enchantments.method_68083(enchant, 0);
            }
            case "PET" -> {
                if (!customData.method_10545("petInfo")) {
                    yield id;
                }
                PetInfo petInfo = (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)customData.method_68564("petInfo", ""))).getOrThrow();
                yield petInfo.type() + ";" + petInfo.tierIndex();
            }
            case "RUNE" -> {
                class_2487 runes = customData.method_68568("runes");
                String rune = runes.method_10541().stream().findFirst().orElse("");
                yield rune.toUpperCase(Locale.ENGLISH) + "_RUNE;" + runes.method_68083(rune, 0);
            }
            case "POTION" -> "POTION_" + customData.method_68564("potion", "").toUpperCase(Locale.ENGLISH) + ";" + customData.method_68083("potion_level", 0);
            case "ATTRIBUTE_SHARD" -> {
                Attribute attribute = Attributes.getAttributeFromItemName((class_9322)stack);
                if (attribute == null) {
                    yield id;
                }
                yield ItemRepository.getBazaarStocks().getOrDefault(attribute.apiId(), id);
            }
            case "PARTY_HAT_CRAB", "BALLOON_HAT_2024", "BALLOON_HAT_2025" -> id + "_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH);
            case "PARTY_HAT_CRAB_ANIMATED" -> "PARTY_HAT_CRAB_" + customData.method_68564("party_hat_color", "").toUpperCase(Locale.ENGLISH) + "_ANIMATED";
            case "PARTY_HAT_SLOTH" -> id + "_" + customData.method_68564("party_hat_emoji", "").toUpperCase(Locale.ENGLISH);
            default -> id.replace(":", "-");
        };
    }
}

