/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.mojang.serialization.Codec;
import com.nekiplay.hypixelcry.utils.CodecUtils;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.class_3542;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public enum Location implements class_3542
{
    PRIVATE_ISLAND("dynamic"),
    GARDEN("garden", "Garden"),
    HUB("hub", "Hub"),
    THE_FARMING_ISLAND("farming_1", "The Farming Island"),
    THE_PARK("foraging_1", "The Park"),
    SPIDERS_DEN("combat_1", "Spider's Den"),
    BLAZING_FORTRESS("combat_2", "Blazing Fortress"),
    THE_END("combat_3", "The End"),
    CRIMSON_ISLE("crimson_isle", "Crimson Isle"),
    GOLD_MINE("mining_1", "Gold Mine"),
    DEEP_CAVERNS("mining_2", "Deep Caverns"),
    DWARVEN_MINES("mining_3", "Dwarven Mines"),
    BACKWATER_BAYOU("fishing_1", "Backwater Bayou"),
    DUNGEON_HUB("dungeon_hub", "Dungeon Hub"),
    WINTER_ISLAND("winter", "Jerry's Workshop"),
    THE_RIFT("rift", "The Rift"),
    DARK_AUCTION("dark_auction", "Dark Auction"),
    CRYSTAL_HOLLOWS("crystal_hollows", "Crystal Hollows"),
    DUNGEON("dungeon", "Dungeons"),
    KUUDRAS_HOLLOW("kuudra", "Kuudra's Hollow"),
    GLACITE_MINESHAFT("mineshaft", "Glacite Mineshaft"),
    GALATEA("foraging_2", "Galetea"),
    UNKNOWN("unknown");

    public static final Codec<Location> CODEC;
    public static final Codec<EnumSet<Location>> SET_CODEC;
    @NotNull
    private final String id;
    @NotNull
    private final String friendlyName;

    private Location(String id, String friendlyName) {
        this.id = id;
        this.friendlyName = friendlyName;
    }

    private Location(String id) {
        this.id = id;
        this.friendlyName = WordUtils.capitalizeFully((String)this.name().replace('_', ' '));
    }

    @NotNull
    public String id() {
        return this.id;
    }

    public String method_15434() {
        return this.id();
    }

    @NotNull
    public static Location from(String id) {
        return Arrays.stream(Location.values()).filter(loc -> loc.id.equals(id)).findFirst().orElse(UNKNOWN);
    }

    @NotNull
    public static Location fromFriendlyName(String friendlyName) {
        return Arrays.stream(Location.values()).filter(loc -> loc.friendlyName.equals(friendlyName)).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return this.friendlyName;
    }

    static {
        CODEC = class_3542.method_28140(Location::values);
        SET_CODEC = CodecUtils.enumSetCodec(CODEC, Location.class);
    }
}

