/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.utils.Constants;
import com.nekiplay.hypixelcry.utils.FileUtils;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import io.github.moulberry.repo.NEUConstants;
import io.github.moulberry.repo.NEURecipeCache;
import io.github.moulberry.repo.NEURepoFile;
import io.github.moulberry.repo.NEURepository;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.data.NEURecipe;
import io.github.moulberry.repo.util.NEUId;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.lang3.function.Consumers;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.errors.TransportException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NEURepoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NEURepoManager.class);
    private static final String REMOTE_REPO_URL = "https://github.com/NotEnoughUpdates/NotEnoughUpdates-REPO.git";
    private static final Path LOCAL_REPO_DIR = HypixelCry.CONFIG_DIR.resolve("item-repo");
    private static CompletableFuture<Void> REPO_LOADING = NEURepoManager.loadRepository().thenAccept(Consumers.nop());
    private static final NEURepository NEU_REPO = NEURepository.of((Path)LOCAL_REPO_DIR);
    private static final NEURecipeCache RECIPE_CACHE = NEURecipeCache.forRepo((NEURepository)NEU_REPO);
    private static final List<Runnable> afterLoadTasks = new ArrayList<Runnable>();
    private static Multimap<String, NEUItem> nameToNEUItem = HashMultimap.create();

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"hypixelcry").then(ClientCommandManager.literal((String)"updateRepository").executes(context -> {
            NEURepoManager.deleteAndDownloadRepository((class_1657)((FabricClientCommandSource)context.getSource()).getPlayer());
            return 1;
        }))));
        NEURepoManager.runAsyncAfterLoad(NEURepoManager::loadNameToNEUItemMap);
    }

    public static boolean isLoading() {
        return REPO_LOADING != null && !REPO_LOADING.isDone();
    }

    private static CompletableFuture<Boolean> loadRepository() {
        return CompletableFuture.supplyAsync(() -> {
            boolean success;
            block14: {
                success = true;
                try {
                    if (Files.isDirectory(LOCAL_REPO_DIR, new LinkOption[0])) {
                        try (Git localRepo = Git.open((File)LOCAL_REPO_DIR.toFile());){
                            PullResult result = localRepo.pull().setRebase(false).setFastForward(MergeCommand.FastForwardMode.FF_ONLY).call();
                            if (result.isSuccessful()) {
                                LOGGER.info("[Skyblocker NEU Repo] NEU Repository updated with merge status: {}", (Object)result.getMergeResult().getMergeStatus());
                            } else {
                                LOGGER.error("[Skyblocker NEU Repo] Update failed with merge status: {}. Downloading new repository", (Object)result.getMergeResult().getMergeStatus());
                                Scheduler.INSTANCE.schedule(() -> NEURepoManager.deleteAndDownloadRepositoryInternal((class_1657)class_310.method_1551().field_1724), 1);
                                success = false;
                            }
                            break block14;
                        }
                    }
                    Git.cloneRepository().setURI(REMOTE_REPO_URL).setDirectory(LOCAL_REPO_DIR.toFile()).setBranchesToClone(List.of("refs/heads/master")).setBranch("refs/heads/master").setDepth(1).call().close();
                    LOGGER.info("[Skyblocker NEU Repo] NEU Repository Downloaded");
                }
                catch (TransportException e) {
                    LOGGER.error("[Skyblocker NEU Repo] Transport operation failed. Most likely unable to connect to the remote NEU repo on github", (Throwable)e);
                    success = false;
                }
                catch (Exception e) {
                    LOGGER.error("[Skyblocker NEU Repo] Encountered unknown exception while downloading NEU Repository", (Throwable)e);
                    success = false;
                }
            }
            try {
                NEU_REPO.reload();
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker NEU Repo] Encountered unknown exception while loading NEU Repository", (Throwable)e);
                success = false;
            }
            return success;
        }).thenApplyAsync(success -> {
            CompletableFuture.allOf((CompletableFuture[])afterLoadTasks.stream().map(CompletableFuture::runAsync).toArray(CompletableFuture[]::new)).exceptionally(e -> {
                LOGGER.error("[Skyblocker NEU Repo] Encountered unknown exception while running after load tasks", e);
                return null;
            });
            return success;
        });
    }

    private static void loadNameToNEUItemMap() {
        nameToNEUItem = (Multimap)NEU_REPO.getItems().getItems().values().stream().collect(Multimaps.toMultimap(item -> class_124.method_539((String)item.getDisplayName()), Function.identity(), HashMultimap::create));
    }

    private static void deleteAndDownloadRepository(class_1657 player) {
        if (NEURepoManager.isLoading()) {
            NEURepoManager.sendMessage(player, (class_2561)class_2561.method_43471((String)"skyblocker.updateRepository.loading"));
            return;
        }
        NEURepoManager.deleteAndDownloadRepositoryInternal(player);
    }

    private static void deleteAndDownloadRepositoryInternal(class_1657 player) {
        Function<Runnable, CompletableFuture> runner = NEURepoManager.isLoading() ? REPO_LOADING::thenRunAsync : CompletableFuture::runAsync;
        REPO_LOADING = runner.apply(() -> {
            NEURepoManager.sendMessage(player, (class_2561)class_2561.method_43471((String)"skyblocker.updateRepository.start"));
            try {
                FileUtils.recursiveDelete(LOCAL_REPO_DIR);
                NEURepoManager.sendMessage(player, (class_2561)class_2561.method_43471((String)"skyblocker.updateRepository.deleted"));
                NEURepoManager.sendMessage(player, (class_2561)class_2561.method_43471((String)(NEURepoManager.loadRepository().join() != false ? "skyblocker.updateRepository.success" : "skyblocker.updateRepository.failed")));
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker NEU Repo] Encountered unknown exception while deleting the NEU repo", (Throwable)e);
                NEURepoManager.sendMessage(player, (class_2561)class_2561.method_43471((String)"skyblocker.updateRepository.error"));
            }
        });
    }

    private static void sendMessage(class_1657 player, class_2561 text2) {
        if (player != null) {
            player.method_7353((class_2561)Constants.PREFIX.get().method_10852(text2), false);
        } else {
            LOGGER.info("[Skyblocker NEU Repo] {}", (Object)text2.getString());
        }
    }

    public static CompletableFuture<Void> runAsyncAfterLoad(Runnable runnable) {
        return ((CompletableFuture)((CompletableFuture)REPO_LOADING.thenRunAsync(runnable)).exceptionally(e -> {
            LOGGER.error("[Skyblocker NEU Repo] Encountered unknown exception while running after load task", e);
            return null;
        })).thenRun(() -> afterLoadTasks.add(runnable));
    }

    public static void forEachItem(Consumer<NEUItem> consumer) {
        NEU_REPO.getItems().getItems().values().forEach(consumer);
    }

    @Nullable
    public static NEUItem getItemByNeuId(String neuId) {
        return NEU_REPO.getItems().getItemBySkyblockId(neuId);
    }

    public static Collection<NEUItem> getItemByName(String displayName) {
        return nameToNEUItem.get((Object)displayName);
    }

    public static NEUConstants getConstants() {
        return NEU_REPO.getConstants();
    }

    @Nullable
    public static NEURepoFile file(@NotNull String path) {
        return NEU_REPO.file(path);
    }

    public static Map<@NEUId String, Set<NEURecipe>> getRecipes() {
        return RECIPE_CACHE.getRecipes();
    }

    public static Map<@NEUId String, Set<NEURecipe>> getUsages() {
        return RECIPE_CACHE.getUsages();
    }
}

