/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.datafixer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_4614;

public class LegacyStringNbtReader {
    public static final SimpleCommandExceptionType TRAILING = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.nbt.trailing"));
    public static final SimpleCommandExceptionType EXPECTED_KEY = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType EXPECTED_VALUE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType LIST_MIXED = new Dynamic2CommandExceptionType((receivedType, expectedType) -> class_2561.method_54159((String)"argument.nbt.list.mixed", (Object[])new Object[]{receivedType, expectedType}));
    public static final Dynamic2CommandExceptionType ARRAY_MIXED = new Dynamic2CommandExceptionType((receivedType, expectedType) -> class_2561.method_54159((String)"argument.nbt.array.mixed", (Object[])new Object[]{receivedType, expectedType}));
    public static final DynamicCommandExceptionType ARRAY_INVALID = new DynamicCommandExceptionType(type2 -> class_2561.method_54159((String)"argument.nbt.array.invalid", (Object[])new Object[]{type2}));
    private static final Pattern DOUBLE_PATTERN_IMPLICIT = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    public final StringReader reader;

    public LegacyStringNbtReader(StringReader reader) {
        this.reader = reader;
    }

    public static class_2487 parse(String string) throws CommandSyntaxException {
        return new LegacyStringNbtReader(new StringReader(string)).readCompound();
    }

    @VisibleForTesting
    protected class_2487 readCompound() throws CommandSyntaxException {
        class_2487 nbtCompound = this.parseCompound();
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw TRAILING.createWithContext((ImmutableStringReader)this.reader);
        }
        return nbtCompound;
    }

    protected String readString() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.reader.readString();
    }

    protected class_2520 parseElementPrimitive() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        int i = this.reader.getCursor();
        if (StringReader.isQuotedStringStart((char)this.reader.peek())) {
            return class_2519.method_23256((String)this.reader.readQuotedString());
        }
        String string = this.reader.readUnquotedString();
        if (string.isEmpty()) {
            this.reader.setCursor(i);
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.parsePrimitive(string);
    }

    private class_2520 parsePrimitive(String input) {
        try {
            if (FLOAT_PATTERN.matcher(input).matches()) {
                return class_2494.method_23244((float)Float.parseFloat(input.substring(0, input.length() - 1)));
            }
            if (BYTE_PATTERN.matcher(input).matches()) {
                return class_2481.method_23233((byte)Byte.parseByte(input.substring(0, input.length() - 1)));
            }
            if (LONG_PATTERN.matcher(input).matches()) {
                return class_2503.method_23251((long)Long.parseLong(input.substring(0, input.length() - 1)));
            }
            if (SHORT_PATTERN.matcher(input).matches()) {
                return class_2516.method_23254((short)Short.parseShort(input.substring(0, input.length() - 1)));
            }
            if (INT_PATTERN.matcher(input).matches()) {
                return class_2497.method_23247((int)Integer.parseInt(input));
            }
            if (DOUBLE_PATTERN.matcher(input).matches()) {
                return class_2489.method_23241((double)Double.parseDouble(input.substring(0, input.length() - 1)));
            }
            if (DOUBLE_PATTERN_IMPLICIT.matcher(input).matches()) {
                return class_2489.method_23241((double)Double.parseDouble(input));
            }
            if ("true".equalsIgnoreCase(input)) {
                return class_2481.field_21027;
            }
            if ("false".equalsIgnoreCase(input)) {
                return class_2481.field_21026;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return class_2519.method_23256((String)input);
    }

    public class_2520 parseElement() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        char c = this.reader.peek();
        if (c == '{') {
            return this.parseCompound();
        }
        return c == '[' ? this.parseArray() : this.parseElementPrimitive();
    }

    protected class_2520 parseArray() throws CommandSyntaxException {
        return this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';' ? this.parseElementPrimitiveArray() : this.parseList();
    }

    public class_2487 parseCompound() throws CommandSyntaxException {
        this.expect('{');
        class_2487 nbtCompound = new class_2487();
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != '}') {
            int i = this.reader.getCursor();
            String string = this.readString();
            if (string.isEmpty()) {
                this.reader.setCursor(i);
                throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
            }
            this.expect(':');
            nbtCompound.method_10566(string, this.parseElement());
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect('}');
        return nbtCompound;
    }

    protected class_2520 parseList() throws CommandSyntaxException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        class_2499 nbtList = new class_2499();
        class_4614 listType = null;
        while (this.reader.peek() != ']') {
            int originalPos = this.reader.getCursor();
            while (Character.isDigit(this.reader.peek())) {
                this.reader.skip();
            }
            if (this.reader.peek() == ':') {
                this.reader.skip();
                this.reader.skipWhitespace();
            } else {
                this.reader.setCursor(originalPos);
            }
            int cursorPosition = this.reader.getCursor();
            class_2520 element = this.parseElement();
            class_4614 elementType = element.method_23258();
            if (listType == null) {
                listType = elementType;
            } else if (elementType != listType) {
                this.reader.setCursor(cursorPosition);
                throw LIST_MIXED.createWithContext((ImmutableStringReader)this.reader, (Object)elementType.method_23261(), (Object)listType.method_23261());
            }
            nbtList.add((Object)element);
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return nbtList;
    }

    private class_2520 parseElementPrimitiveArray() throws CommandSyntaxException {
        this.expect('[');
        int i = this.reader.getCursor();
        char c = this.reader.read();
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        if (c == 'B') {
            return new class_2479(LegacyStringNbtReader.mapToByteArray(this.readArray(class_2479.field_21024, class_2481.field_21025)));
        }
        if (c == 'L') {
            return new class_2501(this.readArray(class_2501.field_21040, class_2503.field_21041).stream().mapToLong(Number::longValue).toArray());
        }
        if (c == 'I') {
            return new class_2495(this.readArray(class_2495.field_21036, class_2497.field_21037).stream().mapToInt(Number::intValue).toArray());
        }
        this.reader.setCursor(i);
        throw ARRAY_INVALID.createWithContext((ImmutableStringReader)this.reader, (Object)String.valueOf(c));
    }

    private static byte[] mapToByteArray(List<Number> numbers) {
        byte[] bytes = new byte[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            bytes[i] = numbers.get(i).byteValue();
        }
        return bytes;
    }

    private <T extends Number> List<T> readArray(class_4614<?> arrayTypeReader, class_4614<?> typeReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        while (this.reader.peek() != ']') {
            int i = this.reader.getCursor();
            class_2520 nbtElement = this.parseElement();
            class_4614 nbtType = nbtElement.method_23258();
            if (nbtType != typeReader) {
                this.reader.setCursor(i);
                throw ARRAY_MIXED.createWithContext((ImmutableStringReader)this.reader, (Object)nbtType.method_23261(), (Object)arrayTypeReader.method_23261());
            }
            if (typeReader == class_2481.field_21025) {
                list.add(((class_2514)nbtElement).method_10698());
            } else if (typeReader == class_2503.field_21041) {
                list.add(((class_2514)nbtElement).method_10699());
            } else {
                list.add(((class_2514)nbtElement).method_10701());
            }
            if (!this.readComma()) break;
            if (this.reader.canRead()) continue;
            throw EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return list;
    }

    protected boolean readComma() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    protected void expect(char c) throws CommandSyntaxException {
        this.reader.skipWhitespace();
        this.reader.expect(c);
    }
}

