/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.helper;

import com.nekiplay.hypixelcry.utils.helper.Angle;
import com.nekiplay.hypixelcry.utils.helper.Target;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;

public class RotationConfiguration {
    private Optional<Angle> from = Optional.empty();
    private Optional<Angle> to = Optional.empty();
    private Optional<Target> target;
    private Optional<Runnable> callback;
    private long time;
    private boolean easeBackToClientSide = false;
    private boolean followTarget = false;
    private RotationType rotationType = RotationType.CLIENT;
    private Ease easeFunction = Ease.values()[new Random().nextInt(Ease.values().length - 1)];
    private boolean randomness = false;
    private Optional<Integer> priority = Optional.empty();

    public RotationConfiguration(Angle from, Angle to, long time, RotationType rotationType, Runnable callback) {
        this.from = Optional.of(from);
        this.to = Optional.ofNullable(to);
        this.target = Optional.of(new Target(to));
        this.time = time;
        this.rotationType = rotationType;
        this.callback = Optional.ofNullable(callback);
    }

    public RotationConfiguration(Angle from, Target target, long time, RotationType rotationType, Runnable callback) {
        this.from = Optional.of(from);
        this.time = time;
        this.target = Optional.ofNullable(target);
        this.rotationType = rotationType;
        this.callback = Optional.ofNullable(callback);
    }

    public RotationConfiguration(Angle to, long time, Runnable callback) {
        this.to = Optional.ofNullable(to);
        this.target = Optional.of(new Target(to));
        this.time = time;
        this.callback = Optional.ofNullable(callback);
    }

    public RotationConfiguration(Angle to, long time, RotationType rotationType, Runnable callback) {
        this.to = Optional.ofNullable(to);
        this.target = Optional.of(new Target(to));
        this.time = time;
        this.rotationType = rotationType;
        this.callback = Optional.ofNullable(callback);
    }

    public RotationConfiguration(Target target, long time, Runnable callback) {
        this.time = time;
        this.target = Optional.ofNullable(target);
        this.callback = Optional.ofNullable(callback);
    }

    public RotationConfiguration(Target target, long time, RotationType rotationType, Runnable callback) {
        this.time = time;
        this.target = Optional.ofNullable(target);
        this.rotationType = rotationType;
        this.callback = Optional.ofNullable(callback);
    }

    public RotationConfiguration setTarget(Target target) {
        this.target = Optional.of(target);
        return this;
    }

    public RotationConfiguration easeFunction(Ease ease) {
        this.easeFunction = ease;
        return this;
    }

    public Ease easeFunction() {
        return this.easeFunction;
    }

    public Optional<Angle> getFrom() {
        return this.from;
    }

    public RotationConfiguration setFrom(Angle from) {
        this.from = Optional.ofNullable(from);
        return this;
    }

    public Optional<Angle> getTo() {
        return this.to;
    }

    public RotationConfiguration setTo(Angle to) {
        this.to = Optional.ofNullable(to);
        return this;
    }

    public Optional<Target> getTarget() {
        return this.target;
    }

    public Optional<Runnable> getCallback() {
        return this.callback;
    }

    public RotationConfiguration setCallback(Runnable callback) {
        this.callback = Optional.ofNullable(callback);
        return this;
    }

    public long getTime() {
        return this.time;
    }

    public RotationConfiguration setTime(long time) {
        this.time = time;
        return this;
    }

    public boolean isEaseBackToClientSide() {
        return this.easeBackToClientSide;
    }

    public RotationConfiguration setEaseBackToClientSide(boolean easeBackToClientSide) {
        this.easeBackToClientSide = easeBackToClientSide;
        return this;
    }

    public boolean isFollowTarget() {
        return this.followTarget;
    }

    public RotationConfiguration setFollowTarget(boolean followTarget) {
        this.followTarget = followTarget;
        return this;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public RotationConfiguration setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
        return this;
    }

    public Ease getEaseFunction() {
        return this.easeFunction;
    }

    public RotationConfiguration setEaseFunction(Ease easeFunction) {
        this.easeFunction = easeFunction;
        return this;
    }

    public boolean isRandomness() {
        return this.randomness;
    }

    public RotationConfiguration setRandomness(boolean randomness) {
        this.randomness = randomness;
        return this;
    }

    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public RotationConfiguration setPriority(int priority) {
        this.priority = Optional.of(priority);
        return this;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum RotationType {
        SERVER,
        CLIENT;

    }

    public static enum Ease {
        EASE_OUT_SINE(x -> Float.valueOf((float)Math.sin((double)x.floatValue() * Math.PI / 2.0))),
        EASE_IN_OUT_SINE(x -> Float.valueOf((float)(-(Math.cos((double)x.floatValue() * Math.PI) - 1.0) / 2.0))),
        EASE_OUT_QUAD(x -> Float.valueOf(1.0f - (1.0f - x.floatValue()) * (1.0f - x.floatValue()))),
        EASE_OUT_CUBIC(x -> Float.valueOf(1.0f - (1.0f - x.floatValue()) * (1.0f - x.floatValue()) * (1.0f - x.floatValue()))),
        EASE_OUT_CIRC(x -> Float.valueOf((float)Math.sqrt(1.0f - (x.floatValue() - 1.0f) * (x.floatValue() - 1.0f))));

        private final Function<Float, Float> easingFunction;

        private Ease(Function<Float, Float> easingFunction) {
            this.easingFunction = easingFunction;
        }

        public float invoke(float x) {
            return this.easingFunction.apply(Float.valueOf(x)).floatValue();
        }
    }
}

