/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JavaConstructor;
import org.luaj.vm2.lib.jse.JavaInstance;
import org.luaj.vm2.lib.jse.JavaMethod;

class JavaClass
extends JavaInstance
implements CoerceJavaToLua.Coercion {
    static final Map classes = Collections.synchronizedMap(new HashMap());
    static final LuaValue NEW = JavaClass.valueOf("new");
    Map fields;
    Map methods;
    Map innerclasses;

    static JavaClass forClass(Class clazz) {
        JavaClass javaClass = (JavaClass)classes.get(clazz);
        if (javaClass == null) {
            javaClass = new JavaClass(clazz);
            classes.put(clazz, javaClass);
        }
        return javaClass;
    }

    JavaClass(Class clazz) {
        super(clazz);
        this.jclass = this;
    }

    public LuaValue coerce(Object object) {
        return this;
    }

    Field getField(LuaValue luaValue) {
        if (this.fields == null) {
            HashMap<LuaString, Field> hashMap = new HashMap<LuaString, Field>();
            Field[] fieldArray = ((Class)this.m_instance).getFields();
            for (int j = 0; j < fieldArray.length; ++j) {
                Field field = fieldArray[j];
                if (!Modifier.isPublic(field.getModifiers())) continue;
                hashMap.put(LuaValue.valueOf(field.getName()), field);
                try {
                    if (field.isAccessible()) continue;
                    field.setAccessible(true);
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.fields = hashMap;
        }
        return (Field)this.fields.get(luaValue);
    }

    LuaValue getMethod(LuaValue luaValue) {
        if (this.methods == null) {
            Object object;
            Constructor<?>[] constructorArray;
            HashMap<Object, ArrayList<JavaMethod>> hashMap = new HashMap<Object, ArrayList<JavaMethod>>();
            Method[] methodArray = ((Class)this.m_instance).getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                constructorArray = methodArray[j];
                if (!Modifier.isPublic(constructorArray.getModifiers())) continue;
                object = constructorArray.getName();
                ArrayList<JavaMethod> arrayList = (ArrayList<JavaMethod>)hashMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<JavaMethod>();
                    hashMap.put(object, arrayList);
                }
                arrayList.add(JavaMethod.forMethod(constructorArray));
            }
            HashMap<LuaValue, Object> hashMap2 = new HashMap<LuaValue, Object>();
            constructorArray = ((Class)this.m_instance).getConstructors();
            object = new ArrayList();
            for (int j = 0; j < constructorArray.length; ++j) {
                if (!Modifier.isPublic(constructorArray[j].getModifiers())) continue;
                object.add(JavaConstructor.forConstructor(constructorArray[j]));
            }
            switch (object.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    hashMap2.put(NEW, object.get(0));
                    break;
                }
                default: {
                    hashMap2.put(NEW, JavaConstructor.forConstructors(object.toArray(new JavaConstructor[object.size()])));
                }
            }
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                hashMap2.put(LuaValue.valueOf(string), list.size() == 1 ? list.get(0) : JavaMethod.forMethods(list.toArray(new JavaMethod[list.size()])));
            }
            this.methods = hashMap2;
        }
        return (LuaValue)this.methods.get(luaValue);
    }

    Class getInnerClass(LuaValue luaValue) {
        if (this.innerclasses == null) {
            HashMap hashMap = new HashMap();
            Class<?>[] classArray = ((Class)this.m_instance).getClasses();
            for (int j = 0; j < classArray.length; ++j) {
                Class<?> clazz = classArray[j];
                String string = clazz.getName();
                String string2 = string.substring(Math.max(string.lastIndexOf(36), string.lastIndexOf(46)) + 1);
                hashMap.put(LuaValue.valueOf(string2), clazz);
            }
            this.innerclasses = hashMap;
        }
        return (Class)this.innerclasses.get(luaValue);
    }

    public LuaValue getConstructor() {
        return this.getMethod(NEW);
    }
}

