/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.config.enums.ESPFeatures;
import com.nekiplay.hypixelcry.utils.SpecialColor;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2818;

public class ChestESP {
    private static final List<class_2338> chestLocations = new ArrayList<class_2338>();

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ChestESP::render);
        Scheduler.INSTANCE.scheduleCyclic(ChestESP::onTick, 2);
    }

    public static void onTick() {
        chestLocations.clear();
        if (HypixelCry.mc.field_1687 == null || HypixelCry.mc.field_1724 == null) {
            return;
        }
        double maxRangeSq = Math.pow(HypixelCry.config.esp.chestEsp.maxRange, 2.0);
        int playerChunkX = HypixelCry.mc.field_1724.method_31476().field_9181;
        int playerChunkZ = HypixelCry.mc.field_1724.method_31476().field_9180;
        int renderDistance = (Integer)HypixelCry.mc.field_1690.method_42503().method_41753();
        for (int x = playerChunkX - renderDistance; x <= playerChunkX + renderDistance; ++x) {
            for (int z = playerChunkZ - renderDistance; z <= playerChunkZ + renderDistance; ++z) {
                class_2818 chunk = HypixelCry.mc.field_1687.method_8497(x, z);
                if (chunk == null) continue;
                for (class_2586 blockEntity : chunk.method_12214().values()) {
                    if (!(blockEntity instanceof class_2595)) continue;
                    class_2338 pos = blockEntity.method_11016();
                    if (HypixelCry.config.esp.chestEsp.maxRange != 0 && !(HypixelCry.mc.field_1724.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= maxRangeSq)) continue;
                    chestLocations.add(pos);
                }
            }
        }
    }

    public static void render(WorldRenderContext context) {
        if (!HypixelCry.config.esp.chestEsp.enabled || chestLocations.isEmpty()) {
            return;
        }
        float[] colorComponents = SpecialColor.toSpecialColorFloatArray(HypixelCry.config.esp.chestEsp.colour);
        float alpha = colorComponents[3];
        float lineWidth = 1.5f;
        boolean throughWalls = true;
        for (class_2338 pos : chestLocations) {
            if (HypixelCry.config.esp.chestEsp.features.contains((Object)ESPFeatures.Box)) {
                RenderHelper.renderFilled(context, pos, colorComponents, alpha, throughWalls);
                RenderHelper.renderOutline(context, pos, colorComponents, lineWidth, throughWalls);
            }
            if (HypixelCry.config.esp.chestEsp.features.contains((Object)ESPFeatures.Text)) {
                RenderHelper.renderText(context, class_2561.method_30163((String)"Chest").method_30937(), pos.method_46558().method_1031(0.0, 1.0, 0.0), SpecialColor.toSpecialColorIntNoAlpha(HypixelCry.config.esp.chestEsp.colour), 1.0f, 0.5f, throughWalls);
            }
            if (!HypixelCry.config.esp.chestEsp.features.contains((Object)ESPFeatures.Tracer)) continue;
            RenderHelper.renderLineFromCursor(context, pos.method_46558(), colorComponents, 1.0f, lineWidth);
        }
    }
}

