/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.mining.glacitemineshafts;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.config.enums.ESPFeatures;
import com.nekiplay.hypixelcry.events.SkyblockEvents;
import com.nekiplay.hypixelcry.features.esp.pathfinder.PathFinderWorker;
import com.nekiplay.hypixelcry.utils.ItemUtils;
import com.nekiplay.hypixelcry.utils.Location;
import com.nekiplay.hypixelcry.utils.SpecialColor;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_9322;
import org.apache.commons.lang3.EnumUtils;

public class FrozenCourpes {
    private static boolean isLocationCorrect = false;
    private static final Pattern CORPSE_FOUND_PATTERN = Pattern.compile("([A-Z]+) CORPSE LOOT!");
    private static final Map<CorpseType, List<Corpse>> corpsesByType = new EnumMap<CorpseType, List<Corpse>>(CorpseType.class);

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((ignored, ignored2, ignored3) -> {
            isLocationCorrect = false;
            FrozenCourpes.clearPathFinder();
            corpsesByType.clear();
        });
        SkyblockEvents.LOCATION_CHANGE.register(FrozenCourpes::handleLocationChange);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(FrozenCourpes::render);
        ClientReceiveMessageEvents.GAME.register(FrozenCourpes::onChatMessage);
        Scheduler.INSTANCE.scheduleCyclic(FrozenCourpes::onTick, 2);
        HypixelCry.config.esp.glaciteMineshafts.frozenCourpes.enabledPathFinder.whenChanged((old, current) -> {
            if (!current.booleanValue()) {
                FrozenCourpes.clearPathFinder();
                corpsesByType.clear();
            }
        });
    }

    private static void clearPathFinder() {
        for (List<Corpse> corpses : corpsesByType.values()) {
            for (Corpse corpse : corpses) {
                if (!PathFinderWorker.hasPath(Integer.toString(corpse.entity.method_5628()))) continue;
                PathFinderWorker.removePath(Integer.toString(corpse.entity.method_5628()));
            }
        }
    }

    private static void handleLocationChange(Location location) {
        boolean bl = isLocationCorrect = location == Location.GLACITE_MINESHAFT;
        if (!isLocationCorrect) {
            FrozenCourpes.clearPathFinder();
            corpsesByType.clear();
        }
    }

    private static void onChatMessage(class_2561 text, boolean b) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        String string = text.getString();
        if (string.contains(class_310.method_1551().method_1548().method_1676())) {
            return;
        }
        Matcher matcherCorpse = CORPSE_FOUND_PATTERN.matcher(string);
        if (!matcherCorpse.find()) {
            return;
        }
        HypixelCry.LOGGER.debug(HypixelCry.PREFIX + "Triggered code for onChatMessage");
        HypixelCry.LOGGER.debug(HypixelCry.PREFIX + "State of corpsesByType: {}", corpsesByType);
        String corpseTypeString = matcherCorpse.group(1).toUpperCase(Locale.ENGLISH);
        CorpseType corpseType = (CorpseType)EnumUtils.getEnum(CorpseType.class, (String)corpseTypeString, (Enum)CorpseType.UNKNOWN);
        List<Corpse> corpses = corpsesByType.get((Object)corpseType);
        if (corpses == null) {
            HypixelCry.LOGGER.warn(HypixelCry.PREFIX + "Couldn't get corpses! corpse type string: {}, parsed corpse type: {}", (Object)corpseTypeString, (Object)corpseType);
            return;
        }
        corpses.stream().min(Comparator.comparingDouble(corpse -> corpse.entity.method_5858((class_1297)class_310.method_1551().field_1724))).ifPresentOrElse(corpse -> {
            if (PathFinderWorker.hasPath(Integer.toString(corpse.entity.method_5628()))) {
                PathFinderWorker.removePath(Integer.toString(corpse.entity.method_5628()));
            }
            HypixelCry.LOGGER.info(HypixelCry.PREFIX + "Found corpse, marking as found! {}: {}", (Object)corpse.entity.method_5864(), (Object)corpse.entity.method_24515().method_23854());
            corpse.found = true;
        }, () -> HypixelCry.LOGGER.warn(HypixelCry.PREFIX + "Couldn't find the closest corpse despite triggering onChatMessage!"));
    }

    public static void checkIfCorpse(class_1297 entity) {
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            FrozenCourpes.checkIfCorpse(armorStand);
        }
    }

    public static void checkIfCorpse(class_1531 armorStand) {
        if (!isLocationCorrect) {
            return;
        }
        if (armorStand.method_16914() || armorStand.method_5767() || armorStand.method_61489()) {
            return;
        }
        FrozenCourpes.handleArmorStand(armorStand);
    }

    private static void handleArmorStand(class_1531 armorStand) {
        String helmetItemId = ItemUtils.getItemId((class_9322)armorStand.method_6118(class_1304.field_6169));
        CorpseType corpseType = CorpseType.fromHelmetItemId(helmetItemId);
        if (corpseType == CorpseType.UNKNOWN) {
            return;
        }
        HypixelCry.LOGGER.debug(HypixelCry.PREFIX + "Triggered code for handleArmorStand and matched with ITEM_IDS");
        List corpses = corpsesByType.computeIfAbsent(corpseType, k -> new ArrayList());
        if (corpses.stream().noneMatch(c -> c.entity.method_24515().equals((Object)armorStand.method_24515()))) {
            Corpse newCorpse = new Corpse(armorStand, armorStand.method_24515().method_10084(), corpseType);
            corpses.add(newCorpse);
            if (((Boolean)HypixelCry.config.esp.glaciteMineshafts.frozenCourpes.enabledPathFinder.get()).booleanValue()) {
                float[] colorComponents = SpecialColor.toSpecialColorFloatArray(newCorpse.corpseType.color);
                PathFinderWorker.addOrUpdatePath(Integer.toString(armorStand.method_5628()), armorStand.method_24515().method_10084(), colorComponents, newCorpse.corpseType.name());
            }
        }
    }

    private static void render(WorldRenderContext worldRenderContext) {
        if (!isLocationCorrect || !HypixelCry.config.esp.glaciteMineshafts.frozenCourpes.enabled) {
            return;
        }
        float lineWidth = 1.5f;
        boolean throughWalls = true;
        for (List<Corpse> corpses : corpsesByType.values()) {
            for (Corpse corpse : corpses) {
                float[] colorComponents = SpecialColor.toSpecialColorFloatArray(corpse.corpseType.color);
                float alpha = colorComponents[3];
                int colorComponentsNoAlpha = SpecialColor.toSpecialColorIntNoAlpha(corpse.corpseType.color);
                if (corpse.found) continue;
                if (HypixelCry.config.esp.glaciteMineshafts.frozenCourpes.features.contains((Object)ESPFeatures.Box)) {
                    RenderHelper.renderFilled(worldRenderContext, corpse.blockPos, colorComponents, alpha, throughWalls);
                    RenderHelper.renderOutline(worldRenderContext, corpse.blockPos, colorComponents, lineWidth, throughWalls);
                }
                if (!HypixelCry.config.esp.glaciteMineshafts.frozenCourpes.features.contains((Object)ESPFeatures.Text)) continue;
                RenderHelper.renderText(worldRenderContext, class_2561.method_30163((String)corpse.corpseType.name()).method_30937(), corpse.blockPos.method_46558().method_1031(0.0, 1.9, 0.0), colorComponentsNoAlpha, 1.0f, 0.5f, throughWalls);
            }
        }
    }

    private static void onTick() {
        if (HypixelCry.mc.field_1687 != null && HypixelCry.mc.field_1724 != null) {
            HypixelCry.mc.field_1687.method_18112().forEach(FrozenCourpes::checkIfCorpse);
        }
    }

    static class Corpse {
        private final class_1531 entity;
        private final class_2338 blockPos;
        public boolean found = false;
        private final CorpseType corpseType;

        Corpse(class_1531 entity, class_2338 blockPos, CorpseType corpseType) {
            this.entity = entity;
            this.blockPos = blockPos;
            this.corpseType = corpseType;
        }
    }

    public static enum CorpseType implements class_3542
    {
        LAPIS("LAPIS_ARMOR_HELMET", null, "0:127:0:0:255"),
        UMBER("ARMOR_OF_YOG_HELMET", "UMBER_KEY", "0:127:255:255:0"),
        TUNGSTEN("MINERAL_HELMET", "TUNGSTEN_KEY", "0:127:127:127:127"),
        VANGUARD("VANGUARD_HELMET", "SKELETON_KEY", "0:127:0:255:255"),
        UNKNOWN("UNKNOWN", null, "0:127:255:0:0");

        public final String helmetItemId;
        public final String keyItemId;
        public final String color;

        private CorpseType(String helmetItemId, String keyItemId, String color) {
            this.helmetItemId = helmetItemId;
            this.keyItemId = keyItemId;
            this.color = color;
        }

        static CorpseType fromHelmetItemId(String helmetItemId) {
            for (CorpseType value : CorpseType.values()) {
                if (!value.helmetItemId.equals(helmetItemId)) continue;
                return value;
            }
            return UNKNOWN;
        }

        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

