/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry;

import com.nekiplay.hypixelcry.commands.EntityInfoCommand;
import com.nekiplay.hypixelcry.commands.PathFinderCommand;
import com.nekiplay.hypixelcry.features.commands.impl.LuaCommand;
import com.nekiplay.hypixelcry.features.esp.pathfinder.PathFinderWorker;
import com.nekiplay.hypixelcry.features.lua.LuaManager;
import com.nekiplay.hypixelcry.features.modules.ModuleManager;
import com.nekiplay.hypixelcry.utils.NEURepoManager;
import com.nekiplay.hypixelcry.utils.Utils;
import com.nekiplay.hypixelcry.utils.itemlist.Attributes;
import com.nekiplay.hypixelcry.utils.itemlist.ItemRepository;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.render.SkyblockerRenderPipelines;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import com.nekiplay.hypixelcry.utils.trackers.ColdTracker;
import com.nekiplay.hypixelcry.utils.trackers.StatusBarTracker;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypixelCry
implements ClientModInitializer {
    public static final String MOD_ID = "hypixelcry";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hypixelcry");
    public static LuaManager LUA_MANAGER;
    public static final Path CONFIG_DIR;
    public static final String PREFIX;
    public static final String LOG_PREFIX = "[Hypixel Cry] ";
    public static File neuDir;
    public static class_310 mc;
    private static HypixelCry INSTANCE;
    private final ArrayList<String> startUpScriptNames = new ArrayList<String>(){
        {
            this.add("autoload.lua");
            this.add("startup.lua");
            this.add("init.lua");
        }
    };

    @Deprecated
    public HypixelCry() {
        INSTANCE = this;
    }

    public static HypixelCry getInstance() {
        return INSTANCE;
    }

    public static void saveConfig() {
        for (String script : LUA_MANAGER.getLoadedScripts()) {
            LUA_MANAGER.unloadScript(script);
        }
    }

    public void onInitializeClient() {
        File libsDir;
        neuDir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID).toFile();
        neuDir.mkdirs();
        LUA_MANAGER = new LuaManager();
        File scriptsDir = new File(neuDir, "scripts");
        if (!scriptsDir.exists()) {
            scriptsDir.mkdir();
        }
        if (!(libsDir = new File(scriptsDir, "libs")).exists()) {
            libsDir.mkdir();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(HypixelCry::saveConfig));
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
        ClientCommandRegistrationCallback.EVENT.register(LuaCommand.INSTANCE::register);
        HypixelCry.init();
        ModuleManager.INSTANCE.registerInbuilt();
        Scheduler.INSTANCE.scheduleCyclic(Utils::update, 20);
        this.loadStartupScripts(scriptsDir);
    }

    private void loadStartupScripts(File dir) {
        for (String name : this.startUpScriptNames) {
            File autoLoadScript = new File(dir, name);
            if (!autoLoadScript.exists()) continue;
            try {
                LUA_MANAGER.executeScript(autoLoadScript);
                System.out.println("Autoload script executed successfully");
            }
            catch (Exception e) {
                System.out.println("Error executing autoload script: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void tick(class_310 client) {
        Scheduler.INSTANCE.tick();
    }

    private static void init() {
        EntityInfoCommand.init();
        PathFinderCommand.init();
        PathFinderWorker.init();
        NEURepoManager.init();
        com.nekiplay.hypixelcry.utils.StatusBarTracker.init();
        Utils.init();
        Attributes.init();
        ItemRepository.init();
        RenderHelper.init();
        SkyblockerRenderPipelines.init();
        ColdTracker.init();
        StatusBarTracker.init();
    }

    static {
        CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        PREFIX = String.valueOf(class_124.field_1080) + "[" + String.valueOf(class_124.field_1065) + "Hypixel Cry" + String.valueOf(class_124.field_1080) + "] " + String.valueOf(class_124.field_1070);
        mc = class_310.method_1551();
    }
}

