/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.pathfinder.goal;

import com.nekiplay.hypixelcry.pathfinder.goal.IGoal;
import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "Lcom/nekiplay/hypixelcry/pathfinder/goal/IGoal;", "", "goalX", "goalY", "goalZ", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "ctx", "<init>", "(IIILcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;)V", "x", "y", "z", "", "isAtGoal", "(III)Z", "", "heuristic", "(III)D", "", "toString", "()Ljava/lang/String;", "I", "getGoalX", "()I", "getGoalY", "getGoalZ", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "getCtx", "()Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "SQRT_2", "D", "hypixel-cry"})
public final class Goal
implements IGoal {
    private final int goalX;
    private final int goalY;
    private final int goalZ;
    @NotNull
    private final CalculationContext ctx;
    private final double SQRT_2;

    public Goal(int goalX, int goalY, int goalZ, @NotNull CalculationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.goalX = goalX;
        this.goalY = goalY;
        this.goalZ = goalZ;
        this.ctx = ctx;
        this.SQRT_2 = Math.sqrt(2.0);
    }

    public final int getGoalX() {
        return this.goalX;
    }

    public final int getGoalY() {
        return this.goalY;
    }

    public final int getGoalZ() {
        return this.goalZ;
    }

    @NotNull
    public final CalculationContext getCtx() {
        return this.ctx;
    }

    @Override
    public boolean isAtGoal(int x, int y, int z) {
        return this.goalX == x && this.goalY == y && this.goalZ == z;
    }

    @Override
    public double heuristic(int x, int y, int z) {
        int dx = Math.abs(this.goalX - x);
        int dz = Math.abs(this.goalZ - z);
        double straight = Math.abs(dx - dz);
        double vertical = Math.abs(this.goalY - y);
        double diagonal = Math.min(dx, dz);
        vertical = this.goalY > y ? (vertical *= 6.234399666206506) : (vertical *= this.ctx.getCost().getN_BLOCK_FALL_COST()[2] / 2.0);
        return (straight + diagonal * this.SQRT_2) * this.ctx.getCost().getONE_BLOCK_SPRINT_COST() + vertical;
    }

    @NotNull
    public String toString() {
        return "x: " + this.goalX + ", y: " + this.goalY + ", z: " + this.goalZ;
    }
}

