/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class RaycastUtils {
    public static class_239 rayTraceToBlocks(class_243 startVec, class_243 endVec, List<class_2248> blocks) {
        return RaycastUtils.fastRayTrace(startVec, endVec, blocks);
    }

    public static class_239 fastRayTrace(class_1297 sourceEntity, class_243 startVec, class_243 endVec, List<class_2248> targetBlocks) {
        class_3965 startHit;
        class_3965 resultBlockHit = class_3965.method_17778((class_243)endVec, (class_2350)class_2350.method_10142((double)(endVec.field_1352 - startVec.field_1352), (double)(endVec.field_1351 - startVec.field_1351), (double)(endVec.field_1350 - startVec.field_1350)), (class_2338)class_2338.method_49638((class_2374)endVec));
        int startX = class_3532.method_15357((double)startVec.field_1352);
        int startY = class_3532.method_15357((double)startVec.field_1351);
        int startZ = class_3532.method_15357((double)startVec.field_1350);
        int endX = class_3532.method_15357((double)endVec.field_1352);
        int endY = class_3532.method_15357((double)endVec.field_1351);
        int endZ = class_3532.method_15357((double)endVec.field_1350);
        double currentX = startVec.field_1352;
        double currentY = startVec.field_1351;
        double currentZ = startVec.field_1350;
        class_2338 startPos = new class_2338(startX, startY, startZ);
        class_2680 startState = HypixelCry.mc.field_1687.method_8320(startPos);
        if ((targetBlocks.isEmpty() && startState.method_26212((class_1922)HypixelCry.mc.field_1687, startPos) || targetBlocks.contains(startState.method_26204())) && (startHit = startState.method_26220((class_1922)HypixelCry.mc.field_1687, startPos).method_1092(startVec, endVec, startPos)) != null) {
            resultBlockHit = startHit;
        }
        if (resultBlockHit.method_17783() == class_239.class_240.field_1333) {
            int maxSteps = 200;
            int stepX = endX > startX ? 1 : -1;
            int stepY = endY > startY ? 1 : -1;
            int stepZ = endZ > startZ ? 1 : -1;
            double dx = endVec.field_1352 - startVec.field_1352;
            double dy = endVec.field_1351 - startVec.field_1351;
            double dz = endVec.field_1350 - startVec.field_1350;
            int currBlockX = startX;
            int currBlockY = startY;
            int currBlockZ = startZ;
            while (maxSteps-- >= 0 && (currBlockX != endX || currBlockY != endY || currBlockZ != endZ)) {
                class_3965 hit;
                double zDist;
                double yExit;
                double xExit;
                boolean zDifferent;
                boolean xDifferent = currBlockX != endX;
                boolean yDifferent = currBlockY != endY;
                boolean bl = zDifferent = currBlockZ != endZ;
                double d = xDifferent ? (stepX > 0 ? (double)currBlockX + 1.0 : (double)currBlockX) : (xExit = Double.MAX_VALUE);
                double d2 = yDifferent ? (stepY > 0 ? (double)currBlockY + 1.0 : (double)currBlockY) : (yExit = Double.MAX_VALUE);
                double zExit = zDifferent ? (stepZ > 0 ? (double)currBlockZ + 1.0 : (double)currBlockZ) : Double.MAX_VALUE;
                double xDist = xDifferent ? (xExit - currentX) / dx : Double.MAX_VALUE;
                double yDist = yDifferent ? (yExit - currentY) / dy : Double.MAX_VALUE;
                double d3 = zDist = zDifferent ? (zExit - currentZ) / dz : Double.MAX_VALUE;
                if (xDist < 0.0) {
                    xDist = Double.MAX_VALUE;
                }
                if (yDist < 0.0) {
                    yDist = Double.MAX_VALUE;
                }
                if (zDist < 0.0) {
                    zDist = Double.MAX_VALUE;
                }
                if (xDist < yDist && xDist < zDist) {
                    exitFace = stepX > 0 ? class_2350.field_11039 : class_2350.field_11034;
                    currentX = xExit;
                    currentY += dy * xDist;
                    currentZ += dz * xDist;
                    currBlockX += stepX;
                } else if (yDist < zDist) {
                    exitFace = stepY > 0 ? class_2350.field_11033 : class_2350.field_11036;
                    currentX += dx * yDist;
                    currentY = yExit;
                    currentZ += dz * yDist;
                    currBlockY += stepY;
                } else {
                    exitFace = stepZ > 0 ? class_2350.field_11043 : class_2350.field_11035;
                    currentX += dx * zDist;
                    currentY += dy * zDist;
                    currentZ = zExit;
                    currBlockZ += stepZ;
                }
                class_2338 newPos = new class_2338(currBlockX, currBlockY, currBlockZ);
                class_2680 newState = HypixelCry.mc.field_1687.method_8320(newPos);
                class_2248 newBlock = newState.method_26204();
                boolean shouldCheckBlock = targetBlocks.isEmpty() ? newState.method_26212((class_1922)HypixelCry.mc.field_1687, newPos) : targetBlocks.contains(newBlock);
                if (!shouldCheckBlock || (hit = newState.method_26220((class_1922)HypixelCry.mc.field_1687, newPos).method_1092(startVec, endVec, newPos)) == null) continue;
                resultBlockHit = hit;
                break;
            }
        }
        class_243 effectiveEndVec = resultBlockHit.method_17784();
        double distToBlockSqr = startVec.method_1025(effectiveEndVec);
        class_238 area = new class_238(startVec, effectiveEndVec).method_1014(1.0);
        class_3966 entityHit = class_1675.method_18075((class_1297)sourceEntity, (class_243)startVec, (class_243)effectiveEndVec, (class_238)area, e -> !e.method_7325() && e.method_5863(), (double)distToBlockSqr);
        if (entityHit != null) {
            return entityHit;
        }
        return resultBlockHit;
    }

    private static class_239 fastRayTrace(class_243 startVec, class_243 endVec, List<class_2248> targetBlocks) {
        class_3965 startHit;
        int startX = (int)Math.floor(startVec.field_1352);
        int startY = (int)Math.floor(startVec.field_1351);
        int startZ = (int)Math.floor(startVec.field_1350);
        int endX = (int)Math.floor(endVec.field_1352);
        int endY = (int)Math.floor(endVec.field_1351);
        int endZ = (int)Math.floor(endVec.field_1350);
        class_2338 startPos = new class_2338(startX, startY, startZ);
        class_2680 startState = HypixelCry.mc.field_1687.method_8320(startPos);
        if (startState.method_26212((class_1922)HypixelCry.mc.field_1687, startPos) && (startHit = startState.method_26220((class_1922)HypixelCry.mc.field_1687, startPos).method_1092(startVec, endVec, startPos)) != null) {
            return startHit;
        }
        class_239 closestHit = null;
        int maxSteps = 200;
        while (maxSteps-- >= 0) {
            class_3965 hit;
            boolean shouldCheckBlock;
            class_2350 exitFace;
            double zDist;
            double yExit;
            double xExit;
            boolean zDifferent;
            if (startX == endX && startY == endY && startZ == endZ) {
                return closestHit;
            }
            boolean xDifferent = startX != endX;
            boolean yDifferent = startY != endY;
            boolean bl = zDifferent = startZ != endZ;
            double d = xDifferent ? (endX > startX ? (double)startX + 1.0 : (double)startX) : (xExit = 999.0);
            double d2 = yDifferent ? (endY > startY ? (double)startY + 1.0 : (double)startY) : (yExit = 999.0);
            double zExit = zDifferent ? (endZ > startZ ? (double)startZ + 1.0 : (double)startZ) : 999.0;
            double dx = endVec.field_1352 - startVec.field_1352;
            double dy = endVec.field_1351 - startVec.field_1351;
            double dz = endVec.field_1350 - startVec.field_1350;
            double xDist = xDifferent ? (xExit - startVec.field_1352) / dx : 999.0;
            double yDist = yDifferent ? (yExit - startVec.field_1351) / dy : 999.0;
            double d3 = zDist = zDifferent ? (zExit - startVec.field_1350) / dz : 999.0;
            if (xDist == -0.0) {
                xDist = -1.0E-4;
            }
            if (yDist == -0.0) {
                yDist = -1.0E-4;
            }
            if (zDist == -0.0) {
                zDist = -1.0E-4;
            }
            if (xDist < yDist && xDist < zDist) {
                exitFace = endX > startX ? class_2350.field_11039 : class_2350.field_11034;
                startVec = new class_243(xExit, startVec.field_1351 + dy * xDist, startVec.field_1350 + dz * xDist);
            } else if (yDist < zDist) {
                exitFace = endY > startY ? class_2350.field_11033 : class_2350.field_11036;
                startVec = new class_243(startVec.field_1352 + dx * yDist, yExit, startVec.field_1350 + dz * yDist);
            } else {
                exitFace = endZ > startZ ? class_2350.field_11043 : class_2350.field_11035;
                startVec = new class_243(startVec.field_1352 + dx * zDist, startVec.field_1351 + dy * zDist, zExit);
            }
            startX = class_3532.method_15357((double)startVec.field_1352) - (exitFace == class_2350.field_11034 ? 1 : 0);
            startY = class_3532.method_15357((double)startVec.field_1351) - (exitFace == class_2350.field_11036 ? 1 : 0);
            startZ = class_3532.method_15357((double)startVec.field_1350) - (exitFace == class_2350.field_11035 ? 1 : 0);
            class_2338 newPos = new class_2338(startX, startY, startZ);
            class_2680 newState = HypixelCry.mc.field_1687.method_8320(newPos);
            class_2248 newBlock = newState.method_26204();
            boolean bl2 = shouldCheckBlock = targetBlocks.isEmpty() ? newState.method_26212((class_1922)HypixelCry.mc.field_1687, newPos) : targetBlocks.contains(newBlock);
            if (shouldCheckBlock && (hit = newState.method_26220((class_1922)HypixelCry.mc.field_1687, newPos).method_1092(startVec, endVec, newPos)) != null) {
                return hit;
            }
            closestHit = new class_239(startVec){

                public class_239.class_240 method_17783() {
                    return class_239.class_240.field_1333;
                }
            };
        }
        return closestHit;
    }

    public static class_239 findCrosshairTarget(class_1297 camera, double blockInteractionRange, double entityInteractionRange, float tickProgress) {
        double d = Math.max(blockInteractionRange, entityInteractionRange);
        double e = class_3532.method_33723((double)d);
        class_243 vec3d = camera.method_5836(tickProgress);
        class_239 hitResult = camera.method_5745(d, tickProgress, false);
        double f = hitResult.method_17784().method_1025(vec3d);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            e = f;
            d = Math.sqrt(f);
        }
        class_243 vec3d2 = camera.method_5828(tickProgress);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * d, vec3d2.field_1351 * d, vec3d2.field_1350 * d);
        float g = 1.0f;
        class_238 box = camera.method_5829().method_18804(vec3d2.method_1021(d)).method_1009(1.0, 1.0, 1.0);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)camera, (class_243)vec3d, (class_243)vec3d3, (class_238)box, (Predicate)class_1301.field_52443, (double)e);
        return entityHitResult != null && entityHitResult.method_17784().method_1025(vec3d) < f ? RaycastUtils.ensureTargetInRange((class_239)entityHitResult, vec3d, entityInteractionRange) : RaycastUtils.ensureTargetInRange(hitResult, vec3d, blockInteractionRange);
    }

    private static class_239 ensureTargetInRange(class_239 hitResult, class_243 cameraPos, double interactionRange) {
        class_243 vec3d = hitResult.method_17784();
        if (!vec3d.method_24802((class_2374)cameraPos, interactionRange)) {
            class_243 vec3d2 = hitResult.method_17784();
            class_2350 direction = class_2350.method_10142((double)(vec3d2.field_1352 - cameraPos.field_1352), (double)(vec3d2.field_1351 - cameraPos.field_1351), (double)(vec3d2.field_1350 - cameraPos.field_1350));
            return class_3965.method_17778((class_243)vec3d2, (class_2350)direction, (class_2338)class_2338.method_49638((class_2374)vec3d2));
        }
        return hitResult;
    }
}

