/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.compatibility;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CaxtonCompatibility {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean CAXTON_ENABLED = FabricLoader.getInstance().isModLoaded("caxton");
    private static final MethodHandle HANDLE = CaxtonCompatibility.createHandle();
    private static boolean errored = false;

    @Nullable
    private static MethodHandle createHandle() {
        Class<?> clazz;
        if (!CAXTON_ENABLED) {
            return null;
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            clazz = Class.forName("xyz.flirora.caxton.render.Voepfxo");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("[Skyblocker Caxton Compat] Could not find xyz.flirora.caxton.render.Voepfxo", (Throwable)e);
            return null;
        }
        try {
            return lookup.findStatic(clazz, "drawText4Way", MethodType.methodType(Void.TYPE, class_332.class, class_327.class, class_5481.class, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOGGER.error("[Skyblocker Caxton Compat] Could not find drawText4Way method", (Throwable)e);
            return null;
        }
    }

    private static Optional<RenderPipeline> getCaxtonPipeline(String name) {
        Class<?> clazz;
        if (!CAXTON_ENABLED) {
            return Optional.empty();
        }
        try {
            clazz = Class.forName("xyz.flirora.caxton.render.CaxtonShaders");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("[Skyblocker Caxton Compat] Could not find xyz.flirora.caxton.render.CaxtonShaders", (Throwable)e);
            return Optional.empty();
        }
        try {
            return Optional.of((RenderPipeline)clazz.getField(name).get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("[Skyblocker Caxton Compat] Could not find {} shader", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    public static boolean drawOutlinedText(class_332 context, class_5481 text2, float x, float y, int color, int outlineColor) {
        if (HANDLE == null || errored) {
            return false;
        }
        try {
            HANDLE.invoke(context, class_310.method_1551().field_1772, text2, x, y, color, outlineColor);
        }
        catch (Throwable e) {
            LOGGER.error("[Skyblocker Caxton Compat] Could not invoke drawText4Way", e);
            errored = true;
            return false;
        }
        return true;
    }

    public static Optional<RenderPipeline> getSeeThroughTextPipeline() {
        return CaxtonCompatibility.getCaxtonPipeline("TEXT_SEE_THROUGH");
    }

    public static Optional<RenderPipeline> getTextPipeline() {
        return CaxtonCompatibility.getCaxtonPipeline("TEXT");
    }
}

