/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.utils.render.Renderer;
import com.nekiplay.hypixelcry.utils.render.WorldRenderExtractionCallback;
import com.nekiplay.hypixelcry.utils.render.primitive.PrimitiveCollectorImpl;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldExtractionContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_10209;
import net.minecraft.class_11231;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class RenderHelper {
    private static final class_310 CLIENT = class_310.method_1551();
    private static PrimitiveCollectorImpl collector;

    @Init
    public static void init() {
        WorldRenderEvents.END_EXTRACTION.register(RenderHelper::startExtraction);
        WorldRenderEvents.BEFORE_ENTITIES.register(RenderHelper::submitVanillaSubmittables);
        WorldRenderEvents.END_MAIN.register(RenderHelper::executeDraws);
    }

    private static void startExtraction(WorldExtractionContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerPrimitiveCollection");
        collector = new PrimitiveCollectorImpl(context.worldState(), context.frustum());
        ((WorldRenderExtractionCallback)WorldRenderExtractionCallback.EVENT.invoker()).onExtract(collector);
        collector.endCollection();
        profiler.method_15407();
    }

    private static void submitVanillaSubmittables(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerSubmitVanillaSubmittables");
        collector.dispatchVanillaSubmittables(context.worldState(), context.commandQueue());
        profiler.method_15407();
    }

    private static void executeDraws(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerSubmitPrimitives");
        collector.dispatchPrimitivesToRenderers(context.worldState().field_63082);
        collector = null;
        profiler.method_15407();
        profiler.method_15396("skyblockerExecuteDraws");
        Renderer.executeDraws();
        profiler.method_15407();
    }

    public static void runOnRenderThread(Runnable runnable) {
        if (RenderSystem.isOnRenderThread()) {
            runnable.run();
        } else {
            CLIENT.execute(runnable);
        }
    }

    public static class_9779 getTickCounter() {
        return CLIENT.method_61966();
    }

    public static class_4184 getCamera() {
        return RenderHelper.CLIENT.field_1773.method_19418();
    }

    @Nullable
    public static class_238 getBlockBoundingBox(class_638 world, class_2338 pos) {
        return RenderHelper.getBlockBoundingBox(world, world.method_8320(pos), pos);
    }

    @Nullable
    public static class_238 getBlockBoundingBox(class_638 world, class_2680 state, class_2338 pos) {
        class_265 shape = state.method_26218((class_1922)world, pos).method_52620();
        return shape.method_1110() ? null : shape.method_1107().method_996(pos);
    }

    public static class_11231 singleTexture(GpuTextureView texture) {
        return class_11231.method_70900((GpuTextureView)texture);
    }

    public static class_11231 textureWithLightmap(GpuTextureView texture) {
        return class_11231.method_70902((GpuTextureView)texture);
    }
}

