/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.render.primitive;

import com.nekiplay.hypixelcry.utils.render.FrustumUtils;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.render.primitive.BlockHologramRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.CursorLineRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.CylinderRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.FilledBoxRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.FilledCircleRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.LinesRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.OutlinedBoxRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.OutlinedCircleRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.PrimitiveCollector;
import com.nekiplay.hypixelcry.utils.render.primitive.QuadRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.SphereRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.TextPrimitiveRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.TexturedQuadRenderer;
import com.nekiplay.hypixelcry.utils.render.primitive.VanillaRenderer;
import com.nekiplay.hypixelcry.utils.render.state.BlockHologramRenderState;
import com.nekiplay.hypixelcry.utils.render.state.CursorLineRenderState;
import com.nekiplay.hypixelcry.utils.render.state.CylinderRenderState;
import com.nekiplay.hypixelcry.utils.render.state.FilledBoxRenderState;
import com.nekiplay.hypixelcry.utils.render.state.FilledCircleRenderState;
import com.nekiplay.hypixelcry.utils.render.state.LinesRenderState;
import com.nekiplay.hypixelcry.utils.render.state.OutlinedBoxRenderState;
import com.nekiplay.hypixelcry.utils.render.state.OutlinedCircleRenderState;
import com.nekiplay.hypixelcry.utils.render.state.QuadRenderState;
import com.nekiplay.hypixelcry.utils.render.state.SphereRenderState;
import com.nekiplay.hypixelcry.utils.render.state.TextRenderState;
import com.nekiplay.hypixelcry.utils.render.state.TexturedQuadRenderState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11658;
import net.minecraft.class_11659;
import net.minecraft.class_11950;
import net.minecraft.class_12075;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4604;
import net.minecraft.class_5481;
import net.minecraft.class_9848;

public final class PrimitiveCollectorImpl
implements PrimitiveCollector {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int MAX_OVERWORLD_BUILD_HEIGHT = 319;
    private final class_11658 worldState;
    private final class_4604 frustum;
    private List<VanillaSubmittable<?>> vanillaSubmittables = null;
    private List<FilledBoxRenderState> filledBoxStates = null;
    private List<OutlinedBoxRenderState> outlinedBoxStates = null;
    private List<LinesRenderState> linesStates = null;
    private List<CursorLineRenderState> cursorLineStates = null;
    private List<QuadRenderState> quadStates = null;
    private List<TexturedQuadRenderState> texturedQuadStates = null;
    private List<BlockHologramRenderState> blockHologramStates = null;
    private List<TextRenderState> textStates = null;
    private List<CylinderRenderState> cylinderStates = null;
    private List<FilledCircleRenderState> filledCircleStates = null;
    private List<SphereRenderState> sphereStates = null;
    private List<OutlinedCircleRenderState> outlinedCircleStates = null;
    private boolean frozen = false;

    public PrimitiveCollectorImpl(class_11658 worldState, class_4604 frustum) {
        this.worldState = worldState;
        this.frustum = frustum;
    }

    @Override
    public <S> void submitVanilla(S state, VanillaRenderer<S> renderer) {
        this.ensureNotFrozen();
        if (this.vanillaSubmittables == null) {
            this.vanillaSubmittables = new ArrayList();
        }
        this.vanillaSubmittables.add(new VanillaSubmittable<S>(state, renderer));
    }

    @Override
    public void submitFilledBox(class_2338 pos, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colourComponents, alpha, throughWalls);
    }

    @Override
    public void submitFilledBox(class_243 pos, class_243 dimensions, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colourComponents, alpha, throughWalls);
    }

    @Override
    public void submitFilledBox(class_238 box, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colourComponents, alpha, throughWalls);
    }

    private void submitFilledBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colourComponents, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(this.frustum, minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        if (this.filledBoxStates == null) {
            this.filledBoxStates = new ArrayList<FilledBoxRenderState>();
        }
        FilledBoxRenderState state = new FilledBoxRenderState();
        state.minX = minX;
        state.minY = minY;
        state.minZ = minZ;
        state.maxX = maxX;
        state.maxY = maxY;
        state.maxZ = maxZ;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.filledBoxStates.add(state);
    }

    @Override
    public void submitBeaconBeam(class_2338 pos, float[] colourComponents) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(this.frustum, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, 319.0, pos.method_10260() + 1)) {
            return;
        }
        int colour = class_9848.method_61318((float)1.0f, (float)colourComponents[0], (float)colourComponents[1], (float)colourComponents[2]);
        float length = (float)RenderHelper.getCamera().method_19326().method_1020(pos.method_46558()).method_37267();
        class_11950 state = new class_11950();
        state.field_62673 = pos;
        state.field_62674 = class_2246.field_10327.method_9564();
        state.field_62675 = class_2591.field_11890;
        state.field_62676 = 0xF000F0;
        state.field_62677 = null;
        state.field_62665 = PrimitiveCollectorImpl.CLIENT.field_1687 != null ? (float)Math.floorMod(PrimitiveCollectorImpl.CLIENT.field_1687.method_8510(), 40) + CLIENT.method_61966().method_60637(true) : 0.0f;
        state.field_62667.add(new class_11950.class_11951(colour, 319));
        state.field_62666 = PrimitiveCollectorImpl.CLIENT.field_1724 != null && PrimitiveCollectorImpl.CLIENT.field_1724.method_31550() ? 1.0f : Math.max(1.0f, length / 96.0f);
        this.worldState.field_62646.add(state);
    }

    @Override
    public void submitOutlinedBox(class_2338 pos, float[] colourComponents, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colourComponents, 1.0f, lineWidth, throughWalls);
    }

    @Override
    public void submitOutlinedBox(class_238 box, float[] colourComponents, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(box, colourComponents, 1.0f, lineWidth, throughWalls);
    }

    @Override
    public void submitOutlinedBox(class_238 box, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colourComponents, alpha, lineWidth, throughWalls);
    }

    private void submitOutlinedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(this.frustum, minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        if (this.outlinedBoxStates == null) {
            this.outlinedBoxStates = new ArrayList<OutlinedBoxRenderState>();
        }
        OutlinedBoxRenderState state = new OutlinedBoxRenderState();
        state.minX = minX;
        state.minY = minY;
        state.minZ = minZ;
        state.maxX = maxX;
        state.maxY = maxY;
        state.maxZ = maxZ;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        state.throughWalls = throughWalls;
        this.outlinedBoxStates.add(state);
    }

    @Override
    public void submitLinesFromPoints(class_243[] points, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.linesStates == null) {
            this.linesStates = new ArrayList<LinesRenderState>();
        }
        LinesRenderState state = new LinesRenderState();
        state.points = points;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        state.throughWalls = throughWalls;
        this.linesStates.add(state);
    }

    @Override
    public void submitLineFromCursor(class_243 point, float[] colourComponents, float alpha, float lineWidth) {
        this.ensureNotFrozen();
        if (this.cursorLineStates == null) {
            this.cursorLineStates = new ArrayList<CursorLineRenderState>();
        }
        CursorLineRenderState state = new CursorLineRenderState();
        state.point = point;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        this.cursorLineStates.add(state);
    }

    @Override
    public void submitQuad(class_243[] points, float[] colourComponents, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.quadStates == null) {
            this.quadStates = new ArrayList<QuadRenderState>();
        }
        QuadRenderState state = new QuadRenderState();
        state.points = points;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.quadStates.add(state);
    }

    @Override
    public void submitTexturedQuad(class_243 pos, float width, float height, float textureWidth, float textureHeight, class_243 renderOffset, class_2960 texture, float[] shaderColour, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.texturedQuadStates == null) {
            this.texturedQuadStates = new ArrayList<TexturedQuadRenderState>();
        }
        TexturedQuadRenderState state = new TexturedQuadRenderState();
        state.pos = pos;
        state.width = width;
        state.height = height;
        state.textureWidth = textureWidth;
        state.textureHeight = textureHeight;
        state.renderOffset = renderOffset;
        state.texture = texture;
        state.shaderColour = shaderColour;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.texturedQuadStates.add(state);
    }

    @Override
    public void submitBlockHologram(class_2338 pos, class_2680 state) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(this.frustum, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1)) {
            return;
        }
        if (this.blockHologramStates == null) {
            this.blockHologramStates = new ArrayList<BlockHologramRenderState>();
        }
        BlockHologramRenderState renderState = new BlockHologramRenderState();
        renderState.pos = pos;
        renderState.state = state;
        this.blockHologramStates.add(renderState);
    }

    @Override
    public void submitText(class_2561 text2, class_243 pos, boolean throughWalls) {
        this.submitText(text2, pos, 1.0f, throughWalls);
    }

    @Override
    public void submitText(class_2561 text2, class_243 pos, float scale, boolean throughWalls) {
        this.submitText(text2, pos, scale, 0.0f, throughWalls);
    }

    @Override
    public void submitText(class_2561 text2, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        this.submitText(text2.method_30937(), pos, scale, yOffset, -1, throughWalls);
    }

    @Override
    public void submitText(class_2561 text2, class_243 pos, int color, float scale, float yOffset, boolean throughWalls) {
        this.submitText(text2.method_30937(), pos, scale, yOffset, color, throughWalls);
    }

    private void submitText(class_5481 text2, class_243 pos, float scale, float yOffset, int color, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.textStates == null) {
            this.textStates = new ArrayList<TextRenderState>();
        }
        class_327 textRenderer = PrimitiveCollectorImpl.CLIENT.field_1772;
        float xOffset = (float)(-textRenderer.method_30880(text2)) / 2.0f;
        class_327.class_11465 glyphs = textRenderer.method_71795(text2, xOffset, yOffset, class_9848.method_61338((int)color), false, 0);
        TextRenderState state = new TextRenderState();
        state.glyphs = glyphs;
        state.pos = pos;
        state.scale = scale * 0.025f;
        state.yOffset = yOffset;
        state.throughWalls = throughWalls;
        this.textStates.add(state);
    }

    @Override
    public void submitCylinder(class_243 centre, float radius, float height, int segments, int colour) {
        this.ensureNotFrozen();
        if (this.cylinderStates == null) {
            this.cylinderStates = new ArrayList<CylinderRenderState>();
        }
        CylinderRenderState state = new CylinderRenderState();
        state.centre = centre;
        state.radius = radius;
        state.height = height;
        state.segments = segments;
        state.colour = colour;
        this.cylinderStates.add(state);
    }

    @Override
    public void submitFilledCircle(class_243 centre, float radius, int segments, int colour, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.filledCircleStates == null) {
            this.filledCircleStates = new ArrayList<FilledCircleRenderState>();
        }
        FilledCircleRenderState state = new FilledCircleRenderState();
        state.centre = centre;
        state.radius = radius;
        state.segments = segments;
        state.colour = colour;
        state.throughWalls = throughWalls;
        this.filledCircleStates.add(state);
    }

    @Override
    public void submitSphere(class_243 centre, float radius, int segments, int rings, int colour) {
        this.ensureNotFrozen();
        if (this.sphereStates == null) {
            this.sphereStates = new ArrayList<SphereRenderState>();
        }
        SphereRenderState state = new SphereRenderState();
        state.centre = centre;
        state.radius = radius;
        state.segments = segments;
        state.rings = rings;
        state.colour = colour;
        this.sphereStates.add(state);
    }

    @Override
    public void submitOutlinedCircle(class_243 centre, float radius, float thickness, int segments, int colour, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.outlinedCircleStates == null) {
            this.outlinedCircleStates = new ArrayList<OutlinedCircleRenderState>();
        }
        OutlinedCircleRenderState state = new OutlinedCircleRenderState();
        state.centre = centre;
        state.radius = radius;
        state.thickness = thickness;
        state.segments = segments;
        state.colour = colour;
        state.throughWalls = throughWalls;
        this.outlinedCircleStates.add(state);
    }

    public void endCollection() {
        this.frozen = true;
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot submit primitives once the collection phase has ended!");
        }
    }

    public void dispatchVanillaSubmittables(class_11658 worldState, class_11659 commandQueue) {
        if (!this.frozen) {
            throw new IllegalStateException("Cannot dispatch vanilla submittables until the collection phase has ended!");
        }
        if (this.vanillaSubmittables != null) {
            for (VanillaSubmittable<?> submittable : this.vanillaSubmittables) {
                submittable.renderer.submitVanilla(submittable.state(), worldState, commandQueue);
            }
        }
    }

    public void dispatchPrimitivesToRenderers(class_12075 cameraState) {
        if (!this.frozen) {
            throw new IllegalStateException("Cannot dispatch primitives until the collection phase has ended!");
        }
        if (this.filledBoxStates != null) {
            for (FilledBoxRenderState filledBoxRenderState : this.filledBoxStates) {
                FilledBoxRenderer.INSTANCE.submitPrimitives(filledBoxRenderState, cameraState);
            }
        }
        if (this.outlinedBoxStates != null) {
            for (OutlinedBoxRenderState outlinedBoxRenderState : this.outlinedBoxStates) {
                OutlinedBoxRenderer.INSTANCE.submitPrimitives(outlinedBoxRenderState, cameraState);
            }
        }
        if (this.linesStates != null) {
            for (LinesRenderState linesRenderState : this.linesStates) {
                LinesRenderer.INSTANCE.submitPrimitives(linesRenderState, cameraState);
            }
        }
        if (this.cursorLineStates != null) {
            for (CursorLineRenderState cursorLineRenderState : this.cursorLineStates) {
                CursorLineRenderer.INSTANCE.submitPrimitives(cursorLineRenderState, cameraState);
            }
        }
        if (this.quadStates != null) {
            for (QuadRenderState quadRenderState : this.quadStates) {
                QuadRenderer.INSTANCE.submitPrimitives(quadRenderState, cameraState);
            }
        }
        if (this.cylinderStates != null) {
            for (CylinderRenderState cylinderRenderState : this.cylinderStates) {
                CylinderRenderer.INSTANCE.submitPrimitives(cylinderRenderState, cameraState);
            }
        }
        if (this.filledCircleStates != null) {
            for (FilledCircleRenderState filledCircleRenderState : this.filledCircleStates) {
                FilledCircleRenderer.INSTANCE.submitPrimitives(filledCircleRenderState, cameraState);
            }
        }
        if (this.sphereStates != null) {
            for (SphereRenderState sphereRenderState : this.sphereStates) {
                SphereRenderer.INSTANCE.submitPrimitives(sphereRenderState, cameraState);
            }
        }
        if (this.outlinedCircleStates != null) {
            for (OutlinedCircleRenderState outlinedCircleRenderState : this.outlinedCircleStates) {
                OutlinedCircleRenderer.INSTANCE.submitPrimitives(outlinedCircleRenderState, cameraState);
            }
        }
        if (this.texturedQuadStates != null) {
            for (TexturedQuadRenderState texturedQuadRenderState : this.texturedQuadStates) {
                TexturedQuadRenderer.INSTANCE.submitPrimitives(texturedQuadRenderState, cameraState);
            }
        }
        if (this.blockHologramStates != null) {
            for (BlockHologramRenderState blockHologramRenderState : this.blockHologramStates) {
                BlockHologramRenderer.INSTANCE.submitPrimitives(blockHologramRenderState, cameraState);
            }
        }
        if (this.textStates != null) {
            for (TextRenderState textRenderState : this.textStates) {
                TextPrimitiveRenderer.INSTANCE.submitPrimitives(textRenderState, cameraState);
            }
        }
    }

    private record VanillaSubmittable<S>(S state, VanillaRenderer<S> renderer) {
    }
}

