/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.render.primitive;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.nekiplay.hypixelcry.utils.compatibility.CaxtonCompatibility;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.render.Renderer;
import com.nekiplay.hypixelcry.utils.render.primitive.PrimitiveRenderer;
import com.nekiplay.hypixelcry.utils.render.state.TextRenderState;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11767;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_327;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public final class TextPrimitiveRenderer
implements PrimitiveRenderer<TextRenderState> {
    protected static final TextPrimitiveRenderer INSTANCE = new TextPrimitiveRenderer();
    private static final RenderPipeline SEE_THROUGH = CaxtonCompatibility.getSeeThroughTextPipeline().orElse(class_10799.field_56822);
    private static final RenderPipeline NORMAL = CaxtonCompatibility.getTextPipeline().orElse(class_10799.field_56818);

    private TextPrimitiveRenderer() {
    }

    @Override
    public void submitPrimitives(TextRenderState state, class_12075 cameraState) {
        final RenderPipeline pipeline = state.throughWalls ? SEE_THROUGH : NORMAL;
        final Matrix4f positionMatrix = new Matrix4f().translate((float)(state.pos.method_10216() - cameraState.field_63078.method_10216()), (float)(state.pos.method_10214() - cameraState.field_63078.method_10214()), (float)(state.pos.method_10215() - cameraState.field_63078.method_10215())).rotate((Quaternionfc)cameraState.field_63081).scale(state.scale, -state.scale, state.scale);
        state.glyphs.method_71801(new class_327.class_11464(){

            public void method_71797(class_11767 glyph) {
                this.draw(glyph);
            }

            public void method_71798(class_11767 bakedGlyph) {
                this.draw(bakedGlyph);
            }

            private void draw(class_11767 glyph) {
                class_11231 textureSetup = RenderHelper.textureWithLightmap(glyph.comp_4629());
                class_287 buffer = Renderer.getBuffer(pipeline, textureSetup);
                glyph.method_73403(positionMatrix, (class_4588)buffer, 0xF000F0, false);
            }
        });
    }
}

