/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.pathfinder.utils;

import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import com.nekiplay.hypixelcry.pathfinder.movement.MovementHelper;
import com.nekiplay.hypixelcry.pathfinder.utils.RefKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f\u00a2\u0006\u0004\b\n\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/nekiplay/hypixelcry/pathfinder/utils/BlockUtil;", "", "<init>", "()V", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "ctx", "Lnet/minecraft/class_2338;", "start", "end", "", "bresenham", "(Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;Lnet/minecraft/class_2338;Lnet/minecraft/class_2338;)Z", "Lnet/minecraft/class_243;", "(Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Z", "hypixel-cry"})
public final class BlockUtil {
    @NotNull
    public static final BlockUtil INSTANCE = new BlockUtil();

    private BlockUtil() {
    }

    public final boolean bresenham(@NotNull CalculationContext ctx, @NotNull class_2338 start, @NotNull class_2338 end) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        class_243 class_2432 = class_243.method_24953((class_2382)((class_2382)start));
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ofCenter(...)");
        class_243 class_2433 = class_243.method_24953((class_2382)((class_2382)end));
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"ofCenter(...)");
        return this.bresenham(ctx, class_2432, class_2433);
    }

    public final boolean bresenham(@NotNull CalculationContext ctx, @NotNull class_243 start, @NotNull class_243 end) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        class_243 currentPos = start;
        int x1 = class_3532.method_15357((double)end.field_1352);
        int y1 = class_3532.method_15357((double)end.field_1351);
        int z1 = class_3532.method_15357((double)end.field_1350);
        int x0 = class_3532.method_15357((double)currentPos.field_1352);
        int y0 = class_3532.method_15357((double)currentPos.field_1351);
        int z0 = class_3532.method_15357((double)currentPos.field_1350);
        class_638 class_6382 = RefKt.getWorld();
        class_2680 lastState = class_6382 != null ? class_6382.method_8320(new class_2338(x0, y0, z0)) : null;
        class_2338 lastPos = new class_2338(x0, y0, z0);
        int iterations = 200;
        while (iterations-- >= 0) {
            int delta;
            if (x0 == x1 && y0 == y1 && z0 == z1) {
                return true;
            }
            boolean hasNewX = true;
            boolean hasNewY = true;
            boolean hasNewZ = true;
            double newX = 999.0;
            double newY = 999.0;
            double newZ = 999.0;
            if (x1 > x0) {
                newX = (double)x0 + 1.0;
            } else if (x1 < x0) {
                newX = (double)x0 + 0.0;
            } else {
                hasNewX = false;
            }
            if (y1 > y0) {
                newY = (double)y0 + 1.0;
            } else if (y1 < y0) {
                newY = (double)y0 + 0.0;
            } else {
                hasNewY = false;
            }
            if (z1 > z0) {
                newZ = (double)z0 + 1.0;
            } else if (z1 < z0) {
                newZ = (double)z0 + 0.0;
            } else {
                hasNewZ = false;
            }
            double stepX = 999.0;
            double stepY = 999.0;
            double stepZ = 999.0;
            double dx = end.field_1352 - currentPos.field_1352;
            double dy = end.field_1351 - currentPos.field_1351;
            double dz = end.field_1350 - currentPos.field_1350;
            if (hasNewX) {
                stepX = (newX - currentPos.field_1352) / dx;
            }
            if (hasNewY) {
                stepY = (newY - currentPos.field_1351) / dy;
            }
            if (hasNewZ) {
                stepZ = (newZ - currentPos.field_1350) / dz;
            }
            if (stepX == -0.0) {
                stepX = -1.0E-4;
            }
            if (stepY == -0.0) {
                stepY = -1.0E-4;
            }
            if (stepZ == -0.0) {
                stepZ = -1.0E-4;
            }
            class_2350 direction = null;
            if (stepX < stepY && stepX < stepZ) {
                direction = x1 > x0 ? class_2350.field_11039 : class_2350.field_11034;
                currentPos = new class_243(newX, currentPos.field_1351 + dy * stepX, currentPos.field_1350 + dz * stepX);
            } else if (stepY < stepZ) {
                direction = y1 > y0 ? class_2350.field_11033 : class_2350.field_11036;
                currentPos = new class_243(currentPos.field_1352 + dx * stepY, newY, currentPos.field_1350 + dz * stepY);
            } else {
                direction = z1 > z0 ? class_2350.field_11043 : class_2350.field_11035;
                currentPos = new class_243(currentPos.field_1352 + dx * stepZ, currentPos.field_1351 + dy * stepZ, newZ);
            }
            x0 = class_3532.method_15357((double)currentPos.field_1352) - (direction == class_2350.field_11034 ? 1 : 0);
            y0 = class_3532.method_15357((double)currentPos.field_1351) - (direction == class_2350.field_11036 ? 1 : 0);
            z0 = class_3532.method_15357((double)currentPos.field_1350) - (direction == class_2350.field_11035 ? 1 : 0);
            class_638 class_6383 = RefKt.getWorld();
            class_2680 currState = class_6383 != null ? class_6383.method_8320(new class_2338(x0, y0, z0)) : null;
            int i2 = 0;
            if (!(MovementHelper.INSTANCE.canStandOn(x0, y0, z0, ctx, currState) && MovementHelper.canWalkThrough$default(MovementHelper.INSTANCE, ctx, x0, y0 + 1, z0, null, 16, null) && MovementHelper.canWalkThrough$default(MovementHelper.INSTANCE, ctx, x0, y0 + 2, z0, null, 16, null))) {
                i2 = -3;
                boolean foundValidBlock = false;
                while (++i2 <= 3) {
                    if (i2 == 0) continue;
                    class_638 class_6384 = RefKt.getWorld();
                    currState = class_6384 != null ? class_6384.method_8320(new class_2338(x0, y0 + i2, z0)) : null;
                    if (!MovementHelper.INSTANCE.canStandOn(x0, y0 + i2, z0, ctx, currState) || !MovementHelper.canWalkThrough$default(MovementHelper.INSTANCE, ctx, x0, y0 + i2 + 1, z0, null, 16, null) || !MovementHelper.canWalkThrough$default(MovementHelper.INSTANCE, ctx, x0, y0 + i2 + 2, z0, null, 16, null)) continue;
                    foundValidBlock = true;
                    break;
                }
                if (!foundValidBlock) {
                    return false;
                }
            }
            if ((delta = y0 + i2 - lastPos.method_10264()) > 0) {
                if (delta > 1) {
                    return false;
                }
                double sourceHeight = -1.0;
                double destHeight = -1.0;
                boolean snow = false;
                class_2680 class_26802 = lastState;
                if ((class_26802 != null ? class_26802.method_26204() : null) instanceof class_2488) {
                    sourceHeight = (double)(((Number)((Object)lastState.method_11654((class_2769)class_2488.field_11518))).intValue() - 1) * 0.125;
                    snow = true;
                }
                class_2680 class_26803 = currState;
                if ((class_26803 != null ? class_26803.method_26204() : null) instanceof class_2488) {
                    destHeight = (double)(((Number)((Object)currState.method_11654((class_2769)class_2488.field_11518))).intValue() - 1) * 0.125;
                    snow = true;
                }
                if (!snow) {
                    boolean srcSmall = MovementHelper.INSTANCE.isBottomSlab(lastState);
                    boolean destSmall = MovementHelper.INSTANCE.isBottomSlab(currState);
                    boolean destSmallStair = MovementHelper.INSTANCE.isValidStair(currState, x0 - lastPos.method_10263(), z0 - lastPos.method_10260());
                    if (srcSmall != (destSmall || destSmallStair)) {
                        return false;
                    }
                    if (srcSmall) {
                        return false;
                    }
                } else {
                    if (sourceHeight == -1.0) {
                        class_2680 class_26804 = lastState;
                        double d = sourceHeight = class_26804 != null && (class_26804 = class_26804.method_26220((class_1922)RefKt.getWorld(), lastPos)) != null ? class_26804.method_1105(class_2350.class_2351.field_11052) : 0.0;
                    }
                    if (destHeight == -1.0) {
                        class_2680 class_26805 = currState;
                        double d = class_26805 != null && (class_26805 = class_26805.method_26220((class_1922)RefKt.getWorld(), new class_2338(x0, y0 + i2, z0))) != null ? class_26805.method_1105(class_2350.class_2351.field_11052) : (destHeight = 0.0);
                    }
                    if (destHeight - sourceHeight > -0.5) {
                        return false;
                    }
                }
            }
            lastState = currState;
            lastPos = new class_2338(x0, y0 + i2, z0);
        }
        return false;
    }
}

