/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.pathfinder.calculate;

import com.nekiplay.hypixelcry.pathfinder.calculate.PathNode;
import com.nekiplay.hypixelcry.pathfinder.goal.Goal;
import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import com.nekiplay.hypixelcry.pathfinder.utils.BlockUtil;
import com.nekiplay.hypixelcry.pathfinder.utils.ExtensionKt;
import com.nekiplay.hypixelcry.pathfinder.utils.RefKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001d\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0003\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0004\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\"R(\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010\u000e\"\u0004\b%\u0010\"R(\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u001f\u001a\u0004\b'\u0010\u000e\"\u0004\b(\u0010\"\u00a8\u0006)"}, d2={"Lcom/nekiplay/hypixelcry/pathfinder/calculate/Path;", "", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "start", "end", "Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "goal", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "ctx", "<init>", "(Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;)V", "", "Lnet/minecraft/class_2338;", "getSmoothedPath", "()Ljava/util/List;", "reconstructPath", "(Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;)Ljava/util/List;", "Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "getGoal", "()Lcom/nekiplay/hypixelcry/pathfinder/goal/Goal;", "Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "getCtx", "()Lcom/nekiplay/hypixelcry/pathfinder/movement/CalculationContext;", "Lnet/minecraft/class_2338;", "getStart", "()Lnet/minecraft/class_2338;", "setStart", "(Lnet/minecraft/class_2338;)V", "getEnd", "setEnd", "path", "Ljava/util/List;", "getPath", "setPath", "(Ljava/util/List;)V", "node", "getNode", "setNode", "smoothPath", "getSmoothPath", "setSmoothPath", "hypixel-cry"})
public final class Path {
    @NotNull
    private final Goal goal;
    @NotNull
    private final CalculationContext ctx;
    @NotNull
    private class_2338 start;
    @NotNull
    private class_2338 end;
    @NotNull
    private List<? extends class_2338> path;
    @NotNull
    private List<PathNode> node;
    @NotNull
    private List<? extends class_2338> smoothPath;

    public Path(@NotNull PathNode start, @NotNull PathNode end, @NotNull Goal goal, @NotNull CalculationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.goal = goal;
        this.ctx = ctx;
        this.start = new class_2338(start.getX(), start.getY(), start.getZ());
        this.end = new class_2338(end.getX(), end.getY(), end.getZ());
        this.smoothPath = CollectionsKt.emptyList();
        LinkedList<class_2338> listOfBlocks = new LinkedList<class_2338>();
        LinkedList<PathNode> listOfNodes = new LinkedList<PathNode>();
        for (PathNode temp = end; temp != null; temp = temp.getParentNode()) {
            listOfNodes.addFirst(temp);
            listOfBlocks.addFirst(new class_2338(temp.getX(), temp.getY(), temp.getZ()));
        }
        this.path = CollectionsKt.toList((Iterable)listOfBlocks);
        this.node = CollectionsKt.toList((Iterable)listOfNodes);
    }

    @NotNull
    public final Goal getGoal() {
        return this.goal;
    }

    @NotNull
    public final CalculationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    public final class_2338 getStart() {
        return this.start;
    }

    public final void setStart(@NotNull class_2338 class_23382) {
        Intrinsics.checkNotNullParameter((Object)class_23382, (String)"<set-?>");
        this.start = class_23382;
    }

    @NotNull
    public final class_2338 getEnd() {
        return this.end;
    }

    public final void setEnd(@NotNull class_2338 class_23382) {
        Intrinsics.checkNotNullParameter((Object)class_23382, (String)"<set-?>");
        this.end = class_23382;
    }

    @NotNull
    public final List<class_2338> getPath() {
        return this.path;
    }

    public final void setPath(@NotNull List<? extends class_2338> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.path = list;
    }

    @NotNull
    public final List<PathNode> getNode() {
        return this.node;
    }

    public final void setNode(@NotNull List<PathNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.node = list;
    }

    @NotNull
    public final List<class_2338> getSmoothPath() {
        return this.smoothPath;
    }

    public final void setSmoothPath(@NotNull List<? extends class_2338> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.smoothPath = list;
    }

    @NotNull
    public final List<class_2338> getSmoothedPath() {
        if (!((Collection)this.smoothPath).isEmpty()) {
            return this.smoothPath;
        }
        LinkedList<class_2338> smooth = new LinkedList<class_2338>();
        if (!((Collection)this.path).isEmpty()) {
            smooth.add(this.path.get(0));
            int currPoint = 0;
            while (currPoint + 1 < this.path.size()) {
                int nextPos = currPoint + 1;
                int n = nextPos;
                int i2 = this.path.size() - 1;
                if (n <= i2) {
                    while (true) {
                        if (BlockUtil.INSTANCE.bresenham(this.ctx, this.path.get(currPoint), this.path.get(i2))) {
                            nextPos = i2;
                            break;
                        }
                        if (i2 == n) break;
                        --i2;
                    }
                }
                smooth.add(this.path.get(nextPos));
                currPoint = nextPos;
            }
        }
        this.smoothPath = CollectionsKt.toList((Iterable)smooth);
        return this.smoothPath;
    }

    @NotNull
    public final List<class_2338> reconstructPath(@NotNull PathNode end) {
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        List path = new ArrayList();
        for (PathNode currentNode = end; currentNode != null; currentNode = currentNode.getParentNode()) {
            path.add(0, currentNode.getBlock());
        }
        List smooth = new ArrayList();
        if (!((Collection)path).isEmpty()) {
            smooth.add(path.get(0));
            int currPoint = 0;
            int maxiters = 2000;
            while (currPoint + 1 < path.size() && maxiters-- > 0) {
                int nextPos = currPoint + 1;
                int n = nextPos;
                int i2 = path.size() - 1;
                if (n <= i2) {
                    while (true) {
                        if (BlockUtil.INSTANCE.bresenham(this.ctx, ExtensionKt.toVec3((class_2338)path.get(currPoint)), ExtensionKt.toVec3((class_2338)path.get(i2)))) {
                            nextPos = i2;
                            break;
                        }
                        if (i2 == n) break;
                        --i2;
                    }
                }
                smooth.add(path.get(nextPos));
                currPoint = nextPos;
            }
        }
        smooth.removeIf(arg_0 -> Path.reconstructPath$lambda$1(Path::reconstructPath$lambda$0, arg_0));
        return smooth;
    }

    private static final boolean reconstructPath$lambda$0(class_2338 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        class_638 class_6382 = RefKt.getWorld();
        return Intrinsics.areEqual(class_6382 != null && (class_6382 = class_6382.method_8320(it)) != null ? class_6382.method_26204() : null, (Object)class_2246.field_10124);
    }

    private static final boolean reconstructPath$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

