/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.gui.component;

import io.github.notenoughupdates.moulconfig.gui.GuiComponent;
import io.github.notenoughupdates.moulconfig.gui.GuiImmediateContext;
import io.github.notenoughupdates.moulconfig.gui.KeyboardEvent;
import io.github.notenoughupdates.moulconfig.gui.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class ColumnComponent
extends GuiComponent {
    final List<GuiComponent> children;

    public ColumnComponent(List<GuiComponent> children) {
        this.children = children;
    }

    public ColumnComponent(GuiComponent ... children) {
        this(Arrays.asList(children));
    }

    @Override
    public int getWidth() {
        return this.foldChildren(0, (child, width) -> Math.max(child.getWidth(), width));
    }

    @Override
    public int getHeight() {
        return this.foldChildren(0, (child, height) -> child.getHeight() + height);
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        for (GuiComponent child : this.children) {
            initial = visitor.apply(child, (GuiComponent)initial);
        }
        return initial;
    }

    public void foldWithContext(GuiImmediateContext context, BiConsumer<GuiComponent, GuiImmediateContext> visitor) {
        int width = context.getWidth();
        this.foldChildren(0, (child, position) -> {
            visitor.accept((GuiComponent)child, context.translated(0, (int)position, width, child.getHeight()));
            return child.getHeight() + position;
        });
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        this.foldWithContext(context, (child, childContext) -> {
            child.render((GuiImmediateContext)childContext);
            context.getRenderContext().translate(0.0f, child.getHeight());
        });
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.mouseEvent(mouseEvent, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.keyboardEvent(event, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    public String toString() {
        return "ColumnComponent(children=" + this.children + ")";
    }
}

