/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.utils.Rotations;
import com.nekiplay.hypixelcry.utils.helper.Ease;
import net.minecraft.class_1297;
import net.minecraft.class_243;

public class SmoothRotator {
    private boolean isRotating = false;
    private Thread rotationThread;
    private Runnable callback;
    public static SmoothRotator INSTANCE;

    public static SmoothRotator getInstance() {
        return INSTANCE;
    }

    public void smoothLook(double targetYaw, double targetPitch, long duration, Ease easing, boolean clientSide, Runnable callback) {
        if (this.isRotating) {
            this.stop();
        }
        this.isRotating = true;
        this.callback = callback;
        double startYaw = Rotations.serverYaw;
        double startPitch = Rotations.serverPitch;
        this.rotationThread = new Thread(() -> {
            try {
                long startTime = System.currentTimeMillis();
                long elapsedTime = 0L;
                while (elapsedTime < duration && this.isRotating) {
                    double progress = easing.invoke((float)elapsedTime / (float)duration);
                    double currentYaw = startYaw + (targetYaw - startYaw) * progress;
                    double currentPitch = startPitch + (targetPitch - startPitch) * progress;
                    Rotations.setCamRotation(currentYaw, currentPitch);
                    Rotations.rotate(currentYaw, currentPitch);
                    Thread.sleep(1L);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.isRotating) {
                    Rotations.setCamRotation(targetYaw, targetPitch);
                    Rotations.rotate(targetYaw, targetPitch, 1, clientSide, null);
                    if (this.callback != null) {
                        this.callback.run();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.isRotating = false;
            }
        });
        this.rotationThread.start();
    }

    public void smoothLook(double targetYaw, double targetPitch, long duration, boolean clientSide) {
        this.smoothLook(targetYaw, targetPitch, duration, Ease.EASE_OUT_QUAD, clientSide, null);
    }

    public void smoothLookToEntity(class_1297 entity, long duration, Ease easing, boolean clientSide, Runnable callback) {
        double yaw = Rotations.getYaw(entity);
        double pitch = Rotations.getPitch(entity);
        this.smoothLook(yaw, pitch, duration, easing, clientSide, callback);
    }

    public void smoothLookToPos(class_243 pos, long duration, Ease easing, boolean clientSide, Runnable callback) {
        double yaw = Rotations.getYaw(pos);
        double pitch = Rotations.getPitch(pos);
        this.smoothLook(yaw, pitch, duration, easing, clientSide, callback);
    }

    public boolean isRotating() {
        return this.isRotating;
    }

    public void stop() {
        this.isRotating = false;
        if (this.rotationThread != null && this.rotationThread.isAlive()) {
            this.rotationThread.interrupt();
        }
    }
}

