/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.common;

import io.github.notenoughupdates.moulconfig.common.ClickType;
import io.github.notenoughupdates.moulconfig.common.DynamicTextureReference;
import io.github.notenoughupdates.moulconfig.common.IFontRenderer;
import io.github.notenoughupdates.moulconfig.common.IKeyboardConstants;
import io.github.notenoughupdates.moulconfig.common.MyResourceLocation;
import io.github.notenoughupdates.moulconfig.common.RenderContext;
import io.github.notenoughupdates.moulconfig.common.text.StructuredText;
import io.github.notenoughupdates.moulconfig.gui.GuiComponent;
import io.github.notenoughupdates.moulconfig.gui.GuiContext;
import io.github.notenoughupdates.moulconfig.gui.GuiElement;
import io.github.notenoughupdates.moulconfig.gui.GuiElementComponent;
import io.github.notenoughupdates.moulconfig.internal.InitUtil;
import io.github.notenoughupdates.moulconfig.internal.MCLogger;
import io.github.notenoughupdates.moulconfig.internal.Warnings;
import io.github.notenoughupdates.moulconfig.processor.MoulConfigProcessor;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface IMinecraft {
    public static final IMinecraft INSTANCE = InitUtil.makeUnchecked(() -> {
        ServiceLoader<IMinecraft> serviceLoader = ServiceLoader.load(IMinecraft.class);
        serviceLoader.reload();
        Iterator<IMinecraft> iterator = serviceLoader.iterator();
        IMinecraft instance = iterator.next();
        if (iterator.hasNext()) {
            IMinecraft duplicate = iterator.next();
            Warnings.warn("Duplicate IMinecraft class " + duplicate + ", " + instance);
        }
        return instance;
    });

    public InputStream loadResourceLocation(MyResourceLocation var1);

    public MCLogger getLogger(String var1);

    public boolean isGeneratedSentinel(MyResourceLocation var1);

    public DynamicTextureReference generateDynamicTexture(BufferedImage var1);

    public Pair<Double, Double> getMousePositionHF();

    default public Pair<Integer, Integer> getMousePosition() {
        Pair<Double, Double> mousePositionHF = this.getMousePositionHF();
        return new Pair((Object)((Double)mousePositionHF.getFirst()).intValue(), (Object)((Double)mousePositionHF.getSecond()).intValue());
    }

    default public int getMouseX() {
        return (int)this.getMouseXHF();
    }

    default public int getMouseY() {
        return (int)this.getMouseYHF();
    }

    default public double getMouseXHF() {
        return (Double)this.getMousePositionHF().getFirst();
    }

    default public double getMouseYHF() {
        return (Double)this.getMousePositionHF().getSecond();
    }

    public boolean isDevelopmentEnvironment();

    public IFontRenderer getDefaultFontRenderer();

    public IKeyboardConstants getKeyboardConstants();

    public int getScaledWidth();

    public int getScaledHeight();

    public int getScaleFactor();

    public boolean isOnMacOs();

    public boolean isMouseButtonDown(int var1);

    public boolean isKeyboardKeyDown(int var1);

    public void addExtraBuiltinConfigProcessors(MoulConfigProcessor<?> var1);

    public void sendClickableChatMessage(StructuredText var1, String var2, @Nullable ClickType var3);

    default public void sendChatMessage(StructuredText message) {
        this.sendClickableChatMessage(message, "", null);
    }

    public StructuredText getKeyName(int var1);

    public StructuredText.Mutable createLiteral(String var1);

    public StructuredText.Mutable createTranslatable(String var1, StructuredText ... var2);

    @ApiStatus.Internal
    public @Nullable StructuredText createStructuredTextInternal(Object var1);

    @Deprecated
    public RenderContext provideTopLevelRenderContext();

    default public void openWrappedScreen(GuiElement guiElement) {
        this.openWrappedScreen(new GuiElementComponent(guiElement));
    }

    public void openWrappedScreen(GuiContext var1);

    default public void openWrappedScreen(GuiComponent component) {
        this.openWrappedScreen(new GuiContext(component));
    }

    public void copyToClipboard(String var1);

    public String copyFromClipboard();

    public static IMinecraft getInstance() {
        return INSTANCE;
    }
}

