/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.utils.ItemUtils;
import com.nekiplay.hypixelcry.utils.Location;
import com.nekiplay.hypixelcry.utils.RegexUtils;
import com.nekiplay.hypixelcry.utils.Utils;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class StatusBarTracker {
    private static final Pattern STATUS_HEALTH = Pattern.compile("\u00a7[6c](?<health>[\\d,]+)/(?<max>[\\d,]+)\u2764 *(?<healing>\\+\u00a7c([\\d,]+). *)?");
    private static final Pattern DEFENSE_STATUS = Pattern.compile("\u00a7a(?<defense>[\\d,]+)\u00a7a\u2748 Defense *");
    private static final Pattern MANA_USE = Pattern.compile("\u00a7b-([\\d,]+) Mana \\(\u00a7.*?\\) *");
    private static final Pattern MANA_STATUS = Pattern.compile("\u00a7b(?<mana>[\\d,]+)/(?<max>[\\d,]+)\u270e (?:Mana|\u00a73(?<overflow>[\\d,]+)\u02ac) *");
    private static final class_310 client = class_310.method_1551();
    private static Resource health = new Resource(100, 100, 0);
    private static Resource mana = new Resource(100, 100, 0);
    private static Resource speed = new Resource(100, 400, 0);
    private static Resource air = new Resource(100, 300, 0);
    private static int defense = 0;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(StatusBarTracker::allowOverlayMessage);
        ClientReceiveMessageEvents.MODIFY_GAME.register(StatusBarTracker::onOverlayMessage);
        Scheduler.INSTANCE.scheduleCyclic(StatusBarTracker::tick, 1);
    }

    public static Resource getHealth() {
        return health;
    }

    public static Resource getMana() {
        return mana;
    }

    public static int getDefense() {
        return defense;
    }

    public static Resource getSpeed() {
        return speed;
    }

    public static Resource getAir() {
        return air;
    }

    private static void tick() {
        if (client == null || StatusBarTracker.client.field_1724 == null) {
            return;
        }
        StatusBarTracker.updateHealth(StatusBarTracker.health.value, StatusBarTracker.health.max, StatusBarTracker.health.overflow);
        StatusBarTracker.updateSpeed();
        StatusBarTracker.updateAir();
    }

    private static boolean allowOverlayMessage(class_2561 text2, boolean overlay) {
        StatusBarTracker.onOverlayMessage(text2, overlay);
        return true;
    }

    private static class_2561 onOverlayMessage(class_2561 text2, boolean overlay) {
        if (!overlay || !Utils.isOnSkyblock() || Utils.isInTheRift()) {
            return text2;
        }
        StatusBarTracker.update(text2.getString(), false);
        return class_2561.method_30163((String)StatusBarTracker.update(text2.getString(), false));
    }

    public static String update(String actionBar, boolean filterManaUse) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = STATUS_HEALTH.matcher(actionBar);
        if (!matcher.find()) {
            return actionBar;
        }
        StatusBarTracker.updateHealth(matcher);
        if (matcher.group("healing") != null) {
            sb.append("\u00a7c\u2764");
        }
        matcher.appendReplacement(sb, "$3");
        if (matcher.usePattern(DEFENSE_STATUS).find()) {
            defense = RegexUtils.parseIntFromMatcher(matcher, "defense");
            matcher.appendReplacement(sb, "");
        } else if (filterManaUse && matcher.usePattern(MANA_USE).find()) {
            matcher.appendReplacement(sb, "");
        }
        if (matcher.usePattern(MANA_STATUS).find()) {
            StatusBarTracker.updateMana(matcher);
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        String res = sb.toString().trim();
        return res.isEmpty() ? null : res;
    }

    private static void updateHealth(Matcher matcher) {
        int health = RegexUtils.parseIntFromMatcher(matcher, "health");
        int max2 = RegexUtils.parseIntFromMatcher(matcher, "max");
        StatusBarTracker.updateHealth(health, max2, Math.max(0, health - max2));
    }

    private static void updateHealth(int value, int max2, int overflow) {
        if (client != null && StatusBarTracker.client.field_1724 != null) {
            value = (int)(StatusBarTracker.client.field_1724.method_6032() * (float)max2 / StatusBarTracker.client.field_1724.method_6063());
            overflow = (int)(StatusBarTracker.client.field_1724.method_6067() * (float)max2 / StatusBarTracker.client.field_1724.method_6063());
        }
        health = new Resource(Math.min(value, max2), max2, Math.min(overflow, max2));
    }

    private static void updateMana(Matcher m) {
        int mana = RegexUtils.parseIntFromMatcher(m, "mana");
        int max2 = RegexUtils.parseIntFromMatcher(m, "max");
        int overflow = m.group("overflow") == null ? 0 : RegexUtils.parseIntFromMatcher(m, "overflow");
        StatusBarTracker.mana = new Resource(mana, max2, overflow);
    }

    private static void updateSpeed() {
        assert (StatusBarTracker.client.field_1724 != null);
        int value = (int)(StatusBarTracker.client.field_1724.method_5624() ? StatusBarTracker.client.field_1724.method_6029() / 1.3f * 1000.0f : StatusBarTracker.client.field_1724.method_6029() * 1000.0f);
        int max2 = 400;
        if (StatusBarTracker.client.field_1724.method_6047().method_7964().getString().contains("Cactus Knife") && Utils.getLocation() == Location.GARDEN) {
            max2 = 500;
        }
        List<class_1799> armor = ItemUtils.getArmor((class_1309)StatusBarTracker.client.field_1724);
        int youngDragCount = 0;
        for (class_1799 armorPiece : armor) {
            if (armorPiece.method_7964().getString().contains("Racing Helmet")) {
                max2 = 500;
                continue;
            }
            if (!armorPiece.method_7964().getString().contains("Young Dragon")) continue;
            ++youngDragCount;
        }
        if (youngDragCount == 4) {
            max2 = 500;
        }
        speed = new Resource(value, max2, 0);
    }

    private static void updateAir() {
        assert (StatusBarTracker.client.field_1724 != null);
        int max2 = StatusBarTracker.client.field_1724.method_5748();
        int value = Math.clamp((long)StatusBarTracker.client.field_1724.method_5669(), 0, max2);
        air = new Resource(value, max2, 0);
    }

    public record Resource(int value, int max, int overflow) {
    }
}

