/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.config.neupages;

import com.google.gson.annotations.Expose;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickBlocks;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickOpenFeatures;
import io.github.notenoughupdates.moulconfig.annotations.Accordion;
import io.github.notenoughupdates.moulconfig.annotations.Category;
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorBoolean;
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorDraggableList;
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorKeybind;
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorSlider;
import io.github.notenoughupdates.moulconfig.annotations.ConfigOption;
import java.util.ArrayList;
import java.util.List;

public class Macros {
    @Accordion
    @ConfigOption(name="Auto RightClick", desc="Auto click to selected blocks")
    @Expose
    public AutoRightClick autoRightClick = new AutoRightClick();
    @Accordion
    @ConfigOption(name="Ghost Blocks", desc="Set looking blocks to air")
    @Expose
    public Ghost_Blocks ghostBlocks = new Ghost_Blocks();
    @Category(name="Dungeons", desc="Macros in dungeons")
    @Expose
    public Dungeons dungeons = new Dungeons();
    @Category(name="Items", desc="")
    @Expose
    public Items items = new Items();

    public static class AutoRightClick {
        @ConfigOption(name="Enabled", desc="Enable Auto RightClick?")
        @ConfigEditorBoolean
        @Expose
        public boolean enabled = false;
        @ConfigOption(name="Blocks", desc="Click for blocks")
        @ConfigEditorDraggableList(requireNonEmpty=false)
        @Expose
        public List<AutoRightClickBlocks> blocks = new ArrayList<AutoRightClickBlocks>(){
            {
                this.add(AutoRightClickBlocks.Chest);
                this.add(AutoRightClickBlocks.Lever);
            }
        };
        @ConfigOption(name="Features", desc="Additional features")
        @ConfigEditorDraggableList(requireNonEmpty=false)
        @Expose
        public List<AutoRightClickOpenFeatures> features = new ArrayList<AutoRightClickOpenFeatures>(){
            {
                this.add(AutoRightClickOpenFeatures.Air);
                this.add(AutoRightClickOpenFeatures.GhostHand);
            }
        };
        @ConfigOption(name="Range", desc="GhostHand Raycast range")
        @ConfigEditorSlider(minValue=2.0f, maxValue=5.5f, minStep=0.25f)
        @Expose
        public float range = 4.5f;
    }

    public static class Ghost_Blocks {
        @ConfigOption(name="Key binding", desc="Activation key bind")
        @ConfigEditorKeybind(defaultKey=-1)
        @Expose
        public int ghostBlocksKeyBind = -1;
        @ConfigOption(name="Range", desc="Raycast range")
        @ConfigEditorSlider(minValue=2.0f, maxValue=32.0f, minStep=1.0f)
        @Expose
        public int range = 8;
    }

    public static class Dungeons {
        @Accordion
        @ConfigOption(name="Auto chest close", desc="Auto close dungeon chests")
        @Expose
        public Auto_Close_Chests autoCloseChests = new Auto_Close_Chests();

        public static class Auto_Close_Chests {
            @ConfigOption(name="Auto close chests", desc="Auto close dungeon chests?")
            @ConfigEditorBoolean
            @Expose
            public boolean enable = true;
        }
    }

    public static class Items {
        @Accordion
        @ConfigOption(name="Aspect Of The Teleports", desc="")
        @Expose
        public Aspect_Of_The_Teleports aspectOfTheTeleports = new Aspect_Of_The_Teleports();
        @Accordion
        @ConfigOption(name="Healing Wands", desc="")
        @Expose
        public Healing_Wands healingWands = new Healing_Wands();
        @Accordion
        @ConfigOption(name="Wither Cloak", desc="")
        @Expose
        public Wither_Cloak witherCloak = new Wither_Cloak();
        @Accordion
        @ConfigOption(name="Zombie Sword", desc="")
        @Expose
        public Zombie_Sword zombieSword = new Zombie_Sword();
        @Accordion
        @ConfigOption(name="Rogue Sword", desc="")
        @Expose
        public Rogue_Sword rogueSword = new Rogue_Sword();

        public static class Aspect_Of_The_Teleports {
            @ConfigOption(name="Key binding", desc="Activation key bind")
            @ConfigEditorKeybind(defaultKey=-1)
            @Expose
            public int keybind = -1;
            @ConfigOption(name="Delay", desc="Repeat delay")
            @ConfigEditorSlider(minValue=0.0f, maxValue=10.0f, minStep=1.0f)
            @Expose
            public int delay = 2;
        }

        public static class Healing_Wands {
            @ConfigOption(name="Key binding", desc="Activation key bind")
            @ConfigEditorKeybind(defaultKey=-1)
            @Expose
            public int keybind = -1;
        }

        public static class Wither_Cloak {
            @ConfigOption(name="Key binding", desc="Activation key bind")
            @ConfigEditorKeybind(defaultKey=-1)
            @Expose
            public int keybind = -1;
        }

        public static class Zombie_Sword {
            @ConfigOption(name="Key binding", desc="Activation key bind")
            @ConfigEditorKeybind(defaultKey=-1)
            @Expose
            public int keybind = -1;
        }

        public static class Rogue_Sword {
            @ConfigOption(name="Key binding", desc="Activation key bind")
            @ConfigEditorKeybind(defaultKey=-1)
            @Expose
            public int keybind = -1;
        }
    }
}

