/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.platform;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.github.notenoughupdates.moulconfig.common.IFontRenderer;
import io.github.notenoughupdates.moulconfig.common.IItemStack;
import io.github.notenoughupdates.moulconfig.common.Layer;
import io.github.notenoughupdates.moulconfig.common.MyResourceLocation;
import io.github.notenoughupdates.moulconfig.common.RenderContext;
import io.github.notenoughupdates.moulconfig.common.TextureFilter;
import io.github.notenoughupdates.moulconfig.common.text.StructuredText;
import io.github.notenoughupdates.moulconfig.internal.FilterAssertionCache;
import io.github.notenoughupdates.moulconfig.internal.Rect;
import io.github.notenoughupdates.moulconfig.internal.Warnings;
import io.github.notenoughupdates.moulconfig.platform.MoulConfigPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class MoulConfigRenderContext
implements RenderContext {
    final class_332 drawContext;
    class_310 mc = class_310.method_1551();
    NavigableMap<Layer, List<DrawAction>> queuedLayers = new TreeMap<Layer, List<DrawAction>>();

    public MoulConfigRenderContext(class_332 drawContext) {
        this.drawContext = drawContext;
    }

    public Matrix3x2fStack getMatrices() {
        return this.drawContext.method_51448();
    }

    @Override
    public void pushMatrix() {
        this.getMatrices().pushMatrix();
    }

    @Override
    public void popMatrix() {
        this.getMatrices().popMatrix();
    }

    @Override
    public void translate(float x, float y) {
        this.getMatrices().translate(x, y);
    }

    @Override
    public void scale(float x, float y) {
        this.getMatrices().scale(x, y);
    }

    @Override
    public void drawOnTop(Layer layer, RenderContext.ScissorBehaviour escapeScissors, Consumer<RenderContext> later) {
        List queuedActions = this.queuedLayers.computeIfAbsent(layer, ignored -> new ArrayList());
        queuedActions.add(new DrawAction(later, switch (escapeScissors) {
            default -> throw new MatchException(null, null);
            case RenderContext.ScissorBehaviour.ESCAPE -> null;
            case RenderContext.ScissorBehaviour.INHERIT -> this.drawContext.field_44659.method_70863();
        }, new Matrix3x2f((Matrix3x2fc)this.getMatrices())));
    }

    @Override
    public void drawColouredQuads(final int color, final float ... coordinates) {
        assert (coordinates.length % 8 == 0);
        Rect rect = Rect.ofDot((int)coordinates[0], (int)coordinates[1]);
        for (int i2 = 0; i2 < coordinates.length; i2 += 2) {
            rect = rect.includePoint((int)coordinates[i2], (int)coordinates[i2 + 1]);
        }
        final class_8030 scissors = this.drawContext.field_44659.method_70863();
        final Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)this.getMatrices());
        class_8030 bounds = new class_8030(rect.getX(), rect.getY(), rect.getW(), rect.getH());
        bounds = bounds.method_65185(matrix);
        if (scissors != null) {
            bounds = bounds.method_49701(scissors);
        }
        if (bounds == null) {
            return;
        }
        final class_8030 finalBounds = bounds;
        this.drawContext.field_59826.method_70919(new class_11244(){

            public void method_70917(class_4588 vertices, float depth) {
                for (int i2 = 0; i2 < coordinates.length; i2 += 2) {
                    vertices.method_70815(matrix, coordinates[i2], coordinates[i2 + 1], depth).method_39415(color);
                }
            }

            public RenderPipeline comp_4055() {
                return class_10799.field_56879;
            }

            public class_11231 comp_4056() {
                return class_11231.method_70899();
            }

            public @Nullable class_8030 comp_4069() {
                return scissors;
            }

            public class_8030 comp_4274() {
                return finalBounds;
            }
        });
    }

    @Override
    public void drawString(IFontRenderer fontRenderer, StructuredText text, int x, int y, int color, boolean shadow) {
        this.drawContext.method_51439(MoulConfigPlatform.unwrap(fontRenderer), MoulConfigPlatform.unwrap(text), x, y, color | 0xFF000000, shadow);
    }

    @Override
    public void drawColoredRect(float left, float top, float right, float bottom, int color) {
        this.drawContext.method_25294((int)left, (int)top, (int)right, (int)bottom, color);
    }

    @Override
    public void invertedRect(float left, float top, float right, float bottom, int additiveColor) {
        int leftI = (int)left;
        int topI = (int)top;
        int rightI = (int)right;
        int bottomI = (int)bottom;
        this.drawContext.method_70848(class_10799.field_61068, class_11231.method_70899(), leftI, topI, rightI, bottomI, 0, Integer.valueOf(-1));
        this.drawContext.method_70848(class_10799.field_56881, class_11231.method_70899(), leftI, topI, rightI, bottomI, 0, Integer.valueOf(additiveColor));
    }

    @Override
    public void drawTexturedTintedRect(MyResourceLocation texture, float x, float y, float width, float height, float u1, float v1, float u2, float v2, int color, TextureFilter filter) {
        FilterAssertionCache.assertTextureFilter(texture, filter);
        class_2960 identifier = MoulConfigPlatform.unwrap(texture);
        class_1044 class_10442 = this.mc.method_1531().method_4619(identifier);
        class_10442.method_4527(switch (filter) {
            default -> throw new MatchException(null, null);
            case TextureFilter.LINEAR -> true;
            case TextureFilter.NEAREST -> false;
        }, false);
        this.drawContext.method_25295(class_10799.field_56883, identifier, (int)x, (int)(x + width), (int)y, (int)(y + height), u1, u2, v1, v2, color);
    }

    @Override
    public void drawDarkRect(int x, int y, int width, int height, boolean shadow) {
        int body = -14671834;
        int light = -13619146;
        int dark = -15724522;
        this.drawContext.method_25294(x, y, x + 1, y + height, light);
        this.drawContext.method_25294(x + 1, y, x + width, y + 1, light);
        this.drawContext.method_25294(x + width - 1, y + 1, x + width, y + height, dark);
        this.drawContext.method_25294(x + 1, y + height - 1, x + width - 1, y + height, dark);
        this.drawContext.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, body);
        if (shadow) {
            this.drawContext.method_25294(x + width, y + 2, x + width + 2, y + height + 2, 0x70000000);
            this.drawContext.method_25294(x + 2, y + height, x + width, y + height + 2, 0x70000000);
        }
    }

    @Override
    public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        this.drawContext.method_25296(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public void pushScissor(int left, int top, int right, int bottom) {
        this.drawContext.method_44379(left, top, right, bottom);
    }

    @Override
    public void pushRawScissor(int left, int top, int right, int bottom) {
        this.drawContext.field_44659.field_43099.addLast(new class_8030(left, top, right, bottom));
    }

    @Override
    public void popScissor() {
        this.drawContext.method_44380();
    }

    @Override
    public void assertNoScissors() {
        if (!this.drawContext.field_44659.field_43099.isEmpty()) {
            Warnings.warn("Scissors found despite no scissor assertion", 4);
        }
    }

    @Override
    @Deprecated
    public void clearScissor() {
        this.drawContext.field_44659.field_43099.clear();
    }

    @Override
    public void renderItemStack(IItemStack itemStack, int x, int y, @Nullable StructuredText overlayText) {
        class_1799 item = MoulConfigPlatform.unwrap(itemStack);
        this.drawContext.method_51427(item, x, y);
        if (overlayText != null) {
            this.drawContext.method_51432(this.mc.field_1772, item, x, y, overlayText.getText());
        }
    }

    @Override
    public void drawTooltipNow(int x, int y, List<StructuredText> tooltipLines) {
        List<class_5684> lines = tooltipLines.stream().map(MoulConfigPlatform::unwrap).map(arg_0 -> ((class_2477)class_2477.method_10517()).method_30934(arg_0)).map(class_5684::method_32662).toList();
        this.drawContext.method_51435(this.mc.field_1772, lines, x, y, class_8001.field_41687, null);
    }

    @Override
    public void renderExtraLayers() {
        Map.Entry<Layer, List<DrawAction>> nextLayer;
        Layer currentLayer = Layer.ROOT;
        while ((nextLayer = this.queuedLayers.ceilingEntry(currentLayer.next())) != null) {
            currentLayer = nextLayer.getKey();
            List<DrawAction> draws = nextLayer.getValue();
            for (DrawAction draw : draws) {
                if (!this.drawContext.field_44659.field_43099.isEmpty()) {
                    Warnings.warn("Scissors found despite no scissor assertion", 4);
                }
                if (draw.scissorTop != null) {
                    this.pushRawScissor(draw.scissorTop.method_49620(), draw.scissorTop.method_49618(), draw.scissorTop.method_49621(), draw.scissorTop.method_49619());
                }
                this.pushMatrix();
                this.getMatrices().set((Matrix3x2fc)draw.transform);
                draw.action.accept(this);
                this.popMatrix();
                if (this.drawContext.field_44659.field_43099.isEmpty()) continue;
                Warnings.warn("Scissors found despite no scissor assertion after execution of " + String.valueOf(draw.action), 4);
            }
        }
    }

    public class_332 getDrawContext() {
        return this.drawContext;
    }

    static final class DrawAction {
        private final Consumer<RenderContext> action;
        private final @Nullable class_8030 scissorTop;
        private final Matrix3x2f transform;

        public DrawAction(Consumer<RenderContext> action, @Nullable class_8030 scissorTop, Matrix3x2f transform) {
            this.action = action;
            this.scissorTop = scissorTop;
            this.transform = transform;
        }

        public Consumer<RenderContext> getAction() {
            return this.action;
        }

        public @Nullable class_8030 getScissorTop() {
            return this.scissorTop;
        }

        public Matrix3x2f getTransform() {
            return this.transform;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DrawAction)) {
                return false;
            }
            DrawAction other = (DrawAction)o;
            Consumer<RenderContext> this$action = this.getAction();
            Consumer<RenderContext> other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            class_8030 this$scissorTop = this.getScissorTop();
            class_8030 other$scissorTop = other.getScissorTop();
            if (this$scissorTop == null ? other$scissorTop != null : !this$scissorTop.equals(other$scissorTop)) {
                return false;
            }
            Matrix3x2f this$transform = this.getTransform();
            Matrix3x2f other$transform = other.getTransform();
            return !(this$transform == null ? other$transform != null : !this$transform.equals(other$transform));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<RenderContext> $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            class_8030 $scissorTop = this.getScissorTop();
            result = result * 59 + ($scissorTop == null ? 43 : $scissorTop.hashCode());
            Matrix3x2f $transform = this.getTransform();
            result = result * 59 + ($transform == null ? 43 : $transform.hashCode());
            return result;
        }

        public String toString() {
            return "MoulConfigRenderContext.DrawAction(action=" + String.valueOf(this.getAction()) + ", scissorTop=" + String.valueOf(this.getScissorTop()) + ", transform=" + String.valueOf(this.getTransform()) + ")";
        }
    }
}

