/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import java.util.List;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.ParList;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.Variable;
import org.luaj.vm2.ast.Visitor;

public class NameResolver
extends Visitor {
    private NameScope scope = null;

    private void pushScope() {
        this.scope = new NameScope(this.scope);
    }

    private void popScope() {
        this.scope = this.scope.outerScope;
    }

    public void visit(NameScope nameScope) {
    }

    public void visit(Block block) {
        this.pushScope();
        block.scope = this.scope;
        super.visit(block);
        this.popScope();
    }

    public void visit(FuncBody funcBody) {
        this.pushScope();
        ++this.scope.functionNestingCount;
        funcBody.scope = this.scope;
        super.visit(funcBody);
        this.popScope();
    }

    public void visit(Stat.LocalFuncDef localFuncDef) {
        this.defineLocalVar(localFuncDef.name);
        super.visit(localFuncDef);
    }

    public void visit(Stat.NumericFor numericFor) {
        this.pushScope();
        numericFor.scope = this.scope;
        this.defineLocalVar(numericFor.name);
        super.visit(numericFor);
        this.popScope();
    }

    public void visit(Stat.GenericFor genericFor) {
        this.pushScope();
        genericFor.scope = this.scope;
        this.defineLocalVars(genericFor.names);
        super.visit(genericFor);
        this.popScope();
    }

    public void visit(Exp.NameExp nameExp) {
        nameExp.name.variable = this.resolveNameReference(nameExp.name);
        super.visit(nameExp);
    }

    public void visit(Stat.FuncDef funcDef) {
        funcDef.name.name.variable = this.resolveNameReference(funcDef.name.name);
        funcDef.name.name.variable.hasassignments = true;
        super.visit(funcDef);
    }

    public void visit(Stat.Assign assign) {
        super.visit(assign);
        int n = assign.vars.size();
        for (int j = 0; j < n; ++j) {
            Exp.VarExp varExp = (Exp.VarExp)assign.vars.get(j);
            varExp.markHasAssignment();
        }
    }

    public void visit(Stat.LocalAssign localAssign) {
        int n;
        this.visitExps(localAssign.values);
        this.defineLocalVars(localAssign.names);
        int n2 = localAssign.names.size();
        int n3 = localAssign.values != null ? localAssign.values.size() : 0;
        boolean bl = n3 > 0 && n3 < n2 && ((Exp)localAssign.values.get(n3 - 1)).isvarargexp();
        for (n = 0; n < n2 && n < (bl ? n3 - 1 : n3); ++n) {
            if (!(localAssign.values.get(n) instanceof Exp.Constant)) continue;
            ((Name)localAssign.names.get((int)n)).variable.initialValue = ((Exp.Constant)localAssign.values.get((int)n)).value;
        }
        if (!bl) {
            for (n = n3; n < n2; ++n) {
                ((Name)localAssign.names.get((int)n)).variable.initialValue = LuaValue.NIL;
            }
        }
    }

    public void visit(ParList parList) {
        if (parList.names != null) {
            this.defineLocalVars(parList.names);
        }
        if (parList.isvararg) {
            this.scope.define("arg");
        }
        super.visit(parList);
    }

    protected void defineLocalVars(List list) {
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            this.defineLocalVar((Name)list.get(j));
        }
    }

    protected void defineLocalVar(Name name) {
        name.variable = this.scope.define(name.name);
    }

    protected Variable resolveNameReference(Name name) {
        Variable variable = this.scope.find(name.name);
        if (variable.isLocal() && this.scope.functionNestingCount != variable.definingScope.functionNestingCount) {
            variable.isupvalue = true;
        }
        return variable;
    }
}

