/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickBlocks;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickOpenFeatures;
import com.nekiplay.hypixelcry.events.SkyblockEvents;
import com.nekiplay.hypixelcry.events.world.BlockUpdateEvent;
import com.nekiplay.hypixelcry.utils.Location;
import com.nekiplay.hypixelcry.utils.PlayerUtils;
import com.nekiplay.hypixelcry.utils.RaycastUtils;
import com.nekiplay.hypixelcry.utils.Utils;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

public class AutoRightClick {
    private static final Map<class_2338, Integer> openedChests = new LinkedHashMap<class_2338, Integer>();
    private static int tickCounter = 0;
    private static final int CHEST_COOLDOWN = 100;
    private static final int MAX_REMOVALS_PER_TICK = 20;

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(AutoRightClick::onTick, 1);
        BlockUpdateEvent.EVENT.register(AutoRightClick::onBlockUpdate);
        SkyblockEvents.LOCATION_CHANGE.register(AutoRightClick::handleLocationChange);
    }

    private static boolean shouldSkipTick() {
        return HypixelCry.mc.field_1687 == null || HypixelCry.mc.field_1724 == null || !HypixelCry.config.macros.autoRightClick.enabled;
    }

    private static void handleLocationChange(Location location) {
        openedChests.clear();
    }

    private static class_1269 onBlockUpdate(BlockUpdateEvent event) {
        List<class_2248> selectedBlocks = AutoRightClick.getAllowedBlocks();
        if (openedChests.containsKey(event.getBlockPos()) && selectedBlocks.contains(event.getNew().method_26204())) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static void onTick() {
        if (AutoRightClick.shouldSkipTick()) {
            return;
        }
        if (++tickCounter % 20 == 0) {
            AutoRightClick.cleanUpOldChests();
            if (openedChests.isEmpty()) {
                tickCounter = 0;
            }
        }
        if (HypixelCry.mc.field_1755 == null) {
            AutoRightClick.handleChestOpening();
        }
    }

    private static void cleanUpOldChests() {
        Iterator<Map.Entry<class_2338, Integer>> iterator = openedChests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, Integer> entry = iterator.next();
            if (entry.getValue() >= 100) {
                iterator.remove();
                continue;
            }
            entry.setValue(entry.getValue() + 1);
        }
    }

    private static List<class_2248> getAllowedBlocks() {
        ArrayList<class_2248> selectedBlocks = new ArrayList<class_2248>();
        List<AutoRightClickBlocks> blocks = HypixelCry.config.macros.autoRightClick.blocks;
        if (blocks.contains((Object)AutoRightClickBlocks.Chest)) {
            selectedBlocks.add(class_2246.field_10034);
            selectedBlocks.add(class_2246.field_10380);
        }
        if (blocks.contains((Object)AutoRightClickBlocks.Lever)) {
            selectedBlocks.add(class_2246.field_10363);
        }
        if (blocks.contains((Object)AutoRightClickBlocks.Skull)) {
            selectedBlocks.add(class_2246.field_10432);
            selectedBlocks.add(class_2246.field_10208);
            selectedBlocks.add(class_2246.field_10177);
            selectedBlocks.add(class_2246.field_10101);
            selectedBlocks.add(class_2246.field_10481);
            selectedBlocks.add(class_2246.field_10388);
            selectedBlocks.add(class_2246.field_10042);
            selectedBlocks.add(class_2246.field_10509);
            selectedBlocks.add(class_2246.field_10241);
            selectedBlocks.add(class_2246.field_10581);
        }
        return selectedBlocks;
    }

    private static void handleChestOpening() {
        class_239 class_2392;
        boolean ghostHand = HypixelCry.config.macros.autoRightClick.features.contains((Object)AutoRightClickOpenFeatures.GhostHand);
        List<class_2248> selectedBlocks = AutoRightClick.getAllowedBlocks();
        if (selectedBlocks.isEmpty()) {
            return;
        }
        if (ghostHand) {
            class_239 mouseOver = RaycastUtils.rayTraceToBlocks(PlayerUtils.getEyePosition(), PlayerUtils.getLookEndPos(HypixelCry.config.macros.autoRightClick.range), selectedBlocks);
            if (mouseOver instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)mouseOver;
                AutoRightClick.tryOpenChest(blockHitResult);
            }
        } else if (AutoRightClick.isLookingAt(selectedBlocks) && (class_2392 = HypixelCry.mc.field_1765) instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            AutoRightClick.tryOpenChest(blockHitResult);
        }
    }

    private static boolean isLookingAt(List<class_2248> blocks) {
        class_239 class_2392;
        boolean allowCheck;
        boolean bl = allowCheck = HypixelCry.mc.field_1765 != null && HypixelCry.mc.field_1765.method_17783() == class_239.class_240.field_1332;
        if (allowCheck && (class_2392 = HypixelCry.mc.field_1765) instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            assert (HypixelCry.mc.field_1687 != null);
            return blocks.contains(HypixelCry.mc.field_1687.method_8320(blockHitResult.method_17777()).method_26204());
        }
        return false;
    }

    private static void tryOpenChest(class_3965 mouseOver) {
        if (mouseOver == null || mouseOver.method_17783() != class_239.class_240.field_1332 || openedChests.containsKey(mouseOver.method_17777())) {
            return;
        }
        AutoRightClick.simulateHumanClick(mouseOver);
    }

    private static void simulateHumanClick(class_3965 mop) {
        if (mop == null || mop.method_17777() == null) {
            return;
        }
        assert (HypixelCry.mc.field_1761 != null);
        class_1269 success = HypixelCry.mc.field_1761.method_2896(HypixelCry.mc.field_1724, class_1268.field_5808, mop);
        assert (HypixelCry.mc.field_1724 != null);
        HypixelCry.mc.field_1724.method_6104(class_1268.field_5808);
        class_2338 pos = mop.method_17777();
        if (HypixelCry.config.macros.autoRightClick.features.contains((Object)AutoRightClickOpenFeatures.Air) && !Utils.isInDungeons() && Utils.getLocation() != Location.PRIVATE_ISLAND) {
            class_2680 state = class_2246.field_10124.method_9564();
            assert (HypixelCry.mc.field_1687 != null);
            HypixelCry.mc.field_1687.method_8501(pos, state);
            HypixelCry.mc.field_1769.method_8570((class_1922)HypixelCry.mc.field_1687, pos, HypixelCry.mc.field_1687.method_8320(pos), state, 0);
            HypixelCry.mc.field_1687.method_8408(pos, class_2246.field_10124);
        }
        openedChests.put(mop.method_17777(), 0);
    }
}

