/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.pathfinder;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.events.world.ClientChunkLoadEvent;
import com.nekiplay.hypixelcry.pathfinder.calculate.Path;
import com.nekiplay.hypixelcry.pathfinder.calculate.path.AStarPathFinder;
import com.nekiplay.hypixelcry.pathfinder.goal.Goal;
import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_638;

public class PathFinderWorker {
    private static final ExecutorService PATH_FINDER_EXECUTOR = Executors.newFixedThreadPool(12);
    private static final Map<String, PathData> PATHS = new ConcurrentHashMap<String, PathData>();
    private static final Queue<PathResult> PATH_RESULTS = new ConcurrentLinkedQueue<PathResult>();
    private static final double RECALCULATION_DISTANCE = 9.0;
    private static final int CHUNK_UPDATE_RADIUS = 1;
    private static final int ENDPOINT_CHUNK_CHECK_RADIUS = 2;

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(PathFinderWorker::onRenderWorldLast);
        Scheduler.INSTANCE.scheduleCyclic(PathFinderWorker::onClientTick, 1);
        ClientChunkLoadEvent.EVENT.register(PathFinderWorker::chunkLoad);
    }

    private static void chunkLoad(class_638 clientWorld, class_2791 chunk) {
        if (HypixelCry.mc.field_1724 == null || HypixelCry.mc.field_1687 == null) {
            return;
        }
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        for (PathData pathData : PATHS.values()) {
            pathData.endpointChunksUpdated = true;
            pathData.needsUpdate = true;
        }
    }

    private static void onClientTick() {
        if (HypixelCry.mc.field_1724 == null || HypixelCry.mc.field_1687 == null) {
            return;
        }
        class_2338 currentPos = HypixelCry.mc.field_1724.method_24515().method_10069(0, -1, 0);
        PathFinderWorker.processPathResults();
        if (HypixelCry.config.misc.pathFinderESP.enabled) {
            PATHS.values().forEach(pathData -> {
                if (pathData.allow_update) {
                    PathFinderWorker.updatePath(currentPos, pathData);
                }
            });
        }
    }

    private static void processPathResults() {
        while (!PATH_RESULTS.isEmpty()) {
            PathResult result = PATH_RESULTS.poll();
            Optional.ofNullable(PATHS.get(result.pathId)).ifPresent(data -> {
                data.blocks = result.blocks;
                data.furthestReachedIndex = 0;
                data.currentVisibleFromIndex = 0;
                data.chunksUpdated = false;
                data.endpointChunksUpdated = false;
                data.needsUpdate = false;
            });
        }
    }

    private static void updatePath(class_2338 currentPos, PathData pathData) {
        PathFinderWorker.updateChunkData(currentPos, pathData);
        PathFinderWorker.updateRemainingPath(currentPos, pathData);
        if (PathFinderWorker.shouldRecalculatePath(currentPos, pathData)) {
            PathFinderWorker.recalculatePath(currentPos, pathData);
        }
    }

    private static void updateChunkData(class_2338 currentPos, PathData pathData) {
        int currentChunkX = currentPos.method_10263() >> 4;
        int currentChunkZ = currentPos.method_10260() >> 4;
        if (Math.abs(currentChunkX - pathData.lastChunkX) > 1 || Math.abs(currentChunkZ - pathData.lastChunkZ) > 1) {
            pathData.chunksUpdated = true;
            pathData.lastChunkX = currentChunkX;
            pathData.lastChunkZ = currentChunkZ;
        }
    }

    private static void recalculatePath(class_2338 currentPos, PathData pathData) {
        PATH_FINDER_EXECUTOR.submit(() -> {
            CalculationContext ctx = new CalculationContext();
            class_2338 targetPos = PathFinderWorker.getNearestLoadedPos(ctx, pathData.end);
            AStarPathFinder finder = new AStarPathFinder(currentPos.method_10263(), currentPos.method_10264(), currentPos.method_10260(), new Goal(targetPos.method_10263(), targetPos.method_10264(), targetPos.method_10260(), ctx), ctx);
            Optional<Path> calculatedPath = Optional.ofNullable(finder.calculatePath());
            calculatedPath.map(path -> pathData.smoothes ? path.getSmoothedPath() : path.getPath()).ifPresent(path -> {
                pathData.remainingPath = path;
                PATH_RESULTS.add(new PathResult(PathFinderWorker.getPathId(pathData), (List<class_2338>)path));
            });
        });
    }

    private static String getPathId(PathData pathData) {
        return PATHS.entrySet().stream().filter(entry -> entry.getValue() == pathData).map(Map.Entry::getKey).findFirst().orElse("");
    }

    private static class_2338 getNearestLoadedPos(CalculationContext ctx, class_2338 target) {
        int dz;
        class_2338 playerPos;
        if (ctx.getWorld().method_8477(target)) {
            return target;
        }
        class_2338 farthestLoaded = playerPos = HypixelCry.mc.field_1724.method_24515();
        int dx = target.method_10263() - playerPos.method_10263();
        double length = Math.sqrt(dx * dx + (dz = target.method_10260() - playerPos.method_10260()) * dz);
        if (length <= 0.0) {
            return playerPos;
        }
        double stepX = (double)dx / length;
        double stepZ = (double)dz / length;
        int maxDistance = 256;
        for (int i2 = 1; i2 <= maxDistance; ++i2) {
            int checkX = playerPos.method_10263() + (int)(stepX * (double)i2);
            int checkZ = playerPos.method_10260() + (int)(stepZ * (double)i2);
            class_2338 checkPos = new class_2338(checkX, playerPos.method_10264(), checkZ);
            if (!ctx.getWorld().method_8477(checkPos)) break;
            farthestLoaded = checkPos;
        }
        return farthestLoaded;
    }

    private static boolean shouldRecalculatePath(class_2338 currentPos, PathData pathData) {
        if (pathData.needsUpdate || pathData.blocks.isEmpty()) {
            return true;
        }
        if (pathData.endpointChunksUpdated) {
            return true;
        }
        class_2338 endPos = pathData.blocks.getLast();
        double distanceToEnd = currentPos.method_10262((class_2382)endPos);
        if (distanceToEnd < 81.0) {
            return true;
        }
        if (!PathFinderWorker.isPathToLoadedArea(currentPos, pathData)) {
            return true;
        }
        class_2338 nearest = PathFinderWorker.findNearestPathPoint(currentPos, pathData.blocks);
        return nearest == null || currentPos.method_10262((class_2382)nearest) > 81.0;
    }

    private static boolean isPathToLoadedArea(class_2338 playerPos, PathData pathData) {
        if (HypixelCry.mc.field_1687 == null) {
            return false;
        }
        int checkLength = Math.min(5, pathData.blocks.size());
        for (int i2 = pathData.blocks.size() - 1; i2 >= pathData.blocks.size() - checkLength; --i2) {
            class_2338 pathPos = pathData.blocks.get(i2);
            if (HypixelCry.mc.field_1687.method_8477(pathPos)) continue;
            return false;
        }
        return true;
    }

    private static class_2338 findNearestPathPoint(class_2338 playerPos, List<class_2338> path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (path.size() < 2) {
            return path.getFirst();
        }
        return IntStream.range(0, path.size() - 1).mapToObj(i2 -> PathFinderWorker.getClosestPointOnSegment(playerPos, (class_2338)path.get(i2), (class_2338)path.get(i2 + 1))).min(Comparator.comparingDouble(arg_0 -> ((class_2338)playerPos).method_10262(arg_0))).orElse(null);
    }

    private static class_2338 getClosestPointOnSegment(class_2338 point, class_2338 start, class_2338 end) {
        double lineX = end.method_10263() - start.method_10263();
        double lineY = end.method_10264() - start.method_10264();
        double lineZ = end.method_10260() - start.method_10260();
        double pointX = point.method_10263() - start.method_10263();
        double pointY = point.method_10264() - start.method_10264();
        double pointZ = point.method_10260() - start.method_10260();
        double dot = pointX * lineX + pointY * lineY + pointZ * lineZ;
        double t = Math.max(0.0, Math.min(1.0, dot / (lineX * lineX + lineY * lineY + lineZ * lineZ)));
        return new class_2338((int)((double)start.method_10263() + t * lineX), (int)((double)start.method_10264() + t * lineY), (int)((double)start.method_10260() + t * lineZ));
    }

    private static void updateRemainingPath(class_2338 playerPos, PathData pathData) {
        if (pathData.remainingPath.isEmpty()) {
            return;
        }
        class_2338 nearest = PathFinderWorker.findNearestPathPoint(playerPos, pathData.remainingPath);
        if (nearest == null) {
            return;
        }
        int nearestIndex = pathData.remainingPath.indexOf(nearest);
        if (nearestIndex > 0) {
            pathData.remainingPath = pathData.remainingPath.subList(nearestIndex, pathData.remainingPath.size());
        }
    }

    private static void onRenderWorldLast(WorldRenderContext context) {
        if (HypixelCry.mc.field_1687 == null || PATHS.isEmpty() || !HypixelCry.config.esp.pathFinderESP.enabled) {
            return;
        }
        PATHS.values().forEach(pathData -> PathFinderWorker.renderPath(pathData, context));
    }

    private static void renderPath(PathData pathData, WorldRenderContext context) {
        if (pathData.blocks == null || pathData.blocks.isEmpty() || pathData.remainingPath.isEmpty()) {
            return;
        }
        class_2338 endPos = pathData.blocks.getLast();
        PathFinderWorker.renderPathLines(pathData, endPos, context);
        PathFinderWorker.renderEndPoint(pathData, endPos, context);
    }

    private static void renderPathLines(PathData pathData, class_2338 endPos, WorldRenderContext context) {
        class_2338 prevPos = pathData.blocks.getFirst();
        PathFinderWorker.renderStartPoint(pathData, prevPos, context);
        for (int i2 = 1; i2 < pathData.blocks.size(); ++i2) {
            class_2338 currentPos = pathData.blocks.get(i2);
            class_243[] points = new class_243[]{prevPos.method_46558(), currentPos.method_46558()};
            RenderHelper.renderLinesFromPoints(context, points, pathData.color, pathData.color[3], 3.0f, true);
            if (HypixelCry.config.esp.pathFinderESP.enableSubPoints) {
                RenderHelper.renderFilled(context, currentPos, pathData.color, pathData.color[3], true);
                RenderHelper.renderOutline(context, currentPos, pathData.color, 1.0f, true);
            }
            prevPos = currentPos;
        }
    }

    private static void renderStartPoint(PathData pathData, class_2338 startPos, WorldRenderContext context) {
        RenderHelper.renderFilled(context, startPos, pathData.color, pathData.color[3], true);
        RenderHelper.renderOutline(context, startPos, pathData.color, 4.0f, true);
    }

    private static void renderEndPoint(PathData pathData, class_2338 endPos, WorldRenderContext context) {
        RenderHelper.renderFilled(context, endPos, pathData.color, pathData.color[3], true);
        RenderHelper.renderOutline(context, endPos, pathData.color, 4.0f, true);
        int r = (int)(pathData.color[0] * 255.0f);
        int g = (int)(pathData.color[1] * 255.0f);
        int b = (int)(pathData.color[2] * 255.0f);
        int color = 0xFF000000 | r << 16 | g << 8 | b;
        RenderHelper.renderText(context, class_2561.method_30163((String)pathData.endText).method_30937(), endPos.method_46558().method_1031(0.0, 1.0, 0.0), color, 1.0f, 0.5f, true);
    }

    public static void addOrUpdatePath(String id, class_2338 end, float[] color, String endText, boolean smooth, boolean allow_update) {
        PathData newData = new PathData(end, color, endText);
        if (!end.equals(Optional.ofNullable(PATHS.get(id)).map(data -> data.end).orElse(null))) {
            newData.needsUpdate = true;
        }
        newData.smoothes = smooth;
        newData.allow_update = allow_update;
        PATHS.put(id, newData);
    }

    public static void removePath(String id) {
        PATHS.remove(id);
    }

    public static void clearAllPaths() {
        PATHS.clear();
    }

    public static boolean hasPath(String id) {
        return PATHS.containsKey(id);
    }

    public static List<class_2338> getPathBlocks(String id) {
        PathData data = PATHS.get(id);
        return data != null ? new ArrayList<class_2338>(data.blocks) : Collections.emptyList();
    }

    public static void shutdown() {
        PATH_FINDER_EXECUTOR.shutdownNow();
    }

    public static class PathData {
        public final class_2338 end;
        public final float[] color;
        public final String endText;
        public List<class_2338> blocks = new ArrayList<class_2338>();
        public List<class_2338> remainingPath = new ArrayList<class_2338>();
        public int furthestReachedIndex = 0;
        public int currentVisibleFromIndex = 0;
        public boolean needsUpdate = true;
        public int lastChunkX = Integer.MIN_VALUE;
        public int lastChunkZ = Integer.MIN_VALUE;
        public boolean chunksUpdated = false;
        public boolean endpointChunksUpdated = false;
        public boolean smoothes = true;
        public boolean allow_update = true;

        public PathData(class_2338 end, float[] color, String endText) {
            this.end = end;
            this.color = color;
            this.endText = endText;
        }
    }

    private record PathResult(String pathId, List<class_2338> blocks) {
    }
}

