/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.lua.objects.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\t0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib;", "Lorg/luaj/vm2/lib/TwoArgFunction;", "<init>", "()V", "Lorg/luaj/vm2/LuaValue;", "modname", "env", "call", "(Lorg/luaj/vm2/LuaValue;Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gsonPretty", "SimpleParseFunction", "StringifyFunction", "hypixel-cry"})
public final class JsonLib
extends TwoArgFunction {
    @NotNull
    private final Gson gson = new Gson();
    private final Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();

    @Override
    @NotNull
    public LuaValue call(@NotNull LuaValue modname, @NotNull LuaValue env) {
        LuaTable luaTable;
        Intrinsics.checkNotNullParameter((Object)modname, (String)"modname");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        LuaTable $this$call_u24lambda_u240 = luaTable = LuaValue.tableOf();
        boolean bl = false;
        $this$call_u24lambda_u240.set("parse", (LuaValue)new SimpleParseFunction());
        $this$call_u24lambda_u240.set("stringify", (LuaValue)new StringifyFunction());
        LuaTable library = luaTable;
        env.set("json", (LuaValue)library);
        Intrinsics.checkNotNull((Object)library);
        return library;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\n\u001a\u00020\u00042\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0015\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib$SimpleParseFunction;", "Lorg/luaj/vm2/lib/OneArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib;)V", "Lorg/luaj/vm2/LuaValue;", "jsonString", "call", "(Lorg/luaj/vm2/LuaValue;)Lorg/luaj/vm2/LuaValue;", "", "map", "convertMap", "(Ljava/util/Map;)Lorg/luaj/vm2/LuaValue;", "", "list", "convertList", "(Ljava/util/List;)Lorg/luaj/vm2/LuaValue;", "", "value", "convertValue", "(Ljava/lang/Object;)Lorg/luaj/vm2/LuaValue;", "key", "convertKey", "convertPrimitive", "hypixel-cry"})
    @SourceDebugExtension(value={"SMAP\nJsonLib.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLib.kt\ncom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib$SimpleParseFunction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n216#2,2:132\n1878#3,3:134\n*S KotlinDebug\n*F\n+ 1 JsonLib.kt\ncom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib$SimpleParseFunction\n*L\n40#1:132,2\n48#1:134,3\n*E\n"})
    public final class SimpleParseFunction
    extends OneArgFunction {
        @Override
        @NotNull
        public LuaValue call(@NotNull LuaValue jsonString) {
            LuaValue luaValue;
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            try {
                Object result;
                Object object = result = JsonLib.this.gson.fromJson(jsonString.tojstring(), Object.class);
                luaValue = object == null ? LuaValue.NIL : (object instanceof Map ? this.convertMap((Map)result) : (object instanceof List ? this.convertList((List)result) : this.convertPrimitive(result)));
                Intrinsics.checkNotNull((Object)luaValue);
            }
            catch (Exception e) {
                LuaValue luaValue2 = LuaValue.NIL;
                Intrinsics.checkNotNull((Object)luaValue2);
                luaValue = luaValue2;
            }
            return luaValue;
        }

        private final LuaValue convertMap(Map<?, ?> map) {
            LuaTable table = LuaValue.tableOf();
            Map<?, ?> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ?> element$iv;
                Map.Entry<?, ?> entry = element$iv = iterator.next();
                boolean bl = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                table.set(this.convertKey(key), this.convertValue(value));
            }
            Intrinsics.checkNotNull((Object)table);
            return table;
        }

        /*
         * WARNING - void declaration
         */
        private final LuaValue convertList(List<?> list) {
            LuaTable table = LuaValue.tableOf();
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int index = n;
                boolean bl = false;
                table.set(index + 1, this.convertValue(value));
            }
            Intrinsics.checkNotNull((Object)table);
            return table;
        }

        private final LuaValue convertValue(Object value) {
            LuaValue luaValue;
            Object object = value;
            if (object == null) {
                LuaValue luaValue2 = LuaValue.NIL;
                luaValue = luaValue2;
                Intrinsics.checkNotNullExpressionValue((Object)luaValue2, (String)"NIL");
            } else if (object instanceof String) {
                LuaString luaString = LuaValue.valueOf((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)luaString, (String)"valueOf(...)");
                luaValue = luaString;
            } else if (object instanceof Number) {
                LuaNumber luaNumber = LuaValue.valueOf(((Number)value).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)luaNumber, (String)"valueOf(...)");
                luaValue = luaNumber;
            } else if (object instanceof Boolean) {
                LuaBoolean luaBoolean = LuaValue.valueOf((Boolean)value);
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
                luaValue = luaBoolean;
            } else if (object instanceof Map) {
                luaValue = this.convertMap((Map)value);
            } else if (object instanceof List) {
                luaValue = this.convertList((List)value);
            } else {
                LuaString luaString = LuaValue.valueOf(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)luaString, (String)"valueOf(...)");
                luaValue = luaString;
            }
            return luaValue;
        }

        private final LuaValue convertKey(Object key) {
            LuaValue luaValue;
            Object object = key;
            if (object instanceof String) {
                LuaString luaString = LuaValue.valueOf((String)key);
                Intrinsics.checkNotNullExpressionValue((Object)luaString, (String)"valueOf(...)");
                luaValue = luaString;
            } else if (object instanceof Number) {
                LuaNumber luaNumber = LuaValue.valueOf(((Number)key).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)luaNumber, (String)"valueOf(...)");
                luaValue = luaNumber;
            } else {
                LuaString luaString = LuaValue.valueOf(String.valueOf(key));
                Intrinsics.checkNotNullExpressionValue((Object)luaString, (String)"valueOf(...)");
                luaValue = luaString;
            }
            return luaValue;
        }

        private final LuaValue convertPrimitive(Object value) {
            LuaValue luaValue;
            Object object = value;
            if (object instanceof String) {
                LuaString luaString = LuaValue.valueOf((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)luaString, (String)"valueOf(...)");
                luaValue = luaString;
            } else if (object instanceof Number) {
                LuaNumber luaNumber = LuaValue.valueOf(((Number)value).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)luaNumber, (String)"valueOf(...)");
                luaValue = luaNumber;
            } else if (object instanceof Boolean) {
                LuaBoolean luaBoolean = LuaValue.valueOf((Boolean)value);
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
                luaValue = luaBoolean;
            } else {
                LuaString luaString = LuaValue.valueOf(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)luaString, (String)"valueOf(...)");
                luaValue = luaString;
            }
            return luaValue;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib$StringifyFunction;", "Lorg/luaj/vm2/lib/VarArgFunction;", "<init>", "(Lcom/nekiplay/hypixelcry/features/lua/objects/misc/JsonLib;)V", "Lorg/luaj/vm2/Varargs;", "args", "Lorg/luaj/vm2/LuaValue;", "invoke", "(Lorg/luaj/vm2/Varargs;)Lorg/luaj/vm2/LuaValue;", "luaValue", "", "convertToJava", "(Lorg/luaj/vm2/LuaValue;)Ljava/lang/Object;", "table", "convertTable", "hypixel-cry"})
    public final class StringifyFunction
    extends VarArgFunction {
        @Override
        @NotNull
        public LuaValue invoke(@NotNull Varargs args) {
            LuaValue luaValue;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            try {
                LuaValue luaValue2 = args.arg(1);
                LuaValue indent2 = args.narg() > 1 ? args.arg(2) : LuaValue.NIL;
                Intrinsics.checkNotNull((Object)luaValue2);
                Object javaObj = this.convertToJava(luaValue2);
                String jsonString = indent2.isnil() ? JsonLib.this.gsonPretty.toJson(javaObj) : (indent2.isnumber() && indent2.todouble() == 0.0 || indent2.isboolean() && !indent2.toboolean() ? JsonLib.this.gson.toJson(javaObj) : JsonLib.this.gsonPretty.toJson(javaObj));
                luaValue = LuaValue.valueOf(jsonString);
                Intrinsics.checkNotNull((Object)luaValue);
            }
            catch (Exception e) {
                LuaValue luaValue3 = LuaValue.NIL;
                Intrinsics.checkNotNull((Object)luaValue3);
                luaValue = luaValue3;
            }
            return luaValue;
        }

        private final Object convertToJava(LuaValue luaValue) {
            return luaValue.isnil() ? null : (luaValue.isstring() ? luaValue.tojstring() : (luaValue.isnumber() ? Double.valueOf(luaValue.todouble()) : (luaValue.isboolean() ? Boolean.valueOf(luaValue.toboolean()) : (luaValue.istable() ? this.convertTable(luaValue) : luaValue.tojstring()))));
        }

        private final Object convertTable(LuaValue table) {
            Map map = new LinkedHashMap();
            Object[] keys = table.checktable().keys();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])keys);
            while (iterator.hasNext()) {
                LuaValue key = (LuaValue)iterator.next();
                Map map2 = map;
                String string = key.tojstring();
                LuaValue luaValue = table.get(key);
                Intrinsics.checkNotNullExpressionValue((Object)luaValue, (String)"get(...)");
                Object object = this.convertToJava(luaValue);
                map2.put(string, object);
            }
            return map;
        }
    }
}

