/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.SystemUtils;

public class NotificationUtils {
    private static NotificationUtils instance;
    private final TrayIcon trayIcon;

    public NotificationUtils() {
        BufferedImage image2;
        if (!SystemUtils.IS_OS_WINDOWS || GraphicsEnvironment.isHeadless()) {
            this.trayIcon = null;
            return;
        }
        try {
            image2 = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/assets/hypixelcry/logo.png")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.trayIcon = new TrayIcon(image2, "Farm Helper Failsafe Notification");
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.setToolTip("Farm Helper Failsafe Notification");
        SystemTray tray = SystemTray.getSystemTray();
        try {
            tray.add(this.trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static NotificationUtils getInstance() {
        if (instance == null) {
            instance = new NotificationUtils();
        }
        return instance;
    }

    public void sendNotification(String title, String text2) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                if (GraphicsEnvironment.isHeadless()) {
                    System.out.println("Headless mode detected, cannot show system tray notification.");
                    return;
                }
                this.windows(title, text2);
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                this.mac(title, text2);
            } else if (SystemUtils.IS_OS_LINUX) {
                this.linux(title, text2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void windows(String title, String text2) {
        if (SystemTray.isSupported() && this.trayIcon != null) {
            try {
                this.trayIcon.displayMessage("Farm Helper", text2, TrayIcon.MessageType.INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("SystemTray is not supported or trayIcon is null");
        }
    }

    private void mac(String title, String text2) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("osascript", "-e", "display notification \"" + text2 + "\" with title \"" + title + "\"");
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void linux(String title, String text2) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("notify-send", "-a", title, text2);
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

